/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.olap.mdx.calc.impl.func;

import java.util.Iterator;
import kd.bos.algo.olap.Member;
import kd.bos.algo.olap.OlapException;
import kd.bos.algo.olap.collection.IList;
import kd.bos.algo.olap.collection.IMemberList;
import kd.bos.algo.olap.collection.ListFactoryFactory;
import kd.bos.algo.olap.mdx.Evaluator;
import kd.bos.algo.olap.mdx.Exp;
import kd.bos.algo.olap.mdx.calc.Calc;
import kd.bos.algo.olap.mdx.calc.ListCalc;
import kd.bos.algo.olap.mdx.calc.impl.AbstractListCalc;

public class AllLeafDescendantsCalc
extends AbstractListCalc {
    ListCalc listCalc;

    public AllLeafDescendantsCalc(Exp exp, ListCalc listCalc) {
        super(exp, new Calc[]{listCalc});
        this.listCalc = listCalc;
    }

    @Override
    public IList evaluateList(Evaluator evaluator) throws OlapException {
        IList memberList = this.listCalc.evaluateList(evaluator);
        if (memberList.isEmpty()) {
            return IMemberList.EMPTY;
        }
        IMemberList result = ListFactoryFactory.getListFactory().createMemberList();
        Iterator it = memberList.iterator();
        while (it.hasNext()) {
            Member obj = (Member)it.next();
            if (obj.isLeaf()) {
                result.add(obj);
                continue;
            }
            evaluator.getSchemaReader().getLeafDescendants(obj, result);
        }
        return result;
    }
}

