/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.olap.mdx.calc.impl.func;

import kd.bos.algo.olap.Dimension;
import kd.bos.algo.olap.Hierarchy;
import kd.bos.algo.olap.Level;
import kd.bos.algo.olap.Member;
import kd.bos.algo.olap.OlapException;
import kd.bos.algo.olap.collection.IMemberList;
import kd.bos.algo.olap.mdx.Evaluator;
import kd.bos.algo.olap.mdx.Exp;
import kd.bos.algo.olap.mdx.calc.Calc;
import kd.bos.algo.olap.mdx.calc.DimensionCalc;
import kd.bos.algo.olap.mdx.calc.LevelCalc;
import kd.bos.algo.olap.mdx.calc.Scope;
import kd.bos.algo.olap.mdx.calc.impl.AbstractMemberCalc;
import kd.bos.algo.olap.mdx.calc.impl.ConstantCalc;
import kd.bos.algo.olap.mdx.calc.impl.func.LevelFirstMemberCalc;

public class DimensionFirstMemberCalc
extends AbstractMemberCalc {
    DimensionCalc dimensionCalc;

    public DimensionFirstMemberCalc(Exp exp, DimensionCalc dimensionCalc) {
        super(exp, new Calc[]{dimensionCalc});
        this.dimensionCalc = dimensionCalc;
    }

    @Override
    public Calc optimize(Scope scope, Evaluator evaluator) throws OlapException {
        Dimension dimension = this.dimensionCalc.evaluateDimension(null);
        Level level = dimension.getDefaultHierarchy().getLevels()[0];
        LevelCalc levelCalc = ConstantCalc.constantLevel(level);
        return new LevelFirstMemberCalc(null, levelCalc).optimize(scope, evaluator);
    }

    @Override
    public Member evaluateMember(Evaluator evaluator) throws OlapException {
        Dimension dimension = this.dimensionCalc.evaluateDimension(evaluator);
        Hierarchy hierarchy = dimension.getDefaultHierarchy();
        IMemberList list = evaluator.getSchemaReader().getHierarchyRootMembers(hierarchy);
        if (list.isEmpty()) {
            return hierarchy.getNullMember();
        }
        return (Member)list.getFirst();
    }
}

