/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.olap.mdx.calc.impl.func;

import kd.bos.algo.olap.OlapException;
import kd.bos.algo.olap.collection.IList;
import kd.bos.algo.olap.mdx.Evaluator;
import kd.bos.algo.olap.mdx.Exp;
import kd.bos.algo.olap.mdx.calc.Calc;
import kd.bos.algo.olap.mdx.calc.ListCalc;
import kd.bos.algo.olap.mdx.calc.Scope;
import kd.bos.algo.olap.mdx.calc.impl.AbstractListCalc;
import kd.bos.algo.olap.mdx.func.FuncUtil2;

public class HierarchizeCalc
extends AbstractListCalc {
    ListCalc listCalc;
    boolean post;
    boolean needHierarchize = true;

    public HierarchizeCalc(Exp exp, ListCalc listCalc, boolean post) {
        super(exp, new Calc[]{listCalc});
        this.listCalc = listCalc;
        this.post = post;
    }

    @Override
    public Calc optimize(Scope scope, Evaluator evaluator) throws OlapException {
        if (scope.getNeedHierarchize() == Scope.NeedHierarchize.No) {
            this.needHierarchize = false;
            this.listCalc = (ListCalc)this.listCalc.optimize(scope, evaluator);
        } else {
            Scope scope2 = scope.push(this.listCalc);
            scope2.setNeedHierarchize(Scope.NeedHierarchize.No);
            this.listCalc = (ListCalc)this.listCalc.optimize(scope2, evaluator);
        }
        return this;
    }

    @Override
    public IList evaluateList(Evaluator evaluator) throws OlapException {
        IList list = this.listCalc.evaluateList(evaluator);
        if (this.needHierarchize) {
            FuncUtil2.hierarchize(list, this.post);
        }
        return list;
    }
}

