/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.olap.mdx.calc.impl.func;

import kd.bos.algo.olap.Hierarchy;
import kd.bos.algo.olap.Member;
import kd.bos.algo.olap.OlapException;
import kd.bos.algo.olap.collection.IList;
import kd.bos.algo.olap.mdx.Evaluator;
import kd.bos.algo.olap.mdx.Exp;
import kd.bos.algo.olap.mdx.calc.Calc;
import kd.bos.algo.olap.mdx.calc.IntegerCalc;
import kd.bos.algo.olap.mdx.calc.ListCalc;
import kd.bos.algo.olap.mdx.calc.impl.AbstractMemberCalc;
import kd.bos.algo.olap.mdx.type.MemberType;
import kd.bos.algo.olap.mdx.type.SetType;
import kd.bos.algo.olap.mdx.type.Type;

public class ItemMemberCalc
extends AbstractMemberCalc {
    ListCalc listCalc;
    IntegerCalc intCalc;

    public ItemMemberCalc(Exp exp, ListCalc listCalc, IntegerCalc intCalc) {
        super(exp, new Calc[]{listCalc, intCalc});
        this.listCalc = listCalc;
        this.intCalc = intCalc;
    }

    @Override
    public Member evaluateMember(Evaluator evaluator) throws OlapException {
        int listSize;
        IList list = this.listCalc.evaluateList(evaluator);
        int index = this.intCalc.evaluateInteger(evaluator);
        if (index >= (listSize = list.size()) || index < 0) {
            return this.makeNullMember();
        }
        return (Member)list.get(index);
    }

    Member makeNullMember() {
        Type elementType = ((SetType)this.listCalc.getType()).getElementType();
        MemberType memberType = (MemberType)elementType;
        Hierarchy hierarchy = memberType.getHierarchy();
        if (hierarchy == null) {
            return null;
        }
        return hierarchy.getNullMember();
    }
}

