/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.olap.mdx.calc.impl.func;

import kd.bos.algo.olap.Level;
import kd.bos.algo.olap.Member;
import kd.bos.algo.olap.OlapException;
import kd.bos.algo.olap.collection.IMemberList;
import kd.bos.algo.olap.mdx.Evaluator;
import kd.bos.algo.olap.mdx.Exp;
import kd.bos.algo.olap.mdx.SchemaReader;
import kd.bos.algo.olap.mdx.calc.Calc;
import kd.bos.algo.olap.mdx.calc.LevelCalc;
import kd.bos.algo.olap.mdx.calc.MemberCalc;
import kd.bos.algo.olap.mdx.calc.impl.AbstractMemberCalc;

public class OpeningClosingCalc
extends AbstractMemberCalc {
    MemberCalc memberCalc;
    LevelCalc levelCalc;
    boolean opening;

    public OpeningClosingCalc(Exp call, LevelCalc levelCalc, MemberCalc memberCalc, boolean opening) {
        super(call, new Calc[]{levelCalc, memberCalc});
        this.memberCalc = memberCalc;
        this.levelCalc = levelCalc;
        this.opening = opening;
    }

    @Override
    public Member evaluateMember(Evaluator evaluator) throws OlapException {
        IMemberList children;
        Level level;
        Member member = this.memberCalc.evaluateMember(evaluator);
        if (this.levelCalc == null) {
            int targetDepth = member.getLevel().getDepth() + 1;
            Level[] levels = member.getHierarchy().getLevels();
            if (levels.length <= targetDepth) {
                return member.getHierarchy().getNullMember();
            }
            level = levels[targetDepth];
        } else {
            level = this.levelCalc.evaluateLevel(evaluator);
        }
        if (level.getDepth() < member.getLevel().getDepth()) {
            return member.getHierarchy().getNullMember();
        }
        if (level == member.getLevel()) {
            return member;
        }
        SchemaReader schemaReader = evaluator.getSchemaReader();
        byte levelDepth = level.getDepth();
        do {
            if ((children = schemaReader.getMemberChildren(member)).size() != 0) continue;
            return level.getHierarchy().getNullMember();
        } while ((member = this.opening ? (Member)children.getFirst() : (Member)children.getLast()).getLevel().getDepth() != levelDepth);
        return member;
    }
}

