/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.olap.mdx.calc.impl.func;

import kd.bos.algo.olap.OlapException;
import kd.bos.algo.olap.collection.IList;
import kd.bos.algo.olap.mdx.Evaluator;
import kd.bos.algo.olap.mdx.Exp;
import kd.bos.algo.olap.mdx.calc.Calc;
import kd.bos.algo.olap.mdx.calc.IntegerCalc;
import kd.bos.algo.olap.mdx.calc.ListCalc;
import kd.bos.algo.olap.mdx.calc.impl.AbstractListCalc;

public class SubsetCalc
extends AbstractListCalc {
    ListCalc listCalc;
    IntegerCalc startCalc;
    IntegerCalc countCalc;

    public SubsetCalc(Exp exp, ListCalc listCalc, IntegerCalc startCalc, IntegerCalc countCalc) {
        super(exp, new Calc[]{listCalc, startCalc, countCalc});
        this.listCalc = listCalc;
        this.startCalc = startCalc;
        this.countCalc = countCalc;
    }

    @Override
    public IList evaluateList(Evaluator evaluator) throws OlapException {
        int end;
        IList list = this.listCalc.evaluateList(evaluator);
        int start = this.startCalc.evaluateInteger(evaluator);
        if (this.countCalc != null) {
            int count = this.countCalc.evaluateInteger(evaluator);
            end = start + count;
        } else {
            end = list.size();
        }
        if (end > list.size()) {
            end = list.size();
        }
        if (start >= end || start < 0) {
            return IList.EMPTY;
        }
        if (start == 0 && end == list.size()) {
            return list;
        }
        return list.subList(start, end);
    }
}

