/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.olap.mdx.elementexp;

import kd.bos.algo.olap.Member;
import kd.bos.algo.olap.OlapException;
import kd.bos.algo.olap.mdx.Evaluator;
import kd.bos.algo.olap.mdx.Exp;
import kd.bos.algo.olap.mdx.ExpBase;
import kd.bos.algo.olap.mdx.ExpResolver;
import kd.bos.algo.olap.mdx.calc.Calc;
import kd.bos.algo.olap.mdx.calc.ExpCompiler;
import kd.bos.algo.olap.mdx.calc.impl.ConstantCalc;
import kd.bos.algo.olap.mdx.type.MemberType;
import kd.bos.algo.olap.mdx.type.Type;

public class MemberExpr
extends ExpBase
implements Exp {
    private final Member member;

    public MemberExpr(Member member) {
        this.member = member;
    }

    public Member getMember() {
        return this.member;
    }

    public String toString() {
        return this.member.getUniqueName();
    }

    @Override
    public Type getType() {
        return MemberType.forMember(this.member);
    }

    @Override
    public Object clone() {
        return new MemberExpr(this.member);
    }

    @Override
    public int getCategory() {
        return 6;
    }

    @Override
    public Calc compile(ExpCompiler compiler) {
        return ConstantCalc.constantMember(this.member);
    }

    @Override
    public Exp resolve(ExpResolver resolver) throws OlapException {
        return this;
    }

    public Object evaluate(Evaluator evaluator) throws OlapException {
        return this.member;
    }

    public boolean equals(Object x) {
        if (x instanceof MemberExpr) {
            return this.member.equals(((MemberExpr)x).member);
        }
        return false;
    }
}

