/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.olap.mdx.func;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.olap.Aggregator;
import kd.bos.algo.olap.AvgValue;
import kd.bos.algo.olap.CalculatedMember;
import kd.bos.algo.olap.Cube;
import kd.bos.algo.olap.Dimension;
import kd.bos.algo.olap.Hierarchy;
import kd.bos.algo.olap.Level;
import kd.bos.algo.olap.Member;
import kd.bos.algo.olap.OlapException;
import kd.bos.algo.olap.collection.DefaultListFactory;
import kd.bos.algo.olap.collection.IList;
import kd.bos.algo.olap.collection.IMemberList;
import kd.bos.algo.olap.collection.ListFactoryFactory;
import kd.bos.algo.olap.exception.TooManyMemberException;
import kd.bos.algo.olap.impl.WeightCalculation;
import kd.bos.algo.olap.mdx.Evaluator;
import kd.bos.algo.olap.mdx.Exp;
import kd.bos.algo.olap.mdx.Literal;
import kd.bos.algo.olap.mdx.SchemaLookup;
import kd.bos.algo.olap.mdx.SchemaReader;
import kd.bos.algo.olap.mdx.Syntax;
import kd.bos.algo.olap.mdx.calc.BigDecimalCalc;
import kd.bos.algo.olap.mdx.calc.Calc;
import kd.bos.algo.olap.mdx.calc.impl.ValueCalc;
import kd.bos.algo.olap.mdx.type.ScalarType;
import kd.bos.algo.olap.mdx.type.Type;
import kd.bos.algo.olap.mdx.type.TypeUtil;
import kd.bos.algo.olap.util.ArrayHolder;
import kd.bos.algo.olap.util.BreakArrayCalcComparator;
import kd.bos.algo.olap.util.BreakMemberComparator;
import kd.bos.algo.olap.util.EnumeratedValues;
import kd.bos.algo.olap.util.HierarchicalArrayCalcComparator;
import kd.bos.algo.olap.util.HierarchicalMemberComparator;
import kd.bos.algo.olap.util.HierarchizeArrayComparator;
import kd.bos.algo.olap.util.HierarchizeComparator;
import kd.bos.algo.olap.util.ObjectComparator;
import kd.bos.algo.olap.util.ReverseComparator;
import kd.bos.algo.olap.util.Util;
import kd.bos.algo.olap.util.ValueNotReady;

public class FuncUtil2
extends Util {
    static final String nl = System.getProperty("line.separator");

    static String getLiteralArg(Exp[] args, int i, String defaultValue, String[] allowedValues) throws OlapException {
        if (i >= args.length) {
            return defaultValue;
        }
        Exp arg = args[i];
        if (!(arg instanceof Literal) || arg.getCategory() != 11) {
            throw new OlapException("Expected a symbol, found '" + arg + "'");
        }
        String s = (String)((Literal)arg).getValueObject();
        StringBuffer sb = new StringBuffer(64);
        for (int j = 0; j < allowedValues.length; ++j) {
            String allowedValue = allowedValues[j];
            if (allowedValue.equalsIgnoreCase(s)) {
                return allowedValue;
            }
            if (j > 0) {
                sb.append(", ");
            }
            sb.append(allowedValue);
        }
        throw new OlapException("Allowed values are: {" + sb + "}");
    }

    static int getLiteralArg(Exp[] args, int i, int defaultValue, EnumeratedValues allowedValues) throws OlapException {
        String literal = FuncUtil2.getLiteralArg(args, i, allowedValues.getName(defaultValue), allowedValues.getNames());
        return literal == null ? -1 : allowedValues.getOrdinal(literal);
    }

    public static IList nonFactEmptyMembers(Evaluator evaluator, IList members) {
        block4: {
            Object o;
            block5: {
                if (members == null || members.size() == 0) {
                    return members;
                }
                if (!evaluator.isNonFactEmpty() && (!evaluator.isNonEmpty() || evaluator.getContext().hasFormulas())) break block4;
                o = members.getFirst();
                if (!(o instanceof Member)) break block5;
                Iterator iter = members.iterator();
                while (iter.hasNext()) {
                    Member m = (Member)iter.next();
                    if (m.hasData() || m.maybeNeedCalc()) continue;
                    iter.remove();
                }
                break block4;
            }
            if (!(o instanceof Member[])) break block4;
            Iterator iter = members.iterator();
            block1: while (iter.hasNext()) {
                Member[] ms = (Member[])iter.next();
                for (int i = 0; i < ms.length; ++i) {
                    if (ms[i].hasData() || ms[i].maybeNeedCalc()) continue;
                    iter.remove();
                    continue block1;
                }
            }
        }
        return members;
    }

    public static IMemberList nonFactEmptyMembers(Evaluator evaluator, IMemberList members) {
        if (members == null || members.size() == 0) {
            return members;
        }
        if (evaluator.isNonFactEmpty() || evaluator.isNonEmpty() && !evaluator.getContext().hasFormulas()) {
            Iterator iter = members.iterator();
            while (iter.hasNext()) {
                Member m = (Member)iter.next();
                if (m.hasData() || m.maybeNeedCalc()) continue;
                iter.remove();
            }
        }
        return members;
    }

    static void checkCompatible(Exp left, Exp right, String funName) throws OlapException {
        Type rightType;
        Type leftType = TypeUtil.stripSetType(left.getType());
        if (!TypeUtil.isUnionCompatible(leftType, rightType = TypeUtil.stripSetType(right.getType()))) {
            throw new OlapException("Expressions " + funName + " must have the same hierarchy");
        }
    }

    public static boolean checkFlag(int value, int mask, boolean strict) {
        return strict ? (value & mask) == mask : (value & mask) != 0;
    }

    public static IMemberList getHierarchizeMembers(SchemaReader schemaReader, Hierarchy hierarchy) throws OlapException {
        return schemaReader.getHierarchyMembers(hierarchy, true);
    }

    public static IMemberList getHierarchizeMembers(SchemaReader schemaReader, Hierarchy hierarchy, boolean hierarchize) throws OlapException {
        return schemaReader.getHierarchyMembers(hierarchy, hierarchize);
    }

    static boolean isAncestorOf(Member m0, Member m1, boolean strict) throws OlapException {
        if (strict) {
            if (m1 == null) {
                return false;
            }
            m1 = m1.getParentMember();
        }
        while (m1 != null) {
            if (Util.equals(m1, m0)) {
                return true;
            }
            m1 = m1.getParentMember();
        }
        return false;
    }

    public static boolean hasMeasure(Member[] members) {
        if (members == null) {
            return false;
        }
        for (int i = 0; i < members.length; ++i) {
            if (!members[i].isMeasure()) continue;
            return true;
        }
        return false;
    }

    public static IList nonEmptyListUsingIntelligenceMeasures(Evaluator evaluator, IList list) throws OlapException {
        if (list.isEmpty()) {
            return list;
        }
        boolean b = false;
        b = list.getFirst() instanceof Member ? ((Member)list.getFirst()).isMeasure() : FuncUtil2.hasMeasure((Member[])list.getFirst());
        if (!b) {
            b = FuncUtil2.hasMeasure(evaluator.getSlicerMember());
        }
        if (b) {
            return FuncUtil2.nonEmptyList(evaluator, list, null);
        }
        return FuncUtil2.nonEmptyListUsingMeasures(evaluator, list);
    }

    public static IList nonEmptyListUsingMeasures(Evaluator evaluator, IList list) throws OlapException {
        IList measureList = DefaultListFactory.instance.createArrayList();
        Member[] measures = evaluator.getCube().getMeasures();
        for (int i = 0; i < measures.length; ++i) {
            measureList.add(measures[i]);
        }
        return FuncUtil2.nonEmptyList(evaluator, list, measureList);
    }

    public static IList nonEmptyList(Evaluator evaluator, IList list, IList operList) throws OlapException {
        return FuncUtil2.nonEmptyList(evaluator, list, operList, false, -1);
    }

    public static IList nonEmptyList(Evaluator evaluator, IList list, IList operList, boolean removeHidden, int count) throws OlapException {
        if (list.isEmpty()) {
            return list;
        }
        IList result = ListFactoryFactory.getListFactory().createArrayList();
        evaluator = evaluator.push();
        evaluator.setNonEmpty(true);
        if (count < 0) {
            count = list.size();
        }
        if (list.getFirst() instanceof Member[]) {
            Iterator it = list.iterator();
            block0: while (it.hasNext() && result.size() < count) {
                Member[] m = (Member[])it.next();
                if (removeHidden && !Util.isVisible(m)) continue;
                evaluator.setContext(m);
                if (operList == null || operList.size() == 0) {
                    Object value = evaluator.evaluateCurrent();
                    if (value == null || value == Util.nullValue || value == ValueNotReady.instance || value instanceof Throwable) continue;
                    result.add(m);
                    continue;
                }
                boolean istuple = false;
                if (operList.getFirst() instanceof Member[]) {
                    istuple = true;
                }
                Iterator it2 = operList.iterator();
                while (it2.hasNext()) {
                    Object value;
                    if (istuple) {
                        evaluator.setContext((Member[])it2.next());
                    } else {
                        evaluator.setContext((Member)it2.next());
                    }
                    if ((value = evaluator.evaluateCurrent()) == null || value == Util.nullValue || value == ValueNotReady.instance || value instanceof Throwable) continue;
                    result.add(m);
                    continue block0;
                }
            }
        } else {
            Iterator it = list.iterator();
            block2: while (it.hasNext() && result.size() < count) {
                Member m = (Member)it.next();
                if (removeHidden && !m.isVisible()) continue;
                evaluator.setContext(m);
                if (operList == null || operList.size() == 0) {
                    Object value = evaluator.evaluateCurrent();
                    if (value == null || value == Util.nullValue || value == ValueNotReady.instance || value instanceof Throwable) continue;
                    result.add(m);
                    continue;
                }
                boolean istuple = false;
                if (operList.getFirst() instanceof Member[]) {
                    istuple = true;
                }
                Iterator it2 = operList.iterator();
                while (it2.hasNext()) {
                    Object value;
                    if (istuple) {
                        evaluator.setContext((Member[])it2.next());
                    } else {
                        evaluator.setContext((Member)it2.next());
                    }
                    if ((value = evaluator.evaluateCurrent()) == null || value == Util.nullValue || value == ValueNotReady.instance || value instanceof Throwable) continue;
                    result.add(m);
                    continue block2;
                }
            }
        }
        return result;
    }

    public static Syntax decodeSyntacticType(String flags) {
        char c = flags.charAt(0);
        switch (c) {
            case 'p': {
                return Syntax.Property;
            }
            case 'f': {
                return Syntax.Function;
            }
            case 'm': {
                return Syntax.Method;
            }
            case 'i': {
                return Syntax.Infix;
            }
            case 'P': {
                return Syntax.Prefix;
            }
            case 'I': {
                return Syntax.Internal;
            }
        }
        throw Util.newInternal("unknown syntax code '" + c + "' in string '" + flags + "'");
    }

    public static int decodeReturnCategory(String flags) {
        int returnCategory = FuncUtil2.decodeCategory(flags, 1);
        if ((returnCategory & 0x1F) != returnCategory) {
            throw Util.newInternal("bad return code flag in flags '" + flags + "'");
        }
        return returnCategory;
    }

    public static int decodeCategory(String flags, int offset) {
        char c = flags.charAt(offset);
        switch (c) {
            case 'a': {
                return 1;
            }
            case 'd': {
                return 2;
            }
            case 'h': {
                return 3;
            }
            case 'l': {
                return 4;
            }
            case 'b': {
                return 5;
            }
            case 'm': {
                return 6;
            }
            case 'N': {
                return 71;
            }
            case 'n': {
                return 7;
            }
            case 'x': {
                return 8;
            }
            case '#': {
                return 73;
            }
            case 'S': {
                return 9;
            }
            case 't': {
                return 10;
            }
            case 'v': {
                return 13;
            }
            case 'y': {
                return 11;
            }
        }
        throw Util.newInternal("unknown type code '" + c + "' in string '" + flags + "'");
    }

    public static int[] decodeArgCategory(String flags) {
        int[] argCategorys = new int[flags.length() - 2];
        for (int i = 0; i < argCategorys.length; ++i) {
            argCategorys[i] = FuncUtil2.decodeCategory(flags, i + 2);
        }
        return argCategorys;
    }

    public static Object min(Evaluator evaluator, IList members, Calc calc) throws OlapException {
        SetWrapper sw = FuncUtil2.evaluateSet(evaluator, members, calc);
        if (sw.notReadyCount > 0) {
            return ValueNotReady.instance;
        }
        if (sw.errorCount > 0) {
            return Util.nullValue;
        }
        if (sw.v.size() == 0) {
            return Util.nullValue;
        }
        Number min = new Double(Double.MAX_VALUE);
        for (int i = 0; i < sw.v.size(); ++i) {
            Number iValue = (Number)sw.v.get(i);
            if (!(iValue.doubleValue() < min)) continue;
            min = iValue;
        }
        return min;
    }

    public static Object max(Evaluator evaluator, IList members, Calc calc) throws OlapException {
        SetWrapper sw = FuncUtil2.evaluateSet(evaluator, members, calc);
        if (sw.notReadyCount > 0) {
            return ValueNotReady.instance;
        }
        if (sw.errorCount > 0) {
            return Util.nullValue;
        }
        if (sw.v.size() == 0) {
            return Util.nullValue;
        }
        Number max = Integer.MIN_VALUE;
        for (int i = 0; i < sw.v.size(); ++i) {
            Number iValue = (Number)sw.v.get(i);
            if (!(iValue.doubleValue() > ((Number)max).doubleValue())) continue;
            max = iValue;
        }
        return max;
    }

    public static Object avg(Evaluator evaluator, IList members, boolean includeEmpty, Calc calc) throws OlapException {
        SetWrapper sw = FuncUtil2.evaluateSet(evaluator, members, calc);
        if (sw.notReadyCount > 0) {
            return ValueNotReady.instance;
        }
        return sw.errorCount > 0 || sw.v.size() == 0 ? Util.nullValue : FuncUtil2._avg(sw, includeEmpty);
    }

    public static Object avg(Evaluator evaluator, IList members, Calc calc) throws OlapException {
        SetWrapper sw = FuncUtil2.evaluateSet(evaluator, members, calc);
        if (sw.notReadyCount > 0) {
            return ValueNotReady.instance;
        }
        return sw.errorCount > 0 || sw.v.size() == 0 ? Util.nullValue : FuncUtil2._avg(sw, false);
    }

    private static Object _avg(SetWrapper sw, boolean includeEmpty) throws OlapException {
        AvgValue avgValue = new AvgValue();
        for (int i = 0; i < sw.v.size(); ++i) {
            Object o = sw.v.get(i);
            if (o instanceof AvgValue) {
                avgValue.value = Util.add(avgValue.value, ((AvgValue)o).value);
                avgValue.count += ((AvgValue)o).count;
                continue;
            }
            avgValue.value = Util.add(avgValue.value, o);
            ++avgValue.count;
        }
        if (includeEmpty) {
            avgValue.count += sw.nullCount;
        }
        return avgValue;
    }

    public static Object npv(Evaluator evaluator, IList members, ValueCalc valueCalc, Calc rateCalc) throws OlapException {
        Object rete = rateCalc.evaluate(evaluator);
        SetWrapper sw = FuncUtil2.evaluateSet(evaluator, members, valueCalc);
        if (sw.notReadyCount > 0) {
            return ValueNotReady.instance;
        }
        if (sw.errorCount > 0) {
            return Util.nullValue;
        }
        if (sw.v.size() == 0) {
            return Util.nullValue;
        }
        double[] doubles = new double[sw.v.size()];
        for (int i = 0; i < sw.v.size(); ++i) {
            Object o = sw.v.get(i);
            if (o == null) continue;
            doubles[i] = Util.toDouble(o);
        }
        double rateDoubleValue = 0.0;
        if (rete != null) {
            rateDoubleValue = Util.toDouble(rete);
        }
        return FuncUtil2.npv(doubles, rateDoubleValue);
    }

    public static Object irr(Evaluator evaluator, IList members, ValueCalc valueCalc, BigDecimalCalc guessCalc) throws OlapException {
        SetWrapper sw = FuncUtil2.evaluateSet(evaluator, members, valueCalc);
        if (sw.notReadyCount > 0) {
            return ValueNotReady.instance;
        }
        if (sw.errorCount > 0) {
            return Util.nullValue;
        }
        if (sw.v.size() == 0) {
            return Util.nullValue;
        }
        double[] doubles = new double[sw.v.size()];
        int index = 0;
        for (int i = 0; i < sw.v.size(); ++i) {
            Object o = sw.v.get(i);
            if (o == null) continue;
            doubles[index++] = Util.toDouble(o);
        }
        if (index != sw.v.size()) {
            double[] subarray = new double[index];
            System.arraycopy(doubles, 0, subarray, 0, index);
            doubles = subarray;
        }
        BigDecimal guessValue = guessCalc.evaluateBigDecimal(evaluator);
        double guessDoubleValue = 0.1;
        if (guessValue != null) {
            guessDoubleValue = Util.toDouble(guessValue);
        }
        return FuncUtil2.irr(doubles, guessDoubleValue);
    }

    private static Object npv(double[] values, double rate) {
        double sum = 0.0;
        int pow = 0;
        for (double value : values) {
            sum += value / Math.pow(1.0 + rate, ++pow);
        }
        if (sum == 0.0) {
            return Util.nullValue;
        }
        return Util.toBigDecimal(sum);
    }

    public static Object irr(double[] values, double guess) {
        int maxIterationCount = 100;
        double absoluteAccuracy = 1.0E-7;
        double x0 = guess;
        for (int i = 0; i < maxIterationCount; ++i) {
            double fValue = 0.0;
            double fDerivative = 0.0;
            for (int k = 0; k < values.length; ++k) {
                fValue += values[k] / Math.pow(1.0 + x0, k);
                fDerivative += (double)(-k) * values[k] / Math.pow(1.0 + x0, k + 1);
            }
            double x1 = x0 - fValue / fDerivative;
            if (Math.abs(x1 - x0) <= absoluteAccuracy) {
                return Util.toBigDecimal(x1);
            }
            x0 = x1;
        }
        return Util.nullValue;
    }

    public static Object sum(Evaluator evaluator, IList members, Calc calc) throws OlapException {
        SetWrapper sw = FuncUtil2.evaluateSet(evaluator, members, calc);
        if (sw.notReadyCount > 0) {
            return ValueNotReady.instance;
        }
        if (sw.errorCount > 0) {
            return Util.nullValue;
        }
        if (sw.v.size() == 0) {
            return Util.nullValue;
        }
        Object sum = sw.v.get(0);
        for (int i = 1; i < sw.v.size(); ++i) {
            Object o = sw.v.get(i);
            sum = Util.add(sum, o);
        }
        return sum;
    }

    public static Object sumWithWeight(Evaluator evaluator, IList members, Calc calc) throws OlapException {
        SetWrapper sw = FuncUtil2.evaluateSetWithWeight(evaluator, members, calc);
        if (sw.notReadyCount > 0) {
            return ValueNotReady.instance;
        }
        if (sw.errorCount > 0) {
            return Util.nullValue;
        }
        if (sw.v.size() == 0) {
            return Util.nullValue;
        }
        Object sum = sw.v.get(0);
        for (int i = 1; i < sw.v.size(); ++i) {
            Object o = sw.v.get(i);
            sum = Util.add(sum, o);
        }
        return sum;
    }

    public static Object aggregate(Aggregator aggregator, Evaluator evaluator, IList members, Calc calc) throws OlapException {
        SetWrapper sw = FuncUtil2.evaluateSet(evaluator, members, calc);
        if (sw.notReadyCount > 0) {
            return ValueNotReady.instance;
        }
        if (sw.errorCount > 0) {
            return Util.nullValue;
        }
        if (sw.v.size() == 0) {
            return Util.nullValue;
        }
        Object sum = sw.v.get(0);
        for (int i = 1; i < sw.v.size(); ++i) {
            sum = aggregator.appendValue(sum, sw.v.get(i));
        }
        return sum;
    }

    public static Object count(Evaluator evaluator, IList members, boolean includeEmpty) throws OlapException {
        if (includeEmpty) {
            return members.size();
        }
        int retval = 0;
        Iterator iter = members.iterator();
        while (iter.hasNext()) {
            Object o;
            Object member = iter.next();
            if (member instanceof Member) {
                evaluator.setContext((Member)member);
            } else {
                evaluator.setContext((Member[])member);
            }
            if ((o = evaluator.evaluateCurrent()) == Util.nullValue || o == null) continue;
            ++retval;
        }
        return retval;
    }

    static SetWrapper evaluateSet(Evaluator evaluator, IList members, Calc calc) throws OlapException {
        SetWrapper retval = new SetWrapper();
        Iterator it = members.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            if (obj instanceof Member[]) {
                evaluator.setContext((Member[])obj);
            } else {
                evaluator.setContext((Member)obj);
            }
            Object o = calc.evaluate(evaluator);
            if (o == null || o == Util.nullValue) {
                ++retval.nullCount;
                continue;
            }
            if (o == ValueNotReady.instance) {
                ++retval.notReadyCount;
                continue;
            }
            if (o instanceof Throwable) {
                ++retval.errorCount;
                continue;
            }
            if (o instanceof BigDecimal || o instanceof Integer) {
                retval.v.add(o);
                continue;
            }
            if (o instanceof Number) {
                retval.v.add(Util.toBigDecimal((Number)o));
                continue;
            }
            if (o instanceof AvgValue) {
                retval.v.add(o);
                continue;
            }
            throw new OlapException("try to evaluator the value which is not Number type.");
        }
        return retval;
    }

    static SetWrapper evaluateSetWithWeight(Evaluator evaluator, IList members, Calc calc) throws OlapException {
        WeightCalculation wc = null;
        SetWrapper retval = new SetWrapper();
        if (members.isEmpty()) {
            return retval;
        }
        Object obj = members.getFirst();
        wc = obj instanceof Member ? new WeightCalculation(new Member[]{(Member)obj}) : new WeightCalculation((Member[])obj);
        if (!wc.hasWeight()) {
            wc = null;
        }
        Iterator it = members.iterator();
        while (it.hasNext()) {
            obj = it.next();
            if (obj instanceof Member[]) {
                evaluator.setContext((Member[])obj);
            } else {
                evaluator.setContext((Member)obj);
            }
            Object o = calc.evaluate(evaluator);
            if (o == null || o == Util.nullValue) {
                ++retval.nullCount;
                continue;
            }
            if (o == ValueNotReady.instance) {
                ++retval.notReadyCount;
                continue;
            }
            if (o instanceof Throwable) {
                ++retval.errorCount;
                continue;
            }
            if (o instanceof Number) {
                if (!(o instanceof BigDecimal)) {
                    o = new BigDecimal(o.toString());
                }
                if (wc != null) {
                    o = wc.calc(obj, o);
                }
                retval.v.add(o);
                continue;
            }
            throw new OlapException("try to evaluator the value which is not Number type.");
        }
        return retval;
    }

    public static Member ancestor(Evaluator evaluator, Member member, int distance, Level targetLevel) throws OlapException {
        if (targetLevel != null && member.getHierarchy() != targetLevel.getHierarchy()) {
            throw new OlapException(member.getUniqueName() + " is not in target Level " + targetLevel.getUniqueName() + "'s hierarchy.");
        }
        if (distance == 0) {
            return member;
        }
        if (distance < 0) {
            return member.getHierarchy().getNullMember();
        }
        IMemberList ancestors = member.getAncestorMembers();
        Member result = member.getHierarchy().getNullMember();
        Iterator iter = ancestors.iterator();
        while (iter.hasNext()) {
            Member ancestorMember = (Member)iter.next();
            if (targetLevel != null) {
                if (ancestorMember.getLevel() != targetLevel) continue;
                result = ancestorMember;
                break;
            }
            if (--distance != 0) continue;
            result = ancestorMember;
            break;
        }
        return result;
    }

    public static IMemberList periodsToDate(Evaluator evaluator, Level level, Member member) throws OlapException {
        Member m;
        if (member == null) {
            member = evaluator.getContext(level.getHierarchy().getDimension());
        }
        for (m = member; m != null && m.getLevel() != level; m = m.getParentMember()) {
        }
        IMemberList members = DefaultListFactory.instance.createMemberList();
        if (m != null) {
            SchemaReader reader = evaluator.getSchemaReader();
            m = SchemaLookup.getFirstDescendantOnLevel(reader, m, member.getLevel());
            reader.getMemberRange(level, m, member, members);
        }
        return members;
    }

    public static IMemberList memberRange(Evaluator evaluator, Member startMember, Member endMember) throws OlapException {
        Level level = startMember.getLevel();
        IMemberList members = DefaultListFactory.instance.createMemberList();
        evaluator.getSchemaReader().getMemberRange(level, startMember, endMember, members);
        if (members.isEmpty()) {
            evaluator.getSchemaReader().getMemberRange(level, endMember, startMember, members);
        }
        return members;
    }

    public static void sort(Evaluator evaluator, IList members, Calc exp, boolean desc, boolean brk) throws OlapException {
        ObjectComparator comparator;
        if (members.isEmpty()) {
            return;
        }
        Object first = members.getFirst();
        Map mapMemberToValue = null;
        if (first instanceof Member) {
            boolean parentsToo = !brk;
            mapMemberToValue = FuncUtil2.evaluateMembers(evaluator, exp, members, parentsToo);
            comparator = brk ? new BreakMemberComparator(mapMemberToValue, desc) : new HierarchicalMemberComparator(mapMemberToValue, desc);
        } else {
            int arity = ((Member[])first).length;
            if (brk) {
                comparator = new BreakArrayCalcComparator(evaluator, exp, arity);
                if (desc) {
                    comparator = new ReverseComparator(comparator);
                }
            } else {
                comparator = new HierarchicalArrayCalcComparator(evaluator, exp, arity, desc);
            }
        }
        members.sort(comparator);
    }

    public static Map evaluateMembers(Evaluator evaluator, Calc exp, IList members, boolean parentsToo) throws OlapException {
        assert (exp.getType() instanceof ScalarType);
        HashMap<Member, Object> mapMemberToValue = new HashMap<Member, Object>();
        Iterator iter = members.iterator();
        while (iter.hasNext()) {
            Member member = (Member)iter.next();
            do {
                evaluator.setContext(member);
                Object result = exp.evaluate(evaluator);
                if (result == null) {
                    result = Util.nullValue;
                }
                mapMemberToValue.put(member, result);
            } while (parentsToo && (member = member.getParentMember()) != null && !mapMemberToValue.containsKey(member));
        }
        return mapMemberToValue;
    }

    public static IList addUnique(IList left, IList right, Set set) {
        if (right == null) {
            return IList.EMPTY;
        }
        Iterator iter = right.iterator();
        while (iter.hasNext()) {
            Object o;
            Object p = o = iter.next();
            if (o instanceof Object[]) {
                p = new ArrayHolder((Object[])o);
            }
            if (!set.add(p)) continue;
            left.add(o);
        }
        return left;
    }

    public static int compareHierarchically(Member m1, Member m2, boolean post) throws OlapException {
        Member prev2;
        Member prev1;
        if (FuncUtil2.equals(m1, m2)) {
            return 0;
        }
        if (m1.isInner()) {
            return -1;
        }
        if (m2.isInner()) {
            return 1;
        }
        while (true) {
            int depth2;
            int depth1;
            if ((depth1 = m1.getDepth()) < (depth2 = m2.getDepth())) {
                if (!FuncUtil2.equals(m1, m2 = m2.getParentMember())) continue;
                return post ? 1 : -1;
            }
            if (depth1 > depth2) {
                if (!FuncUtil2.equals(m1 = m1.getParentMember(), m2)) continue;
                return post ? -1 : 1;
            }
            prev1 = m1;
            prev2 = m2;
            if (FuncUtil2.equals(m1 = m1.getParentMember(), m2 = m2.getParentMember())) break;
        }
        return FuncUtil2.compareSiblingMembers(prev1, prev2);
    }

    public static int compareSiblingMembers(Member m1, Member m2) {
        double ordinal2;
        double ordinal1 = m1.isCalculated() ? ((CalculatedMember)m1).getOrdinal2() : (double)m1.getOrdinal();
        return ordinal1 == (ordinal2 = m2.isCalculated() ? ((CalculatedMember)m2).getOrdinal2() : (double)m2.getOrdinal()) ? collator.compare(m1.getName(), m2.getName()) : (ordinal1 < ordinal2 ? -1 : 1);
    }

    public static void hierarchize(IList members, boolean post) throws OlapException {
        ObjectComparator comparator;
        if (members.isEmpty()) {
            return;
        }
        Object first = members.getFirst();
        if (first instanceof Member) {
            comparator = new HierarchizeComparator(post);
        } else {
            int arity = ((Member[])first).length;
            comparator = new HierarchizeArrayComparator(arity, post);
        }
        members.sort(comparator);
    }

    public static Level getTimeLevel(Cube cube, byte levelType) {
        Dimension[] dimensions = cube.getDimensions();
        for (int i = 0; i < dimensions.length; ++i) {
            Dimension dimension = dimensions[i];
            if (!dimension.isTimeDimension()) continue;
            Hierarchy[] hierarchies = dimension.getHierarchies();
            for (int j = 0; j < hierarchies.length; ++j) {
                Hierarchy hierarchy = hierarchies[j];
                Level[] levels = hierarchy.getLevels();
                for (int k = 0; k < levels.length; ++k) {
                    Level level = levels[k];
                    if (level.getLevelType() != levelType) continue;
                    return level;
                }
            }
        }
        return null;
    }

    public static void warmTooManyMember(long size) throws TooManyMemberException {
        if (size > 800000L) {
            throw new TooManyMemberException("data is too large, row or column cross member exceeds 800000.\r\n(please adjust the filter conditions to reduce the amount of data)");
        }
    }

    public static final void addAll(IList v, Object[] array) {
        v.addArray(array);
    }

    public static final void addAll(IList l1, IList l2) {
        l1.addList(l2);
    }

    public static final void addAll(IMemberList l1, IMemberList l2) {
        l1.addList(l2);
    }

    public static Member cousin(SchemaReader schemaReader, Member member, Member ancestorMember) throws OlapException {
        if (ancestorMember.isNull()) {
            return ancestorMember;
        }
        if (member.getHierarchy() != ancestorMember.getHierarchy()) {
            throw new OlapException("cousin must have same hierarchy between member and ancestor member.");
        }
        if (member.getLevel().getDepth() < ancestorMember.getLevel().getDepth()) {
            return ancestorMember.getHierarchy().getNullMember();
        }
        Member cousin = FuncUtil2.cousin2(schemaReader, member, ancestorMember);
        if (cousin == null) {
            cousin = ancestorMember.getHierarchy().getNullMember();
        }
        return cousin;
    }

    private static Member cousin2(SchemaReader schemaReader, Member member1, Member member2) throws OlapException {
        if (member1.getLevel() == member2.getLevel()) {
            return member2;
        }
        Member uncle = FuncUtil2.cousin2(schemaReader, member1.getParentMember(), member2);
        if (uncle == null) {
            return null;
        }
        int ordinal = SchemaLookup.getMemberOrdinalInParent(schemaReader, member1);
        IMemberList cousins = schemaReader.getMemberChildren(uncle);
        if (cousins.size() <= ordinal) {
            return null;
        }
        return (Member)cousins.get(ordinal);
    }

    static class SetWrapper {
        List v = new ArrayList();
        public int errorCount = 0;
        public int nullCount = 0;
        public int notReadyCount = 0;
        public boolean hasWeight;

        SetWrapper() {
        }
    }
}

