/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.olap.mdx.func;

import kd.bos.algo.olap.Hierarchy;
import kd.bos.algo.olap.Member;
import kd.bos.algo.olap.OlapException;
import kd.bos.algo.olap.mdx.Evaluator;
import kd.bos.algo.olap.mdx.Exp;
import kd.bos.algo.olap.mdx.FunCall;
import kd.bos.algo.olap.mdx.FunDefBase;
import kd.bos.algo.olap.mdx.calc.Calc;
import kd.bos.algo.olap.mdx.calc.ExpCompiler;
import kd.bos.algo.olap.mdx.calc.MemberCalc;
import kd.bos.algo.olap.mdx.calc.impl.AbstractHierarchyCalc;

public class MemberHierarchyFunDef
extends FunDefBase {
    static final MemberHierarchyFunDef instance = new MemberHierarchyFunDef();

    private MemberHierarchyFunDef() {
        super("Hierarchy", "<Member>.Hierarchy", "Returns a member's hierarchy.", "phm");
    }

    @Override
    public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
        MemberCalc memberCalc = compiler.compileMember(call.getArg(0));
        return new CalcImpl((Exp)call, memberCalc);
    }

    public static class CalcImpl
    extends AbstractHierarchyCalc {
        private final MemberCalc memberCalc;

        public CalcImpl(Exp exp, MemberCalc memberCalc) {
            super(exp, new Calc[]{memberCalc});
            this.memberCalc = memberCalc;
        }

        @Override
        public Hierarchy evaluateHierarchy(Evaluator evaluator) throws OlapException {
            Member member = this.memberCalc.evaluateMember(evaluator);
            return member.getHierarchy();
        }
    }
}

