/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.olap.mdx.func;

import kd.bos.algo.olap.Member;
import kd.bos.algo.olap.OlapException;
import kd.bos.algo.olap.mdx.Evaluator;
import kd.bos.algo.olap.mdx.Exp;
import kd.bos.algo.olap.mdx.ExpBase;
import kd.bos.algo.olap.mdx.ExpResolver;
import kd.bos.algo.olap.mdx.FunCall;
import kd.bos.algo.olap.mdx.FunDefBase;
import kd.bos.algo.olap.mdx.Syntax;
import kd.bos.algo.olap.mdx.calc.Calc;
import kd.bos.algo.olap.mdx.calc.ExpCompiler;
import kd.bos.algo.olap.mdx.calc.MemberCalc;
import kd.bos.algo.olap.mdx.calc.impl.AbstractCalc;
import kd.bos.algo.olap.mdx.type.NumericType;
import kd.bos.algo.olap.mdx.type.Type;

class ValueFunDef
extends FunDefBase {
    ValueFunDef(int[] argCategorys) {
        super("Value", "return the value of the tuple consisted of arguments.", Syntax.Function, 7, argCategorys);
    }

    @Override
    public void unparse(Exp[] args, StringBuilder sb) {
        ExpBase.unparseList(sb, args, "(", ", ", ")");
    }

    @Override
    public Type getResultType(ExpResolver resolver, Exp[] args) {
        return new NumericType();
    }

    @Override
    public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
        int argCount = call.getArgCount();
        final MemberCalc[] calcs = new MemberCalc[argCount];
        for (int i = 0; i < argCount; ++i) {
            calcs[i] = compiler.compileMember(call.getArg(i));
        }
        return new AbstractCalc(call){

            @Override
            public Object evaluate(Evaluator evaluator) throws OlapException {
                Member[] members = new Member[calcs.length];
                for (int i = 0; i < calcs.length; ++i) {
                    members[i] = calcs[i].evaluateMember(evaluator);
                    if (!members[i].isNull()) continue;
                    return null;
                }
                Evaluator evaluator2 = evaluator.push(members);
                return evaluator2.evaluateCurrent();
            }

            @Override
            public Calc[] getCalcs() {
                return calcs;
            }
        };
    }
}

