/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.olap.util;

import java.util.Comparator;

public class SortedArray {
    private static final int DEFAULT_INITIAL_CAPACITY = 1024;
    private static final float DEFAULT_RESIZE_FACTOR = 1.2f;
    Comparator compare;
    int size;
    Object[] array;
    private int initialCapacity;

    public SortedArray(Comparator compare, int initialCapacity) {
        this.compare = compare;
        this.initialCapacity = initialCapacity;
        this.array = new Object[initialCapacity];
    }

    public SortedArray(Comparator compare) {
        this(compare, 1024);
    }

    public final int find(Object obj) {
        int lo = 0;
        int hi = this.size - 1;
        while (lo <= hi) {
            int mid = (lo + hi) / 2;
            Object m = this.array[mid];
            int cmp = this.compare.compare(m, obj);
            if (cmp < 0) {
                lo = mid + 1;
                continue;
            }
            if (cmp > 0) {
                hi = mid - 1;
                continue;
            }
            return mid;
        }
        return 0 - (lo + 1);
    }

    public void add(Object obj) {
        int pos = this.find(obj);
        if (pos < 0) {
            pos = 0 - (pos + 1);
            this.checkSizeForAdd();
            if (pos < this.size) {
                System.arraycopy(this.array, pos, this.array, pos + 1, this.size - pos);
            }
            this.array[pos] = obj;
            ++this.size;
        }
    }

    public Object remove(Object obj) {
        return this.removeAt(this.find(obj));
    }

    public Object removeAt(int pos) {
        if (pos >= 0) {
            Object ret = this.array[pos];
            int next = pos + 1;
            if (next < this.size) {
                System.arraycopy(this.array, next, this.array, pos, this.size - next);
            }
            --this.size;
            return ret;
        }
        return null;
    }

    public int size() {
        return this.size;
    }

    public void clear() {
        this.array = new Object[this.initialCapacity];
    }

    public void purge() {
        if (this.array.length > this.size) {
            Object[] old = this.array;
            this.array = new Object[this.size];
            System.arraycopy(old, 0, this.array, 0, this.size);
        }
    }

    public final Object get(Object v) {
        int i = this.find(v);
        if (i > -1) {
            return this.array[i];
        }
        return null;
    }

    final void checkSizeForAdd() {
        if (this.size >= this.array.length) {
            Object[] old = this.array;
            this.array = new Object[(int)((float)old.length * 1.2f)];
            System.arraycopy(old, 0, this.array, 0, old.length);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.size; ++i) {
            sb.append("\n");
            sb.append(String.valueOf(i));
            sb.append(": ");
            sb.append(this.array[i]);
        }
        sb.append("\n");
        return sb.toString();
    }
}

