/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.olap.util;

import java.util.ArrayList;
import kd.bos.algo.olap.Member;
import kd.bos.algo.olap.OlapElement;
import kd.bos.algo.olap.OlapException;

public class UniqueNameUtil {
    public static final String MDX_QUOTE_LEFT_STANDARD = "[";
    public static final String MDX_QUOTE_RIGHT_STANDARD = "]";
    public static final String MDX_QUOTE_LEFT = "`";
    public static final String MDX_QUOTE_RIGHT = "`";
    public static final char MDX_QUOTE_LEFT_CHAR = '`';
    public static final char MDX_QUOTE_RIGHT_CHAR = '`';

    public static String makeUniqueName(OlapElement parent, String name) {
        if (parent == null) {
            return UniqueNameUtil.quoteMdxIdentifier(name);
        }
        StringBuilder buf = new StringBuilder(64);
        buf.append(parent.getUniqueName());
        buf.append('.');
        buf.append(UniqueNameUtil.quoteMdxIdentifier(name));
        return buf.toString();
    }

    private static String quoteMdxIdentifier(String name) {
        return "`" + name + "`";
    }

    public static void quoteMdxIdentifier(String name, StringBuilder sb) {
        sb.append("`").append(name).append("`");
    }

    public static String makeUniqueName(String parentUniqueName, String name) {
        if (parentUniqueName == null) {
            return UniqueNameUtil.quoteMdxIdentifier(name);
        }
        StringBuilder buf = new StringBuilder(64);
        buf.append(parentUniqueName);
        buf.append('.');
        buf.append(UniqueNameUtil.quoteMdxIdentifier(name));
        return buf.toString();
    }

    public static String makeUniqueName(String name) {
        return UniqueNameUtil.quoteMdxIdentifier(name);
    }

    public static String[] explode(Member parent, String name) {
        int depth = parent.getDepth();
        String[] ret = new String[depth + 2];
        ret[ret.length - 1] = name;
        while (parent != null) {
            ret[parent.getDepth()] = parent.getName();
            parent = parent.getParentMember();
        }
        return ret;
    }

    public static String[] explode(String s) throws OlapException {
        if ((s = s.trim()).indexOf("`") < 0 && s.indexOf(".") < 0) {
            return new String[]{s};
        }
        ArrayList<String> list = new ArrayList<String>(16);
        int i = 0;
        while (i < s.length()) {
            if (s.charAt(i) != '`') {
                throw new OlapException("Invalid member:" + s);
            }
            int j = s.indexOf("`.", i + 1);
            if (j == -1) {
                j = s.lastIndexOf("`");
            }
            if (j <= i) {
                throw new OlapException("Invalid member:" + s);
            }
            String sub = s.substring(i + 1, j);
            list.add(sub);
            if (j + 1 < s.length() && s.charAt(j + 1) != '.') {
                throw new OlapException("Invalid member:+s");
            }
            i = j + 2;
        }
        String[] names = list.toArray(new String[list.size()]);
        return names;
    }

    public static String trimBracketsAround(String orig) {
        if (orig.startsWith("`") && orig.endsWith("`")) {
            return orig.substring(1, orig.length() - 1);
        }
        return orig;
    }

    public static String createUniqueName(String[] names) {
        return UniqueNameUtil.createUniqueName(names, -1);
    }

    public static String convertToStandUniqueName(String uniqueName) {
        String[] strs;
        try {
            strs = UniqueNameUtil.explode(uniqueName);
        }
        catch (OlapException e) {
            e.printStackTrace();
            return null;
        }
        for (int i = 0; i < strs.length; ++i) {
            strs[i] = UniqueNameUtil.trimBracketsAround(strs[i]);
        }
        return UniqueNameUtil.createUniqueName(strs);
    }

    public static String extractDimUniqueName(String uniqueName) {
        String[] strs = UniqueNameUtil.splitUniqueName(uniqueName);
        return "`" + strs[0] + "`";
    }

    public static String parentFromUName(String uName) {
        String[] strs = UniqueNameUtil.splitUniqueName(uName);
        int n = strs.length;
        if (n < 3) {
            return null;
        }
        return UniqueNameUtil.createUniqueName(strs, n - 1);
    }

    public static String[] splitUniqueName(String uniqueName) {
        String str = uniqueName.trim();
        int l2 = str.length() - 1;
        if (str.charAt(0) != '`' || str.charAt(l2) != '`') {
            return new String[]{uniqueName};
        }
        str = str.substring(1, l2);
        String[] nameParts = str.split("`.`");
        return nameParts;
    }

    public static String createUniqueName(String[] strs, int n) {
        if (n <= 0) {
            n = strs.length;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                sb.append('.');
            }
            if (strs[i].startsWith("`")) {
                sb.append(strs[i]);
                continue;
            }
            sb.append("`");
            sb.append(strs[i]);
            sb.append("`");
        }
        return sb.toString();
    }
}

