/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.auth.authentication;

import com.auth0.jwt.algorithms.Algorithm;
import java.util.HashMap;
import kd.bos.mservice.auth.api.AuthContext;
import kd.bos.mservice.auth.api.AuthenticationService;
import kd.bos.mservice.auth.constant.AuthType;
import kd.bos.mservice.auth.context.JWTAuthContext;
import kd.bos.mservice.auth.exception.AuthErrorCode;
import kd.bos.mservice.auth.exception.AuthException;
import kd.bos.mservice.auth.factory.JWTAlgorithmFactory;
import kd.bos.mservice.auth.util.JWTUtils;

public class JWTAuthenticationServiceImpl
implements AuthenticationService {
    @Override
    public AuthContext authenticate(String tenantId, String accountId, String userId, String appNumber, String userToken) {
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("tenantId", tenantId);
            params.put("accountId", accountId);
            params.put("userId", userId);
            if (userToken != null) {
                params.put("userAuthToken", userToken);
            }
            if (userToken != null) {
                params.put("sourceAppNumber", appNumber);
            }
            Algorithm algorithm = JWTAlgorithmFactory.getAlgorithm();
            int expireSeconds = this.getExpireSeconds();
            String jwt = JWTUtils.generateJWT(algorithm, params, expireSeconds);
            return this.assembleAuthContext(jwt);
        }
        catch (Exception e) {
            throw new AuthException(e, AuthErrorCode.GENERATE_ERROR, new Object[0]);
        }
    }

    @Override
    public boolean isRenew(AuthContext ac) {
        JWTAuthContext authContext = (JWTAuthContext)ac;
        if (authContext != null && authContext.getJwtToken() != null && !"".equals(authContext.getJwtToken())) {
            long endTime = JWTUtils.getExpireTime(authContext.getJwtToken());
            return endTime < JWTUtils.getCurMillisTime(this.getExpireSeconds() - this.getValidRenewTime());
        }
        return false;
    }

    private int getValidRenewTime() {
        return Integer.getInteger("mservice.auth.valid.expire.seconds", 3600);
    }

    private int getExpireSeconds() {
        return Integer.getInteger("mservice.auth.jwt.expire.seconds", 7200);
    }

    private JWTAuthContext assembleAuthContext(String jwt) {
        JWTAuthContext authInfo = new JWTAuthContext();
        authInfo.setJwtToken(jwt);
        authInfo.setAuthType(AuthType.JWT.getCode());
        return authInfo;
    }
}

