/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.auth.intercept;

import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.mservice.auth.api.AuthContext;
import kd.bos.mservice.auth.api.AuthenticationService;
import kd.bos.mservice.auth.constant.AuthType;
import kd.bos.mservice.auth.intercept.CommonFilter;
import kd.bos.mservice.sdk.extension.SdkExtensionFactory;

public class AuthServiceFactory {
    private static AuthenticationService authenticationService = SdkExtensionFactory.getExtensionFacotry(AuthenticationService.class).getExtension(AuthType.getDefaultAuthType());
    private static Map<String, AuthContextWarpper> authMaps = new ConcurrentHashMap<String, AuthContextWarpper>(2);
    private static final int maxAuthcontextSize = Integer.getInteger("mservice.auth.contextcache.size", 3000);

    public static AuthContext createAuthContext(String tenantId, String accountId, String userId) {
        return AuthServiceFactory.createAuthContext(tenantId, accountId, userId, null, null);
    }

    public static AuthContext createAuthContextWithUserToken(String appNumber, String userToken) {
        return AuthServiceFactory.createAuthContext(null, null, null, appNumber, userToken);
    }

    public static AuthContext createAuthContext(String tenantId, String accountId, String userId, String appNumber, String userToken) {
        String key;
        AuthContext ac;
        if (!AuthServiceFactory.authEnable()) {
            return null;
        }
        if (authMaps.size() > maxAuthcontextSize) {
            AuthServiceFactory.rescale();
        }
        if (authenticationService.isRenew(ac = authMaps.computeIfAbsent(key = accountId + userId + appNumber + userToken, k -> new AuthContextWarpper(authenticationService.authenticate(tenantId, accountId, userId, appNumber, userToken))).get())) {
            ac = authenticationService.authenticate(tenantId, accountId, userId, appNumber, userToken);
            authMaps.put(key, new AuthContextWarpper(ac));
        }
        return ac;
    }

    private static synchronized void rescale() {
        if (authMaps.size() > maxAuthcontextSize - 1) {
            AuthServiceFactory.removeSecondsBefore(300);
        }
        if (authMaps.size() > maxAuthcontextSize - 1) {
            AuthServiceFactory.removeSecondsBefore(60);
        }
        if (authMaps.size() > maxAuthcontextSize - 1) {
            AuthServiceFactory.removeSecondsBefore(5);
        }
    }

    private static void removeSecondsBefore(int seconds) {
        HashSet rset = new HashSet(2);
        authMaps.forEach((k, v) -> {
            if (System.currentTimeMillis() - v.accessTime > (long)(seconds * 1000)) {
                rset.add(k);
            }
        });
        rset.forEach(k -> authMaps.remove(k));
    }

    private static boolean authEnable() {
        return Boolean.getBoolean("mservice.auth.enable");
    }

    public static void doAuth(AuthContext authContext) {
        CommonFilter.buildFilterChain(null, null).doFilter(authContext);
    }

    private static class AuthContextWarpper {
        AuthContext ac;
        long accessTime = 0L;

        AuthContextWarpper(AuthContext ac) {
            this.ac = ac;
            this.accessTime = System.currentTimeMillis();
        }

        AuthContext get() {
            this.accessTime = System.currentTimeMillis();
            return this.ac;
        }
    }
}

