/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.auth.util;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTCreator;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.interfaces.Clock;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.auth0.jwt.interfaces.Verification;
import java.io.IOException;
import java.security.Key;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.mservice.auth.util.BeijingClock;
import kd.bos.mservice.sdk.util.SdkJSONUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JWTUtils {
    private static final Logger log = LoggerFactory.getLogger(JWTUtils.class);
    private static final String JWT_SUBJECT = "kdjwt";
    private static final String JWT_ID = "kd";
    private static final String EXPIRE_TIME = "expireTime";

    public static String generateJWT(Algorithm algorithm, Map<String, String> parameters, int expireSeconds) {
        String jwtString = "";
        if (parameters != null && parameters.size() > 0) {
            BeijingClock clock = new BeijingClock();
            Date date = clock.getToday();
            long expireTime = date.getTime() + (long)(expireSeconds * 1000);
            parameters.put(EXPIRE_TIME, String.valueOf(expireTime));
            JWTCreator.Builder builder = JWT.create().withSubject(JWT_SUBJECT).withIssuer(JWT_ID).withIssuedAt(date).withExpiresAt(new Date(expireTime)).withClaim("timezone", "GMT+8");
            parameters.forEach((k, v) -> builder.withClaim(k, v));
            jwtString = builder.sign(algorithm);
            log.info(String.format("The expireTime is: %s", new Date(expireTime)));
        }
        return jwtString;
    }

    public static String generateJWT(Map<String, String> parameters, String key, int expireSeconds) {
        Algorithm algorithm = Algorithm.HMAC256((String)key);
        return JWTUtils.generateJWT(algorithm, parameters, expireSeconds);
    }

    public static String generateRSAJWT(Map<String, String> parameters, Key key, int expireSeconds) {
        Algorithm algorithm = Algorithm.RSA512(null, (RSAPrivateKey)((RSAPrivateKey)key));
        return JWTUtils.generateJWT(algorithm, parameters, expireSeconds);
    }

    public static Map<String, String> verifyJWT(Algorithm algorithm, String jwtString) {
        HashMap<String, String> returnMap = new HashMap<String, String>();
        if (algorithm != null && jwtString != null && !"".equals(jwtString)) {
            Verification verifier = JWT.require((Algorithm)algorithm);
            JWTVerifier jwtVerifier = verifier instanceof JWTVerifier.BaseVerification ? ((JWTVerifier.BaseVerification)verifier.withIssuer(new String[]{JWT_ID})).build((Clock)new BeijingClock()) : verifier.withIssuer(new String[]{JWT_ID}).build();
            DecodedJWT jwt = jwtVerifier.verify(jwtString);
            for (String key : jwt.getClaims().keySet()) {
                returnMap.put(key, jwt.getClaim(key).asString());
            }
        }
        return returnMap;
    }

    public static Map<String, String> verifyJWT(String key, String jwtString) {
        Algorithm algorithm = Algorithm.HMAC256((String)key);
        return JWTUtils.verifyJWT(algorithm, jwtString);
    }

    public static Map<String, String> verifyJWTByPublicKey(Key key, String jwtString) {
        Algorithm algorithm = Algorithm.RSA512((RSAPublicKey)((RSAPublicKey)key), null);
        return JWTUtils.verifyJWT(algorithm, jwtString);
    }

    public static long getCurMillisTime(int seconds) {
        BeijingClock clock = new BeijingClock();
        Date date = clock.getToday();
        long expireTime = date.getTime() + (long)(seconds * 1000);
        return expireTime;
    }

    public static long getExpireTime(String jwt) {
        long expireTime = 0L;
        try {
            String[] js = jwt.split("\\.");
            if (js.length == 3) {
                String payload = new String(Base64.getDecoder().decode(js[1]));
                Map claims = SdkJSONUtils.cast(payload, Map.class);
                expireTime = Long.parseLong((String)claims.get(EXPIRE_TIME));
            }
        }
        catch (IOException e) {
            expireTime = 0L;
        }
        return expireTime;
    }
}

