/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.id.worker.dbstore.impl;

import java.net.InetAddress;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kd.bos.bundle.Resources;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.dlock.DLock;
import kd.bos.dlock.DLockUtil;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.id.IDServiceAssignerConfig;
import kd.bos.id.worker.DBStore;
import kd.bos.util.ConfigurationUtil;
import kd.bos.util.StringUtils;

public class DBStoreImpl
implements DBStore {
    private static final String INIT_TABLE_SQL = "IF NOT EXISTS (SELECT 1 FROM KSQL_USERTABLES WHERE KSQL_TABNAME = 'T_CBS_ID_WORKER_STORE')CREATE TABLE T_CBS_ID_WORKER_STORE (FID BIGINT DEFAULT 0 NOT NULL,FWORKER_KEY VARCHAR(100) DEFAULT ' ' NOT NULL,FWORKER_INFO VARCHAR(100) DEFAULT ' ' NOT NULL,FCREATE_TIME DATETIME,FTYPE INT DEFAULT 0 NOT NULL);";
    private static final String CREATE_PK_ID = "EXEC P_ALTERPK 'PK_CBS_ID_WORKER_STORE', 'T_CBS_ID_WORKER_STORE', 'FID', '1'";
    private static final String CREATE_INDEX_WKT = "IF NOT EXISTS (SELECT 1 FROM KSQL_INDEXES WHERE KSQL_INDNAME = 'IDX_ID_WORKER_STORE_WKT') CREATE UNIQUE INDEX IDX_ID_WORKER_STORE_WKT ON T_CBS_ID_WORKER_STORE ( FWORKER_KEY ,FTYPE )";
    private static final String wInfoSql = "select fworker_key, fworker_info from t_cbs_id_worker_store where ftype = 0";
    private static final String ID_STORE_TABLE = "t_cbs_id_worker_store";
    private static String workerIdAssignerDBAccount = ConfigurationUtil.getString((String)"IDService.assigner.dbstore.account", (String)"");
    private static final Account account;

    public boolean initTable() {
        Wrapper<Object> wrapper = () -> {
            try (DLock dLock = DLock.create((String)"id_init_table_lock");){
                dLock.lock();
                if (DB.exitsTable((DBRoute)DBRoute.basedata, (String)ID_STORE_TABLE)) {
                    Boolean bl = true;
                    return bl;
                }
                DB.execute((DBRoute)DBRoute.basedata, (String)INIT_TABLE_SQL);
                DB.execute((DBRoute)DBRoute.basedata, (String)CREATE_PK_ID);
                DB.execute((DBRoute)DBRoute.basedata, (String)CREATE_INDEX_WKT);
                Boolean bl = DB.exitsTable((DBRoute)DBRoute.basedata, (String)ID_STORE_TABLE);
                return bl;
            }
            catch (Exception e) {
                throw new KDException(BosErrorCode.bosId, e.getMessage(), (Throwable)e);
            }
        };
        return (Boolean)wrapper.wrap();
    }

    public int insertWorkerIdAndGet(IDServiceAssignerConfig idServiceAssignerConfig, String instanceInfo, long invalidTimeout) {
        Wrapper<Object> wrapper = () -> {
            Throwable throwable = null;
            try (DLock dLock = DLock.create((String)"id_init_worker_lock");){
                if (dLock.tryLock(idServiceAssignerConfig.getTolerantClockBackTimestamp() >> 1)) {
                    String timeInfoSql = "select fworker_key, fworker_info from t_cbs_id_worker_store where ftype = 1";
                    Map timeInfos = (Map)DB.query((DBRoute)DBRoute.basedata, (String)timeInfoSql, rs -> {
                        HashMap<Integer, String> ret = new HashMap<Integer, String>();
                        while (rs.next()) {
                            String k = rs.getString(1);
                            String v = rs.getString(2);
                            if (k == null || !k.matches("\\d+")) continue;
                            ret.put(Integer.parseInt(k), v);
                        }
                        return ret;
                    });
                    Map wInfos = (Map)DB.query((DBRoute)DBRoute.basedata, (String)wInfoSql, rs -> {
                        HashMap<Integer, String> ret = new HashMap<Integer, String>();
                        while (rs.next()) {
                            String k = rs.getString(1);
                            String v = rs.getString(2);
                            if (k == null || !k.matches("\\d+")) continue;
                            ret.put(Integer.parseInt(k), v);
                        }
                        return ret;
                    });
                    Set timeInfoSet = timeInfos.keySet();
                    Set wInfoSet = wInfos.keySet();
                    timeInfoSet.removeAll(wInfoSet);
                    int v = -1;
                    for (Integer w : timeInfoSet) {
                        String ts = (String)timeInfos.get(w);
                        if (ts == null || !ts.matches("\\d+") || Long.parseLong(ts) + invalidTimeout > System.currentTimeMillis()) continue;
                        v = w;
                        break;
                    }
                    if (v == -1) {
                        HashSet allExistNodeNames = new HashSet(timeInfoSet.size() + 1);
                        allExistNodeNames.addAll(timeInfoSet);
                        allExistNodeNames.addAll(wInfoSet);
                        HashSet<Integer> idSet = new HashSet<Integer>(allExistNodeNames.size());
                        for (Integer nodeName : allExistNodeNames) {
                            idSet.add(nodeName);
                        }
                        int n = idServiceAssignerConfig.getMaxWorkerCount();
                        for (int i = 0; i < n; ++i) {
                            if (idSet.contains(i)) continue;
                            v = i;
                            break;
                        }
                    }
                    if (v == -1) {
                        String msg = Resources.get((String)"bos-id", (String)"IDServiceImplWorker_6", (String)"WorkerId\u5df2\u7528\u5b8c(%1$s)", (Object[])new Object[]{idServiceAssignerConfig.getMaxWorkerCount()});
                        if (timeInfoSet.size() > 0) {
                            msg = msg + Resources.get((String)"bos-id", (String)"IDServiceImplWorker_7", (String)"\u56e0\u65f6\u949f\u56de\u62e8\u4e0d\u53ef\u7528\u8282\u70b9\uff1a%1$s", (Object[])new Object[]{timeInfoSet});
                        }
                        msg = msg + "\u3002";
                        throw new KDException(BosErrorCode.bosId, new Object[]{msg});
                    }
                    Object[] objects = new Object[]{Math.abs(UUID.randomUUID().getLeastSignificantBits()), String.valueOf(v), instanceInfo + '#' + System.currentTimeMillis(), new Date(), 0};
                    DB.execute((DBRoute)DBRoute.basedata, (String)"insert into t_cbs_id_worker_store(fid, fworker_key, fworker_info, fcreate_time, ftype) values (?,?,?,?,?)", (Object[])objects);
                    Integer n = v;
                    return n;
                }
                try {
                    throw new KDException(BosErrorCode.bosId, new Object[]{"cannot get the lock in time."});
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        };
        return (Integer)wrapper.wrap();
    }

    public String getWorkerIdAssignedTime(int workerId) {
        Wrapper<Object> wrapper = () -> (String)DB.query((DBRoute)DBRoute.basedata, (String)"select fworker_info from t_cbs_id_worker_store where ftype = 1", rs -> {
            if (rs.next()) {
                return rs.getString(1);
            }
            return null;
        });
        return (String)wrapper.wrap();
    }

    public void setWorkerIdAssignTime(int workerId, String lastCheckTimestamp) {
        Wrapper<Object> wrapper = () -> {
            String workerIDStr = String.valueOf(workerId);
            Long count = (Long)DB.query((DBRoute)DBRoute.basedata, (String)"select count(1) from t_cbs_id_worker_store where fworker_key = ? and ftype = 1", (Object[])new Object[]{workerIDStr}, rs -> {
                if (rs.next()) {
                    return rs.getLong(1);
                }
                return 0L;
            });
            if (count > 0L) {
                Object[] objects = new Object[]{lastCheckTimestamp, workerIDStr, 1};
                DB.update((DBRoute)DBRoute.basedata, (String)"update t_cbs_id_worker_store set fworker_info = ? where fworker_key = ? and ftype = ?", (Object[])objects);
            } else {
                Object[] objects = new Object[]{Math.abs(UUID.randomUUID().getLeastSignificantBits()), workerIDStr, lastCheckTimestamp, new Date(), 1};
                DB.execute((DBRoute)DBRoute.basedata, (String)"insert into t_cbs_id_worker_store(fid, fworker_key, fworker_info, fcreate_time, ftype) values (?,?,?,?,?)", (Object[])objects);
            }
            return null;
        };
        wrapper.wrap();
    }

    public int getThenIncrement(IDServiceAssignerConfig idServiceAssignerConfig, String lockPath, String valuePath, int count) {
        Wrapper<Object> wrapper = () -> {
            Throwable throwable = null;
            try (DLock dLock = DLock.create((String)"id_init_worker_lock");){
                if (dLock.tryLock(idServiceAssignerConfig.getTolerantClockBackTimestamp() >> 1)) {
                    String value = (String)DB.query((DBRoute)DBRoute.basedata, (String)"select fworker_info from t_cbs_id_worker_store where fworker_key = ? and ftype = 2", (Object[])new Object[]{valuePath}, rs -> {
                        if (rs.next()) {
                            return rs.getString(1);
                        }
                        return null;
                    });
                    if (value != null) {
                        int ret = Integer.parseInt(value);
                        Object[] objects = new Object[]{ret + count, valuePath, 2};
                        DB.update((DBRoute)DBRoute.basedata, (String)"update t_cbs_id_worker_store set fworker_info = ? where fworker_key = ? and ftype = ?", (Object[])objects);
                        Integer n = ret;
                        return n;
                    }
                    int intIdMinValue = idServiceAssignerConfig.getIntIdMinValue();
                    Object[] objects = new Object[]{Math.abs(UUID.randomUUID().getLeastSignificantBits()), valuePath, String.valueOf(intIdMinValue + count), new Date(), 2};
                    DB.execute((DBRoute)DBRoute.basedata, (String)"insert into t_cbs_id_worker_store(fid, fworker_key, fworker_info, fcreate_time, ftype) values (?,?,?,?,?)", (Object[])objects);
                    Integer n = intIdMinValue;
                    return n;
                }
                try {
                    throw new KDException(BosErrorCode.bosId, new Object[]{"cannot get the lock in time."});
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        };
        return (Integer)wrapper.wrap();
    }

    public void cleanInvalidWorker(IDServiceAssignerConfig idServiceAssignerConfig, long invalidTimeout) {
        Wrapper<Object> wrapper = () -> {
            try {
                Map wInfos = (Map)DB.query((DBRoute)DBRoute.basedata, (String)wInfoSql, rs -> {
                    HashMap<Integer, String> ret = new HashMap<Integer, String>();
                    while (rs.next()) {
                        String k = rs.getString(1);
                        String v = rs.getString(2);
                        if (k == null || !k.matches("\\d+")) continue;
                        ret.put(Integer.parseInt(k), v);
                    }
                    return ret;
                });
                for (Map.Entry workerInfo : wInfos.entrySet()) {
                    long ts;
                    String[] split;
                    String value = (String)workerInfo.getValue();
                    if (StringUtils.isEmpty((String)value) || (split = value.split("#")).length != 3) continue;
                    String ip = split[1];
                    if (!InetAddress.getByName(ip).isReachable(3000)) {
                        DB.execute((DBRoute)DBRoute.basedata, (String)"delete from t_cbs_id_worker_store where fworker_key = ? and ftype = 0", (Object[])new Object[]{String.valueOf(workerInfo.getKey())});
                        continue;
                    }
                    if (DLockUtil.isInstanceAlive((String)split[0]) || (ts = Long.parseLong(split[2]) + invalidTimeout - System.currentTimeMillis()) >= 0L) continue;
                    DB.execute((DBRoute)DBRoute.basedata, (String)"delete from t_cbs_id_worker_store where fworker_key = ? and ftype = 0", (Object[])new Object[]{String.valueOf(workerInfo.getKey())});
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        };
        wrapper.wrap();
    }

    static /* synthetic */ Account access$000() {
        return account;
    }

    static {
        try {
            if (StringUtils.isEmpty((String)workerIdAssignerDBAccount)) {
                throw new KDException(BosErrorCode.bosId, new Object[]{"please set mc properties of 'IDService.assigner.dbstore.account'"});
            }
            account = AccountUtils.getAccountById((String)workerIdAssignerDBAccount);
        }
        catch (Exception e) {
            throw new KDException(BosErrorCode.bosId, e.getMessage(), (Throwable)e);
        }
    }

    static interface Wrapper<T> {
        /*
         * Exception decompiling
         */
        default public T wrap() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public T onWrap();
    }
}

