/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.rabbitmq;

import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.DefaultSaslConfig;
import com.rabbitmq.client.SaslConfig;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.StringReader;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import kd.bos.context.OperationContextCreator;
import kd.bos.encrypt.Encrypters;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.thread.ThreadLifeCycleManager;
import kd.bos.util.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

public class RabbitmqFactory {
    private static final int DEFAULT_THREAD_NUM = Boolean.getBoolean("mq.parallel.disable") ? 10 : 2;
    private static Logger logger = Logger.getLogger(RabbitmqFactory.class);
    private static final ConcurrentHashMap<String, ConnectionFactory> SERVERKEY_FACTORY_MAP = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, Connection> poolMap = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, String> region2mqserverkeyMap = new ConcurrentHashMap();
    private static ExecutorService consumerDispatchPool;
    private static final Object LOCKER;
    private static int maxConnectionSize;

    public static Connection getConnection(String serverKey) {
        Connection con;
        OperationContextCreator.getOrCreateForMq();
        if (poolMap.containsKey(serverKey) && (con = poolMap.get(serverKey)).isOpen()) {
            return con;
        }
        Class<RabbitmqFactory> clazz = RabbitmqFactory.class;
        synchronized (RabbitmqFactory.class) {
            if (poolMap.containsKey(serverKey)) {
                Connection con2 = poolMap.get(serverKey);
                if (con2.isOpen()) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return con2;
                }
                poolMap.remove(serverKey);
                try {
                    IOUtils.closeQuietly((Closeable)con2);
                }
                catch (Exception e) {
                    logger.error((Object)"IOUtils close connection exception ", (Throwable)e);
                }
            }
            try {
                Connection client = RabbitmqFactory.createConnection(serverKey);
                poolMap.put(serverKey, client);
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return client;
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new KDException((Throwable)e, BosErrorCode.rabbitmqConfiguration, new Object[]{e.getMessage()});
            }
        }
    }

    public static Connection getConnectionByRegion(String region) {
        Connection con;
        OperationContextCreator.getOrCreateForMq();
        String regionServerKey = RabbitmqFactory.getRegionServerKey(region);
        int index = Math.abs(region.hashCode() % maxConnectionSize);
        String key = regionServerKey + "_" + index;
        if (region.equals("schedule") && Boolean.getBoolean("mq.rabbitmq.schedule.connection.alone.enable")) {
            key = regionServerKey + "_schedule";
        }
        if (poolMap.containsKey(key) && (con = poolMap.get(key)).isOpen()) {
            return con;
        }
        Class<RabbitmqFactory> clazz = RabbitmqFactory.class;
        synchronized (RabbitmqFactory.class) {
            if (poolMap.containsKey(key)) {
                Connection con2 = poolMap.get(key);
                if (con2.isOpen()) {
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    return con2;
                }
                poolMap.remove(key);
                try {
                    IOUtils.closeQuietly((Closeable)con2);
                }
                catch (Exception e) {
                    logger.error((Object)"IOUtils close connection exception ", (Throwable)e);
                }
            }
            try {
                String serverKey = RabbitmqFactory.getRegionServerKey(region);
                Connection client = RabbitmqFactory.createConnection(serverKey);
                poolMap.put(key, client);
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return client;
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new KDException((Throwable)e, BosErrorCode.rabbitmqConfiguration, new Object[]{e.getMessage()});
            }
        }
    }

    private static Connection createConnection(String serverKey) {
        String serverInfo = System.getProperty(serverKey);
        if (serverInfo == null) {
            throw new KDException(BosErrorCode.mqServerConfiguration, new Object[]{"rabbit server not config for " + serverKey});
        }
        Properties prop = new Properties();
        StringReader reader = new StringReader(serverInfo);
        try {
            prop.load(reader);
            ExecutorService es = RabbitmqFactory.getExecutorService(prop);
            ConnectionFactory factory = RabbitmqFactory.getConnectionFactory(serverKey, prop);
            Connection connection = factory.newConnection(es);
            return RabbitmqFactory.wrap(connection);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new KDException((Throwable)e, BosErrorCode.rabbitmqConfiguration, new Object[]{e.getMessage()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ConnectionFactory getConnectionFactory(String serverKey, Properties prop) throws KeyManagementException, NoSuchAlgorithmException {
        ConnectionFactory factory = SERVERKEY_FACTORY_MAP.get(serverKey);
        if (factory != null) {
            return factory;
        }
        ConcurrentHashMap<String, ConnectionFactory> concurrentHashMap = SERVERKEY_FACTORY_MAP;
        synchronized (concurrentHashMap) {
            factory = SERVERKEY_FACTORY_MAP.get(serverKey);
            if (factory == null) {
                factory = new ConnectionFactory();
                SERVERKEY_FACTORY_MAP.putIfAbsent(serverKey, factory);
                String str = Objects.requireNonNull(prop.getProperty("host"), "host can't be empty.");
                factory.setHost(str);
                str = prop.getProperty("port");
                if (str != null && str.trim().length() > 0) {
                    factory.setPort(Integer.parseInt(str.trim()));
                }
                str = Objects.requireNonNull(prop.getProperty("user"), "user can't be empty.");
                factory.setUsername(str);
                str = prop.getProperty("password");
                str = Encrypters.decode((String)str);
                factory.setPassword(str);
                str = Objects.requireNonNull(prop.getProperty("vhost"), "vhost can't be empty.");
                factory.setVirtualHost(str);
                str = prop.getProperty("rpc.timeout", "60000");
                factory.setChannelRpcTimeout(Integer.parseInt(str));
                str = prop.getProperty("connection.timeout", "3000");
                factory.setConnectionTimeout(Integer.parseInt(str));
                str = prop.getProperty("ssl.enable", "false");
                if (Boolean.parseBoolean(str)) {
                    String certificate = prop.getProperty("certificate.enable", "false");
                    if (Boolean.parseBoolean(certificate)) {
                        String clientPath = FileUtils.checkFileUrl((String)Objects.requireNonNull(prop.getProperty("ssl.certificate.clientPath"), "ssl.certificate.clientPath can't be empty."));
                        String trustPath = FileUtils.checkFileUrl((String)Objects.requireNonNull(prop.getProperty("ssl.certificate.trustPath"), "ssl.certificate.trustPath can't be empty."));
                        String sslClientPassword = Objects.requireNonNull(prop.getProperty("ssl.certificate.keyPassword"), "ssl.certificate.keyPassword can't be empty.");
                        String sslTruststorePassword = Objects.requireNonNull(prop.getProperty("ssl.certificate.trustPassword"), "ssl.certificate.trustPassword can't be empty.");
                        SSLContext c = RabbitmqFactory.initSslSupport(clientPath, trustPath, sslClientPassword, sslTruststorePassword);
                        factory.useSslProtocol(c);
                    } else {
                        factory.useSslProtocol();
                    }
                }
                if ("EXTERNAL".equalsIgnoreCase(prop.getProperty("auth.mechanism"))) {
                    factory.setSaslConfig((SaslConfig)DefaultSaslConfig.EXTERNAL);
                }
            }
        }
        return factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ExecutorService getExecutorService(Properties prop) {
        if (consumerDispatchPool != null) {
            return consumerDispatchPool;
        }
        Object object = LOCKER;
        synchronized (object) {
            if (consumerDispatchPool == null) {
                String str = prop.getProperty("threadNumber");
                int threadNum = DEFAULT_THREAD_NUM;
                if (str != null) {
                    threadNum = Integer.parseInt(str.trim());
                }
                ExecutorService es = Executors.newFixedThreadPool(threadNum, new ThreadFactory(){
                    private AtomicInteger atomicInteger = new AtomicInteger(0);

                    @Override
                    public Thread newThread(Runnable r) {
                        return new Thread(r, "MQ-rabbit-pool-" + this.atomicInteger.incrementAndGet());
                    }
                });
                consumerDispatchPool = ThreadLifeCycleManager.wrapExecutorService((ExecutorService)es);
            }
        }
        return consumerDispatchPool;
    }

    private static Connection wrap(Connection connection) {
        return connection;
    }

    private static SSLContext initSslSupport(String clientPath, String trustPath, String sslClientPassword, String sslTruststorePassword) {
        SSLContext sslContext = null;
        try (FileInputStream clientPathStream = new FileInputStream(clientPath);
             FileInputStream trustPathStream = new FileInputStream(trustPath);){
            char[] clientPassphrase = sslClientPassword.trim().toCharArray();
            KeyStore ks = KeyStore.getInstance("PKCS12");
            ks.load(clientPathStream, clientPassphrase);
            KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
            kmf.init(ks, clientPassphrase);
            char[] trustPassphrase = sslTruststorePassword.trim().toCharArray();
            KeyStore tks = KeyStore.getInstance("JKS");
            tks.load(trustPathStream, trustPassphrase);
            TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509");
            tmf.init(tks);
            sslContext = SSLContext.getInstance("TLSv1.2");
            sslContext.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
            logger.error((Object)("SSL auth error,check ssl config please. error message: " + e.getMessage()), (Throwable)e);
            throw new KDException((Throwable)e, BosErrorCode.rabbitmqConfiguration, new Object[]{e.getMessage()});
        }
        return sslContext;
    }

    public static String getRegionServerKey(String region) {
        String mqServer = region2mqserverkeyMap.get(region);
        if (mqServer != null) {
            return mqServer;
        }
        if (!Boolean.getBoolean("mq.failover.enable")) {
            String serverKey = "mq.server." + region;
            String server = System.getProperty(serverKey);
            serverKey = server != null ? serverKey : "mq.server";
            region2mqserverkeyMap.put(region, serverKey);
            return serverKey;
        }
        String serverInfo = System.getProperty("mq.failover.server");
        Properties prop = new Properties();
        StringReader reader = new StringReader(serverInfo);
        try {
            prop.load(reader);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (prop.getProperty("type").equals("rabbitmq")) {
            region2mqserverkeyMap.put(region, "mq.failover.server");
            return "mq.failover.server";
        }
        region2mqserverkeyMap.put(region, "mq.server");
        return "mq.server";
    }

    static {
        LOCKER = new Object();
        maxConnectionSize = 2;
        Integer maxSize = Integer.getInteger("mq.rabbitmq.connection.max.size", maxConnectionSize);
        maxConnectionSize = Math.max(maxSize, maxConnectionSize);
    }
}

