/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.output;

import kd.bos.algo.AlgoException;
import kd.bos.algo.RowMeta;
import kd.bos.algo.output.AbstractOutput;
import kd.bos.context.RequestContext;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class DbOutput
extends AbstractOutput {
    private static final long serialVersionUID = -2451623793361277192L;
    private static final int DEFAULT_BATCH_INTERVAL = 5000;
    private int batchInterval = 5000;
    private RequestContext rc;
    private String sql;
    private String routeKey;
    private RowMeta rowMeta;
    private int[] sqlTypes;
    private boolean needTx;

    public DbOutput(String routeKey, String sql, RowMeta rowMeta) {
        this.routeKey = routeKey;
        this.sql = sql;
        this.rowMeta = rowMeta;
        RequestContext r = RequestContext.get();
        if (r == null) {
            throw new AlgoException("RequestContext can't be null.");
        }
        this.rc = RequestContext.copy((RequestContext)r);
    }

    public void setRowMeta(RowMeta rowMeta) {
        this.rowMeta = rowMeta;
    }

    public void setSqlTypes(int[] sqlTypes) {
        this.sqlTypes = sqlTypes;
    }

    public void setBatchInterval(int batchInterval) {
        if (batchInterval > 100) {
            this.batchInterval = batchInterval;
        }
    }

    public void setRequestContext(RequestContext rc) {
        this.rc = rc;
    }

    public RowMeta getRowMeta() {
        return this.rowMeta;
    }

    public RequestContext getRequestContext() {
        return this.rc;
    }

    public String getSql() {
        return this.sql;
    }

    public int getBatchInterval() {
        return this.batchInterval;
    }

    public String getRouteKey() {
        return this.routeKey;
    }

    public int[] getSqlTypes() {
        return this.sqlTypes;
    }

    public boolean isNeedTx() {
        return this.needTx;
    }

    public void setNeedTx(boolean needTx) {
        this.needTx = needTx;
    }
}

