/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algox.flink.cluster.local;

import java.io.IOException;
import java.io.StringReader;
import java.util.Properties;
import kd.bos.algo.AlgoException;
import kd.bos.algo.config.AlgoConfiguration;
import kd.bos.algox.ConfigKeys;
import kd.bos.algox.flink.utils.AkkaProtocolUtil;
import kd.bos.util.ConfigurationUtil;
import kd.bos.util.NetAddressUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.flink.configuration.AkkaOptions;
import org.apache.flink.configuration.AlgorithmOptions;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.CoreOptions;
import org.apache.flink.configuration.HeartbeatManagerOptions;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.configuration.RestOptions;
import org.apache.flink.configuration.TaskManagerOptions;

public class LocalConfigurationLoader {
    private static final Configuration localConfiguration = LocalConfigurationLoader.getConfiguration();

    private static Integer getInteger(String primaryKey, String secondKey, Integer defaultValue) {
        Integer i = ConfigurationUtil.getInteger((String)primaryKey);
        if (i == null) {
            i = ConfigurationUtil.getInteger((String)secondKey);
        }
        return i == null ? defaultValue : i;
    }

    private static Long getLong(String primaryKey, String secondKey, Long defaultValue) {
        Long l = ConfigurationUtil.getLong((String)primaryKey);
        if (l == null) {
            l = ConfigurationUtil.getLong((String)secondKey);
        }
        return l == null ? defaultValue : l;
    }

    private static Configuration getConfiguration() {
        String localConfig = ConfigurationUtil.getString((String)"algox.local.config");
        if (StringUtils.isEmpty((String)localConfig)) {
            return LocalConfigurationLoader.getOldConfiguration();
        }
        Properties properties = new Properties();
        StringReader reader = new StringReader(localConfig);
        try {
            properties.load(reader);
        }
        catch (IOException e) {
            throw new AlgoException("algox.local.config load error:", (Throwable)e);
        }
        String masterPortStr = properties.getProperty("algox.master.port");
        Integer masterPort = 7749;
        if (StringUtils.isEmpty((String)masterPortStr)) {
            try {
                masterPort = NetAddressUtils.getAvailablePort((int)7749);
            }
            catch (IOException e) {
                masterPort = 7749;
            }
        } else {
            masterPort = Integer.parseInt(masterPortStr);
        }
        System.setProperty("algox.local.master.port", masterPort.toString());
        String masterWebPortStr = properties.getProperty("algox.master.webport");
        Integer masterWebPort = 7750;
        if (StringUtils.isEmpty((String)masterWebPortStr)) {
            int start = 7750 > masterPort ? 7750 : masterPort + 1;
            try {
                masterWebPort = NetAddressUtils.getAvailablePort((int)start);
            }
            catch (IOException e) {
                masterWebPort = 7750;
            }
        } else {
            masterWebPort = Integer.parseInt(masterWebPortStr);
        }
        System.setProperty("algox.local.master.webport", masterWebPort.toString());
        String masterHeapStr = properties.getProperty("algox.master.memory", "100");
        Integer masterHeap = Integer.parseInt(masterHeapStr);
        String jobStore_cacheSizeStr = properties.getProperty("algox.master.jobstore.cacheSize");
        Long jobStore_cacheSize = StringUtils.isEmpty((String)jobStore_cacheSizeStr) ? Long.parseLong(jobStore_cacheSizeStr) : 0xC800000L;
        String jobStore_expireTimeStr = properties.getProperty("algox.master.jobstore.expireTime");
        Long jobStore_expireTime = StringUtils.isEmpty((String)jobStore_expireTimeStr) ? Long.parseLong(jobStore_expireTimeStr) : 86400L;
        return LocalConfigurationLoader.buildConfiguration(masterPort, masterWebPort, masterHeap, jobStore_cacheSize, jobStore_expireTime);
    }

    private static Configuration getOldConfiguration() {
        Integer masterWebPort;
        Integer masterPort = LocalConfigurationLoader.getInteger("algox.local.master.port", "algox.master.port", null);
        if (masterPort == null) {
            try {
                masterPort = NetAddressUtils.getAvailablePort((int)7749);
            }
            catch (IOException e) {
                masterPort = 7749;
            }
            System.setProperty("algox.local.master.port", masterPort.toString());
        }
        if ((masterWebPort = LocalConfigurationLoader.getInteger("algox.local.master.webport", "algox.master.webport", null)) == null) {
            int start = 7750 > masterPort ? 7750 : masterPort + 1;
            try {
                masterWebPort = NetAddressUtils.getAvailablePort((int)start);
            }
            catch (IOException e) {
                masterWebPort = 7750;
            }
            System.setProperty("algox.local.master.webport", masterWebPort.toString());
        }
        Integer masterHeap = LocalConfigurationLoader.getInteger("algox.local.master.memory", "algox.master.memory", 100);
        Long jobStore_cacheSize = LocalConfigurationLoader.getLong("algox.local.master.jobstore.cacheSize", "algox.master.jobstore.cacheSize", 0xC800000L);
        Long jobStore_expireTime = LocalConfigurationLoader.getLong("algox.local.master.jobstore.expireTime", "algox.master.jobstore.expireTime", 86400L);
        return LocalConfigurationLoader.buildConfiguration(masterPort, masterWebPort, masterHeap, jobStore_cacheSize, jobStore_expireTime);
    }

    private static Configuration buildConfiguration(Integer masterPort, Integer masterWebPort, Integer masterHeap, Long jobStore_cacheSize, Long jobStore_expireTime) {
        Configuration configuration = new Configuration();
        configuration.setString((ConfigOption<String>)JobManagerOptions.ADDRESS, "localhost");
        configuration.setString((ConfigOption<String>)TaskManagerOptions.HOST, "localhost");
        configuration.setString("taskmanager.hostname", "localhost");
        configuration.setInteger((ConfigOption<Integer>)RestOptions.PORT, (int)masterWebPort);
        configuration.setInteger((ConfigOption<Integer>)JobManagerOptions.PORT, (int)masterPort);
        configuration.setInteger((ConfigOption<Integer>)JobManagerOptions.JOB_MANAGER_HEAP_MEMORY_MB, (int)masterHeap);
        Integer jobStore_cacheCount = ConfigurationUtil.getInteger((String)"algox.master.jobstore.cacheCount", (Integer)2000);
        configuration.setInteger((ConfigOption<Integer>)JobManagerOptions.JOB_STORE_MAX_CAPACITY, (int)jobStore_cacheCount);
        configuration.setLong((ConfigOption<Long>)JobManagerOptions.JOB_STORE_CACHE_SIZE, (long)jobStore_cacheSize);
        configuration.setLong((ConfigOption<Long>)JobManagerOptions.JOB_STORE_EXPIRATION_TIME, (long)jobStore_expireTime);
        Integer workerHeap = LocalConfigurationLoader.getInteger("algox.local.worker.memory", "algox.worker.memory", 2048);
        Integer workerSlots = LocalConfigurationLoader.getInteger("algox.local.worker.threads", "algox.worker.threads", 64);
        configuration.set(TaskManagerOptions.TASK_HEAP_MEMORY, MemorySize.ofMebiBytes((long)128L));
        configuration.set(TaskManagerOptions.MANAGED_MEMORY_SIZE, MemorySize.ofMebiBytes((long)workerHeap.intValue()));
        configuration.setInteger((ConfigOption<Integer>)TaskManagerOptions.NUM_TASK_SLOTS, (int)workerSlots);
        configuration.setDouble((ConfigOption<Double>)TaskManagerOptions.CPU_CORES, 2.0);
        configuration.setString((ConfigOption<String>)AkkaOptions.ASK_TIMEOUT, "60 s");
        configuration.setString((ConfigOption<String>)AkkaOptions.TCP_TIMEOUT, "60 s");
        configuration.setString((ConfigOption<String>)AkkaOptions.LOOKUP_TIMEOUT, "60 s");
        configuration.setLong((ConfigOption<Long>)HeartbeatManagerOptions.HEARTBEAT_INTERVAL, 30000L);
        configuration.setLong((ConfigOption<Long>)HeartbeatManagerOptions.HEARTBEAT_TIMEOUT, 120000L);
        String dirs = ConfigurationUtil.getString((String)"algox.io.tmp.dirs");
        if (dirs == null) {
            dirs = AlgoConfiguration.IO_TMP_DIRS.getString();
        }
        if (dirs != null) {
            configuration.setString((ConfigOption<String>)CoreOptions.TMP_DIRS, dirs);
        }
        String memory = ConfigurationUtil.getString((String)"algox.worker.network.memory", (String)"1024");
        configuration.set(TaskManagerOptions.NETWORK_MEMORY_MAX, MemorySize.ofMebiBytes((long)Integer.parseInt(memory)));
        configuration.set(TaskManagerOptions.NETWORK_MEMORY_MIN, MemorySize.ofMebiBytes((long)Integer.parseInt(memory)));
        configuration.setBoolean((ConfigOption<Boolean>)JobManagerOptions.RETRIEVE_TASK_MANAGER_HOSTNAME, false);
        String host = NetAddressUtils.getLocalIpAddress();
        if (host != null) {
            configuration.setString((ConfigOption<String>)JobManagerOptions.ADDRESS, host);
        }
        configuration.set(AlgorithmOptions.USE_LARGE_RECORDS_HANDLER, (Object)true);
        AkkaProtocolUtil.setAkkaProtocol(configuration);
        AkkaProtocolUtil.setAkkaFrameSize(configuration, true);
        boolean useLargeRecordHandler = ConfigurationUtil.getBoolean((String)"algox.algorithm.largeRecordHandler", (Boolean)ConfigKeys.ALGORITHM_LARGE_RECORD_HANDLER_DEFAULT_VALUE);
        configuration.set(AlgorithmOptions.USE_LARGE_RECORDS_HANDLER, (Object)useLargeRecordHandler);
        configuration.set(CoreOptions.CHECK_LEAKED_CLASSLOADER, (Object)false);
        return configuration;
    }

    public static Configuration loadMasterConfiguration() {
        return localConfiguration;
    }

    public static Configuration loadWorkerConfiguration() {
        return localConfiguration;
    }

    public static int getWebPort() {
        return localConfiguration.getInteger((ConfigOption<Integer>)RestOptions.PORT);
    }

    public static String getWebUrl() {
        String host = NetAddressUtils.getLocalIpAddress();
        return "http://" + host + ":" + LocalConfigurationLoader.getWebPort();
    }
}

