/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algox.flink.cluster.local;

import kd.bos.algox.flink.cluster.local.LocalConfigurationLoader;
import kd.bos.algox.flink.cluster.local.LocalMasterRuntimeContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.entrypoint.ClusterEntrypointException;
import org.apache.flink.runtime.entrypoint.StandaloneSessionClusterEntrypoint;
import org.apache.flink.runtime.entrypoint.component.DefaultDispatcherResourceManagerComponentFactory;
import org.apache.flink.runtime.util.EnvironmentInformation;
import org.apache.flink.runtime.util.JvmShutdownSafeguard;
import org.apache.flink.runtime.util.SignalHandler;
import org.slf4j.Logger;

public class LocalMasterStarter
extends StandaloneSessionClusterEntrypoint {
    private static Log log = LogFactory.getLog(LocalMasterStarter.class);

    public LocalMasterStarter(Configuration configuration) {
        super(configuration);
    }

    public void onFatalError(Throwable exception) {
        LOG.error("Fatal error occurred in the flink master.", exception);
        log.error("Master start error", exception);
        LocalMasterRuntimeContext.setException(exception);
    }

    protected DefaultDispatcherResourceManagerComponentFactory createDispatcherResourceManagerComponentFactory(Configuration configuration) {
        return super.createDispatcherResourceManagerComponentFactory(configuration);
    }

    public static void startup() {
        EnvironmentInformation.logEnvironmentInfo((Logger)LOG, (String)LocalMasterStarter.class.getSimpleName(), (String[])new String[0]);
        SignalHandler.register((Logger)LOG);
        JvmShutdownSafeguard.installAsShutdownHook((Logger)LOG);
        Configuration configuration = LocalConfigurationLoader.loadMasterConfiguration();
        LocalMasterRuntimeContext.setConfiguration(configuration);
        LocalMasterStarter entrypoint = new LocalMasterStarter(configuration);
        try {
            entrypoint.startCluster();
        }
        catch (ClusterEntrypointException e) {
            LocalMasterRuntimeContext.setException(e);
            log.error("Master start error", (Throwable)e);
        }
    }
}

