/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algox.flink.cluster.masterworker;

import kd.bos.algo.config.AlgoConfiguration;
import kd.bos.algox.ConfigKeys;
import kd.bos.algox.flink.utils.AkkaProtocolUtil;
import kd.bos.util.ConfigurationUtil;
import org.apache.flink.configuration.AkkaOptions;
import org.apache.flink.configuration.AlgorithmOptions;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.CoreOptions;
import org.apache.flink.configuration.HeartbeatManagerOptions;
import org.apache.flink.configuration.HighAvailabilityOptions;
import org.apache.flink.configuration.NettyShuffleEnvironmentOptions;

public class CommonConfigUtil {
    public static Configuration buildCommon(Configuration configuration) {
        configuration.set(HighAvailabilityOptions.ZOOKEEPER_RETRY_WAIT, (Object)5000);
        configuration.set(HighAvailabilityOptions.ZOOKEEPER_MAX_RETRY_ATTEMPTS, (Object)120);
        configuration.set(HighAvailabilityOptions.ZOOKEEPER_SESSION_TIMEOUT, (Object)120000);
        Integer value = ConfigurationUtil.getInteger((String)"algox.network.rpc.read.timeout", (Integer)180);
        configuration.setString((ConfigOption<String>)AkkaOptions.ASK_TIMEOUT, value + " s");
        value = ConfigurationUtil.getInteger((String)"algox.network.rpc.connection.timeout", (Integer)60);
        configuration.setString((ConfigOption<String>)AkkaOptions.TCP_TIMEOUT, value + " s");
        configuration.setString((ConfigOption<String>)AkkaOptions.LOOKUP_TIMEOUT, "60 s");
        value = ConfigurationUtil.getInteger((String)"algox.network.heartbeat.interval", (Integer)10000);
        configuration.setLong((ConfigOption<Long>)HeartbeatManagerOptions.HEARTBEAT_INTERVAL, (long)value.intValue());
        value = ConfigurationUtil.getInteger((String)"algox.network.heartbeat.timeout", (Integer)300000);
        configuration.setLong((ConfigOption<Long>)HeartbeatManagerOptions.HEARTBEAT_TIMEOUT, (long)value.intValue());
        value = ConfigurationUtil.getInteger((String)"algox.network.request.timeout", (Integer)180000);
        configuration.setInteger((ConfigOption<Integer>)NettyShuffleEnvironmentOptions.NETWORK_REQUEST_BACKOFF_MAX, (int)value);
        configuration.set(CoreOptions.CHECK_LEAKED_CLASSLOADER, (Object)false);
        configuration.setBoolean((ConfigOption<Boolean>)AkkaOptions.JVM_EXIT_ON_FATAL_ERROR, false);
        String dirs = ConfigurationUtil.getString((String)"algox.io.tmp.dirs");
        if (dirs == null) {
            dirs = AlgoConfiguration.IO_TMP_DIRS.getString();
        }
        if (dirs != null) {
            configuration.setString((ConfigOption<String>)CoreOptions.TMP_DIRS, dirs);
        }
        AkkaProtocolUtil.setAkkaProtocol(configuration);
        AkkaProtocolUtil.setAkkaFrameSize(configuration, false);
        boolean useLargeRecordHandler = ConfigurationUtil.getBoolean((String)"algox.algorithm.largeRecordHandler", (Boolean)ConfigKeys.ALGORITHM_LARGE_RECORD_HANDLER_DEFAULT_VALUE);
        configuration.set(AlgorithmOptions.USE_LARGE_RECORDS_HANDLER, (Object)useLargeRecordHandler);
        return configuration;
    }
}

