/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algox.flink.cluster.masterworker;

import kd.bos.algox.AlgoXException;
import kd.bos.algox.flink.cluster.masterworker.AlgoxHaType;
import kd.bos.algox.flink.cluster.masterworker.MasterConfig;
import kd.bos.algox.flink.cluster.masterworker.MasterRuntimeContext;
import kd.bos.algox.flink.cluster.masterworker.MasterWorkerClusterClient;
import kd.bos.algox.flink.rpc.MasterRpcService;
import kd.bos.cache.CacheConfigKeys;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.redis.JedisClient;
import kd.bos.redis.RedisFactory;
import kd.bos.util.ConfigurationUtil;
import kd.bos.zk.ZKFactory;
import org.apache.curator.framework.CuratorFramework;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.HighAvailabilityOptions;
import org.apache.flink.runtime.entrypoint.StandaloneSessionClusterEntrypoint;
import org.apache.flink.runtime.entrypoint.component.DefaultDispatcherResourceManagerComponentFactory;
import org.apache.flink.runtime.util.EnvironmentInformation;
import org.apache.flink.runtime.util.JvmShutdownSafeguard;
import org.apache.flink.runtime.util.SignalHandler;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import redis.clients.jedis.params.SetParams;

public class MasterStarter
extends StandaloneSessionClusterEntrypoint {
    private static Log log = LogFactory.getLog(MasterStarter.class);
    private static boolean started;

    public MasterStarter(Configuration configuration) {
        super(configuration);
    }

    public void onFatalError(Throwable exception) {
        log.error("Fatal error occurred in the flink master.", exception);
        log.error("Master start error", exception);
        MasterRuntimeContext.setException((Exception)new AlgoXException("Master starting error.", exception));
    }

    protected DefaultDispatcherResourceManagerComponentFactory createDispatcherResourceManagerComponentFactory(Configuration configuration) {
        return super.createDispatcherResourceManagerComponentFactory(configuration);
    }

    private static boolean testMasterExists(String region) {
        try {
            MasterRpcService service = MasterWorkerClusterClient.getMasterRpcService(region);
            return service.isAvailable();
        }
        catch (Throwable t) {
            return false;
        }
    }

    private static void clearZk(Configuration configuration, String region) {
        boolean clearZk = ConfigurationUtil.getBoolean((String)"algox.cluster.clearZk", (Boolean)true);
        AlgoxHaType algoxHaType = AlgoxHaType.getAlgoxHaType();
        if (algoxHaType == AlgoxHaType.zookeeper && clearZk && !MasterStarter.testMasterExists(region)) {
            String clusterId = configuration.getString((ConfigOption<String>)HighAvailabilityOptions.HA_CLUSTER_ID);
            String zkroot = configuration.getString((ConfigOption<String>)HighAvailabilityOptions.HA_ZOOKEEPER_ROOT);
            String zookeeper = configuration.getString((ConfigOption<String>)HighAvailabilityOptions.HA_ZOOKEEPER_QUORUM);
            try {
                String path = zkroot + "/" + clusterId;
                CuratorFramework cf = ZKFactory.getZKClient((String)zookeeper);
                Stat stat = (Stat)cf.checkExists().forPath(path);
                if (stat != null) {
                    cf.delete().deletingChildrenIfNeeded().forPath(path);
                }
            }
            catch (Throwable t) {
                log.warn(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startup() {
        if (!Boolean.getBoolean("algox.master.enable")) {
            log.warn("Algox master is disabled.");
            return;
        }
        if (started) {
            return;
        }
        started = true;
        String redisUrl = ConfigurationUtil.getString((String)"algox.cluster.redis.url");
        if (redisUrl == null) {
            redisUrl = System.getProperty(CacheConfigKeys.getSessionableConfigKey());
        }
        try (JedisClient jedisClient = RedisFactory.getJedisClient((String)redisUrl);){
            String region = ConfigurationUtil.getString((String)"algox.cluster.region", (String)"default");
            String key = "algox-starting-" + region;
            String existValues = jedisClient.get(key);
            while (existValues != null) {
                try {
                    Thread.sleep(5000L);
                    existValues = jedisClient.get(key);
                }
                catch (InterruptedException interruptedException) {}
            }
            String value = "" + System.currentTimeMillis();
            SetParams jedisSetParam = SetParams.setParams();
            jedisSetParam.ex(60L);
            jedisClient.set(key, value, jedisSetParam);
            try {
                MasterStarter.doStart();
            }
            finally {
                jedisClient.del(key);
            }
        }
    }

    private static void doStart() {
        try {
            Configuration configuration = MasterConfig.loadConfiguration();
            String region = ConfigurationUtil.getString((String)"algox.cluster.region", (String)"default");
            MasterStarter.clearZk(configuration, region);
            EnvironmentInformation.logEnvironmentInfo((Logger)LOG, (String)MasterStarter.class.getSimpleName(), (String[])new String[0]);
            SignalHandler.register((Logger)LOG);
            JvmShutdownSafeguard.installAsShutdownHook((Logger)LOG);
            MasterStarter entrypoint = new MasterStarter(configuration);
            MasterRuntimeContext.setConfiguration(configuration);
            entrypoint.startCluster();
        }
        catch (Exception e) {
            log.error("Master start error", (Throwable)e);
            MasterRuntimeContext.setException(e);
        }
        catch (Error e) {
            log.error("Master start error", (Throwable)e);
            MasterRuntimeContext.setException((Exception)new AlgoXException("Master starting error.", (Throwable)e));
        }
    }
}

