/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algox.flink.core.inout;

import java.io.IOException;
import kd.bos.algo.CacheHint;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.RowFactory;
import kd.bos.algo.dataset.cache.CachedDataSetBuilder;
import kd.bos.algox.RowX;
import kd.bos.algox.flink.core.inout.ParallelismConfigurable;
import org.apache.flink.api.common.io.RichOutputFormat;
import org.apache.flink.configuration.Configuration;

public class DataSetCacheOutputFormat
extends RichOutputFormat<RowX>
implements ParallelismConfigurable {
    private static final long serialVersionUID = -6742135867762478191L;
    private RowMeta rowMeta;
    private CacheHint cacheHint;
    private transient CachedDataSetBuilder builder;

    public DataSetCacheOutputFormat(RowMeta rowMeta, String cacheId, CacheHint cacheHint) {
        this.rowMeta = rowMeta;
        this.cacheHint = cacheHint;
        cacheHint.setCacheId(cacheId);
    }

    public void configure(Configuration configuration) {
    }

    public void open(int arg0, int arg1) throws IOException {
        this.builder = new CachedDataSetBuilder(this.rowMeta, this.cacheHint);
    }

    public void writeRecord(RowX out) throws IOException {
        this.builder.append(this.convertToRow(out));
    }

    protected Row convertToRow(RowX out) {
        Object[] values = new Object[out.size()];
        for (int pos = 0; pos < out.size(); ++pos) {
            values[pos] = out.get(pos);
        }
        Row row = RowFactory.createRow((RowMeta)this.rowMeta, (Object[])values);
        return row;
    }

    public void close() throws IOException {
        this.builder.build();
    }

    @Override
    public int getParallelism() {
        return 1;
    }
}

