/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algox.flink.core.inout;

import java.io.IOException;
import kd.bos.algo.Input;
import kd.bos.algox.InputExecutor;
import kd.bos.algox.RowX;
import kd.bos.algox.core.JobContext;
import kd.bos.algox.flink.core.inout.InputExecutorFactory;
import org.apache.flink.api.common.io.DefaultInputSplitAssigner;
import org.apache.flink.api.common.io.RichInputFormat;
import org.apache.flink.api.common.io.statistics.BaseStatistics;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.io.GenericInputSplit;
import org.apache.flink.core.io.InputSplit;
import org.apache.flink.core.io.InputSplitAssigner;

public class MultiInputFormat
extends RichInputFormat<RowX, InputSplit> {
    private static final long serialVersionUID = 7596709072858743484L;
    private Input[] inputs;
    private JobContext jobContext;
    private transient InputExecutor<?> executor;

    public MultiInputFormat(Input[] inputs, JobContext jobContext) {
        this.inputs = inputs;
        this.jobContext = jobContext;
    }

    public void configure(Configuration configuration) {
    }

    public void open(InputSplit inputSplit) throws IOException {
        this.executor = InputExecutorFactory.create(this.inputs[inputSplit.getSplitNumber()], this.jobContext);
        this.executor.open();
    }

    public InputSplit[] createInputSplits(int minNumSplits) throws IOException {
        GenericInputSplit[] ret = new GenericInputSplit[this.inputs.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = new GenericInputSplit(i, ret.length);
        }
        return ret;
    }

    public InputSplitAssigner getInputSplitAssigner(InputSplit[] inputSplits) {
        return new DefaultInputSplitAssigner(inputSplits);
    }

    public BaseStatistics getStatistics(BaseStatistics statistics) throws IOException {
        return statistics;
    }

    public void close() throws IOException {
        this.executor.close();
    }

    public RowX nextRecord(RowX out) throws IOException {
        return this.executor.next(out);
    }

    public boolean reachedEnd() throws IOException {
        return !this.executor.hasNext();
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        ret.append(((Object)((Object)this)).getClass().getSimpleName()).append('(').append(this.inputs[0].getClass().getSimpleName());
        for (int i = 1; i < this.inputs.length; ++i) {
            ret.append(',').append(this.inputs[i].getClass().getSimpleName());
        }
        ret.append(')');
        return ret.toString();
    }
}

