/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algox.flink.core.inout;

import kd.bos.algo.DataSet;
import kd.bos.algo.Input;
import kd.bos.algo.Row;
import kd.bos.algo.input.OrmInput;
import kd.bos.algox.InputExecutor;
import kd.bos.algox.RowX;
import kd.bos.algox.core.JobContext;
import kd.bos.algox.flink.core.InputSemaphore;
import kd.bos.algox.flink.core.InputSemaphoreFactory;
import kd.bos.algox.flink.utils.SplittingReadWriteUtils;
import kd.bos.context.RequestContext;
import kd.bos.db.splittingread.ThreadReadWriteContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;

public class OrmInputExecutor
extends InputExecutor<OrmInput> {
    private static final Log log = LogFactory.getLog(OrmInputExecutor.class);
    private transient DataSet dataSet;
    private JobContext jobContext;
    private InputSemaphore semaphore = null;

    public OrmInputExecutor(OrmInput input, JobContext jobContext) {
        super((Input)input, input.getRowMeta());
        this.jobContext = jobContext;
    }

    public void close() {
        if (this.dataSet != null) {
            try {
                this.dataSet.close();
            }
            catch (Throwable t) {
                log.error("error when close DataSet", t);
            }
        }
    }

    public RowX next(RowX out) {
        if (!this.dataSet.hasNext()) {
            return null;
        }
        Row row = this.dataSet.next();
        this.convertToRowX(out, row);
        return out;
    }

    public void open() {
        try {
            this.semaphore = InputSemaphoreFactory.getSemaphonre();
            this.semaphore.acquire(1);
        }
        catch (InterruptedException e) {
            log.error("get semaphore error", (Throwable)e);
        }
        RequestContext.set((RequestContext)((OrmInput)this.input).getRequestContext());
        ORM orm = ORM.create();
        if (((OrmInput)this.input).getCacheSize() != null) {
            orm.hint().setCacheSize(((OrmInput)this.input).getCacheSize());
        }
        try (ThreadReadWriteContext readWriteContext = SplittingReadWriteUtils.recover(this.jobContext.getReadWriteMode());){
            this.dataSet = orm.queryDataSet(((OrmInput)this.input).getAlgoKey(), ((OrmInput)this.input).getEntityName(), ((OrmInput)this.input).getSelectFields(), ((OrmInput)this.input).getFilters());
        }
        if (this.semaphore != null) {
            this.semaphore.release(1);
        }
    }

    public boolean hasNext() {
        return this.dataSet.hasNext();
    }
}

