/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algox.flink.core.translate;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.AlgoException;
import kd.bos.algo.Input;
import kd.bos.algo.Output;
import kd.bos.algox.CoGroupDataSetX;
import kd.bos.algox.DataSetX;
import kd.bos.algox.JobSession;
import kd.bos.algox.JoinDataSetX;
import kd.bos.algox.RowX;
import kd.bos.algox.core.AddFieldsDataSetX;
import kd.bos.algox.core.AggregatorDataSetX;
import kd.bos.algox.core.DataSinkX;
import kd.bos.algox.core.DataSourceX;
import kd.bos.algox.core.DistinctDataSetX;
import kd.bos.algox.core.FilterDataSetX;
import kd.bos.algox.core.FlatMapDataSetX;
import kd.bos.algox.core.GroupCombineDataSetX;
import kd.bos.algox.core.GroupCombineReduceDataSetX;
import kd.bos.algox.core.GroupReduceDataSetX;
import kd.bos.algox.core.JobContext;
import kd.bos.algox.core.MapDataSetX;
import kd.bos.algox.core.PartitionByHashDataSetX;
import kd.bos.algox.core.RemoveFieldsDataSetX;
import kd.bos.algox.core.SelectDataSetX;
import kd.bos.algox.core.SortGlobalDataSetX;
import kd.bos.algox.core.TopDataSetX;
import kd.bos.algox.core.UnionDataSetX;
import kd.bos.algox.flink.core.inout.ParallelismConfigurable;
import kd.bos.algox.flink.core.translate.AddFieldsTranslator;
import kd.bos.algox.flink.core.translate.AggregatorTranslator;
import kd.bos.algox.flink.core.translate.CoGroupTranslator;
import kd.bos.algox.flink.core.translate.DistinctTranslator;
import kd.bos.algox.flink.core.translate.FilterTranslator;
import kd.bos.algox.flink.core.translate.FlatMapTranslator;
import kd.bos.algox.flink.core.translate.GroupCombineReduceTranslator;
import kd.bos.algox.flink.core.translate.GroupCombineTranslator;
import kd.bos.algox.flink.core.translate.GroupReduceTranslator;
import kd.bos.algox.flink.core.translate.InputTranslate;
import kd.bos.algox.flink.core.translate.JoinTranslator;
import kd.bos.algox.flink.core.translate.MapTranslator;
import kd.bos.algox.flink.core.translate.OutputTranslate;
import kd.bos.algox.flink.core.translate.PartitionByHashTranslator;
import kd.bos.algox.flink.core.translate.RemoveFieldsTranslator;
import kd.bos.algox.flink.core.translate.SelectTranslator;
import kd.bos.algox.flink.core.translate.SortGlobalTranslator;
import kd.bos.algox.flink.core.translate.TopTranslator;
import kd.bos.algox.flink.core.translate.UnionTranslator;
import kd.bos.algox.flink.type.TypeUtil;
import org.apache.flink.api.common.io.InputFormat;
import org.apache.flink.api.common.io.RichOutputFormat;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.operators.DataSink;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.operators.Operator;
import org.apache.flink.core.io.InputSplit;

public class Translate {
    private final JobContext jobContext;

    public Translate(JobContext jobContext) {
        this.jobContext = jobContext;
    }

    public List<DataSink<RowX>> translate(ExecutionEnvironment env, JobSession session) {
        List sinks = session.getContext().getDataSinks();
        return this.translate(env, sinks);
    }

    public List<DataSink<RowX>> translate(ExecutionEnvironment env, List<DataSinkX> sinks) {
        ArrayList<DataSink<RowX>> result = new ArrayList<DataSink<RowX>>();
        HashMap<DataSetX, DataSet<RowX>> dup = new HashMap<DataSetX, DataSet<RowX>>();
        for (DataSinkX sinkX : sinks) {
            DataSink<RowX> sink = this.translate(env, sinkX, dup);
            result.add(sink);
        }
        return result;
    }

    private DataSink<RowX> translate(ExecutionEnvironment env, DataSinkX sinkX, Map<DataSetX, DataSet<RowX>> dup) {
        DataSetX source = sinkX.getSource();
        DataSet<RowX> dataset = this.translateDataSet(env, source, dup);
        RichOutputFormat<RowX> outputFormat = this.translateOutput(source, sinkX.getOutput());
        DataSink sink = dataset.output(outputFormat);
        if (outputFormat instanceof ParallelismConfigurable) {
            sink.setParallelism(((ParallelismConfigurable)outputFormat).getParallelism());
        }
        sink.name(outputFormat.getClass().getSimpleName() + " at " + sinkX.getLocation());
        return sink;
    }

    public DataSet<RowX> translateDataSet(ExecutionEnvironment env, DataSetX source, Map<DataSetX, DataSet<RowX>> dup) {
        DataSet<RowX> result = dup.get(source);
        if (result != null) {
            return result;
        }
        if (source instanceof DataSourceX) {
            result = this.translateDataSource(env, (DataSourceX)source);
        } else if (source instanceof FilterDataSetX) {
            result = new FilterTranslator((FilterDataSetX)source, this).go(env, dup);
        } else if (source instanceof MapDataSetX) {
            result = new MapTranslator((MapDataSetX)source, this).go(env, dup);
        } else if (source instanceof FlatMapDataSetX) {
            result = new FlatMapTranslator((FlatMapDataSetX)source, this).go(env, dup);
        } else if (source instanceof GroupReduceDataSetX) {
            result = new GroupReduceTranslator((GroupReduceDataSetX)source, this).go(env, dup);
        } else if (source instanceof GroupCombineDataSetX) {
            result = new GroupCombineTranslator((GroupCombineDataSetX)source, this).go(env, dup);
        } else if (source instanceof GroupCombineReduceDataSetX) {
            result = new GroupCombineReduceTranslator((GroupCombineReduceDataSetX)source, this).go(env, dup);
        } else if (source instanceof CoGroupDataSetX) {
            result = new CoGroupTranslator((CoGroupDataSetX)source, this).go(env, dup);
        } else if (source instanceof SelectDataSetX) {
            result = new SelectTranslator((SelectDataSetX)source, this).go(env, dup);
        } else if (source instanceof TopDataSetX) {
            result = new TopTranslator((TopDataSetX)source, this).go(env, dup);
        } else if (source instanceof SortGlobalDataSetX) {
            result = new SortGlobalTranslator((SortGlobalDataSetX)source, this).go(env, dup);
        } else if (source instanceof UnionDataSetX) {
            result = new UnionTranslator((UnionDataSetX)source, this).go(env, dup);
        } else if (source instanceof AggregatorDataSetX) {
            result = new AggregatorTranslator((AggregatorDataSetX)source, this).go(env, dup);
        } else if (source instanceof DistinctDataSetX) {
            result = new DistinctTranslator((DistinctDataSetX)source, this).go(env, dup);
        } else if (source instanceof PartitionByHashDataSetX) {
            result = new PartitionByHashTranslator((PartitionByHashDataSetX)source, this).go(env, dup);
        } else if (source instanceof JoinDataSetX) {
            result = new JoinTranslator((JoinDataSetX)source, this).go(env, dup);
        } else if (source instanceof RemoveFieldsDataSetX) {
            result = new RemoveFieldsTranslator((RemoveFieldsDataSetX)source, this).go(env, dup);
        } else if (source instanceof AddFieldsDataSetX) {
            result = new AddFieldsTranslator((AddFieldsDataSetX)source, this).go(env, dup);
        }
        if (result != null) {
            if (source.isSingleParallel()) {
                ((Operator)result).setParallelism(1);
            }
            dup.put(source, result);
            return result;
        }
        throw new AlgoException("Not support: " + source.getClass());
    }

    private DataSet<RowX> translateDataSource(ExecutionEnvironment env, DataSourceX x) {
        Input[] inputs = x.getInputs();
        InputTranslate inputTranslate = new InputTranslate(this.jobContext);
        InputFormat<RowX, InputSplit> inputFormat = inputTranslate.translate(inputs);
        DataSource dataSource = env.createInput(inputFormat, (TypeInformation)TypeUtil.toRowXType(x.getRowMeta()));
        dataSource.name(inputFormat.getClass().getSimpleName() + " at " + x.getLocation());
        if (inputs.length > 1) {
            if (inputs.length < env.getParallelism()) {
                dataSource.setParallelism(inputs.length);
            }
        } else {
            dataSource.setParallelism(1);
        }
        return dataSource;
    }

    private RichOutputFormat<RowX> translateOutput(DataSetX source, Output output) {
        return OutputTranslate.translate(source, output);
    }
}

