/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algox.flink.enhance.krpc;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import kd.bos.algox.flink.enhance.krpc.ActorRef;
import kd.bos.algox.flink.enhance.krpc.KAkkaInvocationHandler;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.rpc.FencedMainThreadExecutable;
import org.apache.flink.runtime.rpc.FencedRpcGateway;
import org.apache.flink.runtime.rpc.messages.CallAsync;
import org.apache.flink.runtime.rpc.messages.FencedMessage;
import org.apache.flink.runtime.rpc.messages.LocalFencedMessage;
import org.apache.flink.runtime.rpc.messages.RemoteFencedMessage;
import org.apache.flink.runtime.rpc.messages.RunAsync;
import org.apache.flink.runtime.rpc.messages.UnfencedMessage;
import org.apache.flink.util.Preconditions;

public class KFencedAkkaInvocationHandler<F extends Serializable>
extends KAkkaInvocationHandler
implements FencedMainThreadExecutable,
FencedRpcGateway<F> {
    private final Supplier<F> fencingTokenSupplier;

    public KFencedAkkaInvocationHandler(String address, String hostname, ActorRef rpcEndpoint, Time timeout, long maximumFramesize, @Nullable CompletableFuture<Void> terminationFuture, Supplier<F> fencingTokenSupplier, boolean captureAskCallStacks) {
        super(address, hostname, rpcEndpoint, timeout, maximumFramesize, terminationFuture, captureAskCallStacks);
        this.fencingTokenSupplier = (Supplier)Preconditions.checkNotNull(fencingTokenSupplier);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Class<?> declaringClass = method.getDeclaringClass();
        if (declaringClass.equals(FencedMainThreadExecutable.class) || declaringClass.equals(KFencedAkkaInvocationHandler.class) || declaringClass.equals(FencedRpcGateway.class)) {
            return method.invoke((Object)this, args);
        }
        return super.invoke(proxy, method, args);
    }

    public void runAsyncWithoutFencing(Runnable runnable) {
        Preconditions.checkNotNull((Object)runnable, (String)"runnable");
        if (!this.isLocal) {
            throw new RuntimeException("Trying to send a Runnable to a remote actor at " + this.actorRef.toString() + ". This is not supported.");
        }
        this.actorRef.tell(new UnfencedMessage((Object)new RunAsync(runnable, 0L)));
    }

    public <V> CompletableFuture<V> callAsyncWithoutFencing(Callable<V> callable, Time timeout) {
        Preconditions.checkNotNull(callable, (String)"callable");
        Preconditions.checkNotNull((Object)timeout, (String)"timeout");
        if (this.isLocal) {
            return this.actorRef.ask(new UnfencedMessage((Object)new CallAsync(callable)));
        }
        throw new RuntimeException("Trying to send a Runnable to a remote actor at " + this.actorRef.toString() + ". This is not supported.");
    }

    @Override
    public void tell(Object message) {
        super.tell(this.fenceMessage(message));
    }

    @Override
    public CompletableFuture<?> ask(Object message, Time timeout) {
        return super.ask(this.fenceMessage(message), timeout);
    }

    public F getFencingToken() {
        return (F)((Serializable)this.fencingTokenSupplier.get());
    }

    private <P> FencedMessage<F, P> fenceMessage(P message) {
        if (this.isLocal) {
            return new LocalFencedMessage((Serializable)this.fencingTokenSupplier.get(), message);
        }
        if (message instanceof Serializable) {
            RemoteFencedMessage result = new RemoteFencedMessage((Serializable)this.fencingTokenSupplier.get(), (Serializable)message);
            return result;
        }
        throw new RuntimeException("Trying to send a non-serializable message " + message + " to a remote RpcEndpoint. Please make sure that the message implements java.io.Serializable.");
    }
}

