/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algox.flink.enhance.krpc;

import java.io.Serializable;
import java.util.Objects;
import kd.bos.algox.flink.enhance.krpc.Dispatcher;
import kd.bos.algox.flink.enhance.krpc.MsgPlus;
import kd.bos.algox.flink.enhance.krpc.impl.ActorImpl;
import kd.bos.algox.flink.enhance.krpc.impl.DispatcherImpl;
import org.apache.flink.runtime.rpc.FencedRpcEndpoint;
import org.apache.flink.runtime.rpc.akka.exceptions.AkkaUnknownMessageException;
import org.apache.flink.runtime.rpc.exceptions.FencingTokenException;
import org.apache.flink.runtime.rpc.messages.FencedMessage;
import org.apache.flink.runtime.rpc.messages.LocalFencedMessage;
import org.apache.flink.runtime.rpc.messages.UnfencedMessage;

public class KFencedAkkaRpcActor<F extends Serializable, T extends FencedRpcEndpoint<F>>
extends ActorImpl<T> {
    public KFencedAkkaRpcActor(String endpointName, Dispatcher dispatcher, T rpcEndpoint) {
        super(endpointName, dispatcher, rpcEndpoint);
    }

    @Override
    protected void handleMsgPlus0(MsgPlus msgPlus) {
        Object message = msgPlus.getMsg();
        if (message instanceof FencedMessage) {
            Serializable expectedFencingToken = ((FencedRpcEndpoint)this.rpcEndpoint).getFencingToken();
            if (expectedFencingToken == null) {
                if (DispatcherImpl.log.isDebugEnabled()) {
                    DispatcherImpl.log.debug("Fencing token not set: Ignoring message {} because the fencing token is null.", message);
                }
                msgPlus.responseException((Throwable)new FencingTokenException(String.format("Fencing token not set: Ignoring message %s sent to %s because the fencing token is null.", message, ((FencedRpcEndpoint)this.rpcEndpoint).getAddress())));
            } else {
                FencedMessage fencedMessage = (FencedMessage)message;
                Serializable fencingToken = fencedMessage.getFencingToken();
                if (Objects.equals(expectedFencingToken, fencingToken)) {
                    super.handleMsgPlus0(msgPlus.fencedMsg(fencedMessage.getPayload()));
                } else {
                    if (DispatcherImpl.log.isDebugEnabled()) {
                        DispatcherImpl.log.debug("Fencing token mismatch: Ignoring message {} because the fencing token {} did not match the expected fencing token {}.", new Object[]{message, fencingToken, expectedFencingToken});
                    }
                    msgPlus.responseException((Throwable)new FencingTokenException("Fencing token mismatch: Ignoring message " + message + " because the fencing token " + fencingToken + " did not match the expected fencing token " + expectedFencingToken + '.'));
                }
            }
        } else if (message instanceof UnfencedMessage) {
            super.handleMsgPlus0(msgPlus.fencedMsg(((UnfencedMessage)message).getPayload()));
        } else {
            if (DispatcherImpl.log.isDebugEnabled()) {
                DispatcherImpl.log.debug("Unknown message type: Ignoring message {} because it is neither of type {} nor {}.", new Object[]{message, FencedMessage.class.getSimpleName(), UnfencedMessage.class.getSimpleName()});
            }
            msgPlus.responseException((Throwable)new AkkaUnknownMessageException("Unknown message type: Ignoring message " + message + " of type " + message.getClass().getSimpleName() + " because it is neither of type " + FencedMessage.class.getSimpleName() + " nor " + UnfencedMessage.class.getSimpleName() + '.'));
        }
    }

    @Override
    protected Object envelopeSelfMessage(Object message) {
        Serializable fencingToken = ((FencedRpcEndpoint)this.rpcEndpoint).getFencingToken();
        return new LocalFencedMessage(fencingToken, message);
    }
}

