/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algox.flink.enhance.krpc;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import kd.bos.algox.flink.enhance.krpc.Actor;
import kd.bos.algox.flink.enhance.krpc.ActorRef;
import kd.bos.algox.flink.enhance.krpc.KAkkaInvocationHandler;
import kd.bos.algox.flink.enhance.krpc.KFencedAkkaInvocationHandler;
import kd.bos.algox.flink.enhance.krpc.KScheduledExecutor;
import kd.bos.algox.flink.enhance.krpc.ThreadPoolSupplier;
import kd.bos.algox.flink.enhance.krpc.ThreadPoolSuppliers;
import kd.bos.algox.flink.enhance.krpc.URI;
import kd.bos.algox.flink.enhance.krpc.impl.DispatcherConfig;
import kd.bos.algox.flink.enhance.krpc.impl.DispatcherImpl;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.concurrent.FutureUtils;
import org.apache.flink.runtime.concurrent.ScheduledExecutor;
import org.apache.flink.runtime.rpc.FencedMainThreadExecutable;
import org.apache.flink.runtime.rpc.FencedRpcEndpoint;
import org.apache.flink.runtime.rpc.FencedRpcGateway;
import org.apache.flink.runtime.rpc.RpcEndpoint;
import org.apache.flink.runtime.rpc.RpcGateway;
import org.apache.flink.runtime.rpc.RpcServer;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.runtime.rpc.RpcUtils;
import org.apache.flink.runtime.rpc.akka.ControlMessages;
import org.apache.flink.util.AutoCloseableAsync;
import org.apache.flink.util.ExecutorUtils;
import org.apache.flink.util.Preconditions;

public class KRpcService
implements RpcService {
    private final String host;
    private final DispatcherImpl dispatcher;
    private final DispatcherConfig config;
    private final KScheduledExecutor scheduledExecutor;
    private final CompletableFuture<Void> terminateFuture = new CompletableFuture();
    private final ConcurrentHashMap<ActorRef, RpcEndpoint> actors = new ConcurrentHashMap();

    public KRpcService(String host, int port, ThreadPoolSupplier threadPoolSupplier) {
        this.host = host;
        this.config = new DispatcherConfig();
        this.config.setBindAddress(this.host);
        this.config.setPort(port);
        this.dispatcher = new DispatcherImpl(this.config, threadPoolSupplier);
        try {
            this.dispatcher.start();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        this.scheduledExecutor = new KScheduledExecutor(this.dispatcher, threadPoolSupplier);
        this.dispatcher.setScheduledExecutor(this.scheduledExecutor);
    }

    public KRpcService(DispatcherConfig config) {
        ThreadPoolSupplier threadPoolSupplier = ThreadPoolSuppliers.getDefault();
        this.host = config.getBindAddress();
        this.dispatcher = new DispatcherImpl(config, threadPoolSupplier);
        this.config = config;
        try {
            this.dispatcher.start();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        this.scheduledExecutor = new KScheduledExecutor(this.dispatcher, threadPoolSupplier);
        this.dispatcher.setScheduledExecutor(this.scheduledExecutor);
    }

    public String getAddress() {
        return this.host;
    }

    public int getPort() {
        return this.dispatcher.getPort();
    }

    public <C extends RpcGateway> CompletableFuture<C> connect(String address, Class<C> clazz) {
        return this.connectInternal(address, clazz, pair -> new KAkkaInvocationHandler(((URI)pair.k).getAddress(), ((URI)pair.k).getHost(), (ActorRef)pair.v, Time.of((long)10L, (TimeUnit)TimeUnit.MINUTES), this.config.getMaxFrameSize(), null, true));
    }

    public <F extends Serializable, C extends FencedRpcGateway<F>> CompletableFuture<C> connect(String address, F f, Class<C> clazz) {
        return this.connectInternal(address, clazz, pair -> new KFencedAkkaInvocationHandler<Serializable>(((URI)pair.k).getAddress(), ((URI)pair.k).getHost(), (ActorRef)pair.v, Time.of((long)10L, (TimeUnit)TimeUnit.MINUTES), this.config.getMaxFrameSize(), null, () -> f, true));
    }

    private <C extends RpcGateway> CompletableFuture<C> connectInternal(final String address, final Class<C> clazz, final Function<Pair<URI, ActorRef>, InvocationHandler> invocationHandlerFactory) {
        return CompletableFuture.supplyAsync(new Supplier<C>(){

            @Override
            public C get() {
                URI uri = URI.parseURI(address);
                if (uri == null) {
                    throw new RuntimeException("parse address error: " + address);
                }
                DispatcherImpl.log.debug("Try to connect to remote RPC endpoint with address {}. Returning a {} gateway.", (Object)address, (Object)clazz.getName());
                ActorRef actorRef = KRpcService.this.dispatcher.createActorRef(uri.getEndpoint(), uri.getHost(), uri.getPort());
                InvocationHandler invocationHandler = (InvocationHandler)invocationHandlerFactory.apply(new Pair<URI, ActorRef>(uri, actorRef));
                ClassLoader classLoader = this.getClass().getClassLoader();
                RpcGateway proxy = (RpcGateway)Proxy.newProxyInstance(classLoader, new Class[]{clazz}, invocationHandler);
                return proxy;
            }
        }, this.getExecutor());
    }

    public <C extends RpcEndpoint> RpcServer startServer(C rpcEndpoint) {
        KFencedAkkaInvocationHandler<Serializable> akkaInvocationHandler;
        Preconditions.checkNotNull(rpcEndpoint, (String)"rpc endpoint");
        DispatcherImpl.log.info("Starting RPC endpoint for {}.", (Object)rpcEndpoint.getClass().getName());
        HashSet<Class<FencedMainThreadExecutable>> implementedRpcGateways = new HashSet<Class<FencedMainThreadExecutable>>(RpcUtils.extractImplementedRpcGateways(rpcEndpoint.getClass()));
        String endpointId = rpcEndpoint.getEndpointId();
        implementedRpcGateways.add(RpcServer.class);
        implementedRpcGateways.add(FencedMainThreadExecutable.class);
        Actor actor = this.dispatcher.createActor(endpointId, rpcEndpoint);
        ActorRef actorRef = this.dispatcher.createActorRef(endpointId, this.host, this.getPort());
        String address = "krpc://cosmic@" + this.host + ':' + this.getPort() + '/' + rpcEndpoint.getEndpointId();
        DispatcherImpl.log.debug("krpc start server:{} at: {}", (Object)rpcEndpoint.getEndpointId(), (Object)address);
        if (rpcEndpoint instanceof FencedRpcEndpoint) {
            akkaInvocationHandler = new KFencedAkkaInvocationHandler<Serializable>(address, this.host, actorRef, Time.of((long)10L, (TimeUnit)TimeUnit.MINUTES), this.config.getMaxFrameSize(), actor.getActorTerminateFuture(), () -> ((FencedRpcEndpoint)((FencedRpcEndpoint)rpcEndpoint)).getFencingToken(), true);
            implementedRpcGateways.add(FencedMainThreadExecutable.class);
        } else {
            akkaInvocationHandler = new KFencedAkkaInvocationHandler<Serializable>(address, this.host, actorRef, Time.of((long)10L, (TimeUnit)TimeUnit.MINUTES), this.config.getMaxFrameSize(), actor.getActorTerminateFuture(), true);
        }
        this.actors.put(actorRef, rpcEndpoint);
        ClassLoader classLoader = this.getClass().getClassLoader();
        RpcServer server = (RpcServer)Proxy.newProxyInstance(classLoader, implementedRpcGateways.toArray(new Class[implementedRpcGateways.size()]), akkaInvocationHandler);
        return server;
    }

    public <F extends Serializable> RpcServer fenceRpcServer(RpcServer rpcServer, F f) {
        if (Proxy.isProxyClass(rpcServer.getClass())) {
            rpcServer = (RpcServer)Proxy.getInvocationHandler(rpcServer);
        }
        if (rpcServer instanceof KAkkaInvocationHandler) {
            KFencedAkkaInvocationHandler<Serializable> fencedInvocationHandler = new KFencedAkkaInvocationHandler<Serializable>(rpcServer.getAddress(), rpcServer.getHostname(), ((KAkkaInvocationHandler)rpcServer).getActorRef(), Time.of((long)10L, (TimeUnit)TimeUnit.MINUTES), this.config.getMaxFrameSize(), null, () -> f, true);
            ClassLoader classLoader = this.getClass().getClassLoader();
            return (RpcServer)Proxy.newProxyInstance(classLoader, new Class[]{RpcServer.class}, fencedInvocationHandler);
        }
        throw new UnsupportedOperationException("Unsupported fenceRpcServer without DubboInvocationHandler.");
    }

    public void stopServer(RpcServer selfGateway) {
        InvocationHandler invocationHandler1;
        KAkkaInvocationHandler invocationHandler = null;
        if (Proxy.isProxyClass(selfGateway.getClass()) && (invocationHandler1 = Proxy.getInvocationHandler(selfGateway)) instanceof KAkkaInvocationHandler) {
            invocationHandler = (KAkkaInvocationHandler)invocationHandler1;
        }
        if (invocationHandler != null) {
            ActorRef actorRef = invocationHandler.getActorRef();
            RpcEndpoint rpcEndpoint = this.actors.get(actorRef);
            this.terminateAkkaRpcActor(actorRef, rpcEndpoint);
        }
    }

    private CompletableFuture<Void> terminateAkkaRpcActor(ActorRef akkaRpcActorRef, RpcEndpoint rpcEndpoint) {
        akkaRpcActorRef.tell(ControlMessages.TERMINATE);
        return rpcEndpoint.getTerminationFuture().whenComplete((d, t) -> {
            this.actors.remove(akkaRpcActorRef);
            akkaRpcActorRef.close();
        });
    }

    public CompletableFuture<Void> stopService() {
        ArrayList<CompletableFuture<Void>> akkaRpcActorTerminationFutures = new ArrayList<CompletableFuture<Void>>(this.actors.size());
        for (Map.Entry<ActorRef, RpcEndpoint> actorRefRpcEndpointEntry : this.actors.entrySet()) {
            akkaRpcActorTerminationFutures.add(this.terminateAkkaRpcActor(actorRefRpcEndpointEntry.getKey(), actorRefRpcEndpointEntry.getValue()));
        }
        this.actors.clear();
        this.dispatcher.shutdownAsync();
        akkaRpcActorTerminationFutures.add(this.dispatcher.getShutdownFuture());
        FutureUtils.ConjunctFuture actorsTerminateFutures = FutureUtils.waitForAll(akkaRpcActorTerminationFutures);
        actorsTerminateFutures.whenComplete((result, exception) -> {
            if (exception != null) {
                this.terminateFuture.completeExceptionally((Throwable)exception);
            } else {
                this.terminateFuture.complete((Void)result);
            }
        });
        return this.getTerminationFuture();
    }

    public CompletableFuture<Void> getTerminationFuture() {
        return this.terminateFuture;
    }

    public Executor getExecutor() {
        return this.dispatcher.getExecutorService();
    }

    public ScheduledExecutor getScheduledExecutor() {
        return this.scheduledExecutor;
    }

    public ScheduledFuture<?> scheduleRunnable(Runnable runnable, long l, TimeUnit timeUnit) {
        return this.getScheduledExecutor().schedule(runnable, l, timeUnit);
    }

    public void execute(Runnable runnable) {
        this.dispatcher.getExecutorService().submit(runnable);
    }

    public <T> CompletableFuture<T> execute(Callable<T> callable) {
        CompletableFuture completableFuture = new CompletableFuture();
        this.dispatcher.getExecutorService().submit(() -> {
            try {
                Object r = callable.call();
                completableFuture.complete(r);
            }
            catch (Exception e) {
                completableFuture.completeExceptionally(e);
            }
        });
        return completableFuture;
    }

    public static class Pair<K, V> {
        public final K k;
        public final V v;

        public Pair(K k, V v) {
            this.k = k;
            this.v = v;
        }
    }

    private static final class Supervisor
    implements AutoCloseableAsync {
        private final ActorRef actor;
        private final ExecutorService terminationFutureExecutor;

        private Supervisor(ActorRef actor, ExecutorService terminationFutureExecutor) {
            this.actor = actor;
            this.terminationFutureExecutor = terminationFutureExecutor;
        }

        private static Supervisor create(ActorRef actorRef, ExecutorService terminationFutureExecutor) {
            return new Supervisor(actorRef, terminationFutureExecutor);
        }

        public ActorRef getActor() {
            return this.actor;
        }

        public CompletableFuture<Void> closeAsync() {
            return ExecutorUtils.nonBlockingShutdown((long)30L, (TimeUnit)TimeUnit.SECONDS, (ExecutorService[])new ExecutorService[]{this.terminationFutureExecutor});
        }
    }
}

