/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algox.flink.enhance.krpc;

import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import kd.bos.algox.flink.enhance.krpc.Dispatcher;
import kd.bos.algox.flink.enhance.krpc.ThreadPoolSupplier;
import org.apache.flink.runtime.concurrent.ScheduledExecutor;
import org.jetbrains.annotations.NotNull;

public class KScheduledExecutor
implements ScheduledExecutor {
    private final Dispatcher dispatcher;
    private final ScheduledExecutorService scheduledExecutorService;

    public KScheduledExecutor(Dispatcher dispatcher, ThreadPoolSupplier threadPoolSupplier) {
        this.dispatcher = dispatcher;
        this.scheduledExecutorService = threadPoolSupplier.getScheduleExecutorService();
    }

    public ScheduledFuture<?> schedule(Runnable runnable, long l, TimeUnit timeUnit) {
        return this.scheduledExecutorService.schedule(() -> this.dispatcher.getExecutorService().submit(runnable), l, timeUnit);
    }

    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long l, TimeUnit timeUnit) {
        return this.scheduledExecutorService.schedule(() -> this.dispatcher.getExecutorService().submit(callable), l, timeUnit);
    }

    public ScheduledFuture<?> scheduleAtFixedRate(Runnable runnable, long l, long l1, TimeUnit timeUnit) {
        return this.scheduledExecutorService.scheduleAtFixedRate(() -> this.dispatcher.getExecutorService().submit(runnable), l, l1, timeUnit);
    }

    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable runnable, long l, long l1, TimeUnit timeUnit) {
        return this.scheduledExecutorService.scheduleWithFixedDelay(() -> this.dispatcher.getExecutorService().submit(runnable), l, l1, timeUnit);
    }

    public void execute(@NotNull Runnable command) {
        this.dispatcher.getExecutorService().submit(command);
    }
}

