/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algox.flink.enhance.krpc;

import java.util.Optional;
import javax.annotation.Nullable;
import kd.bos.algox.flink.enhance.krpc.HostUtils;
import kd.bos.algox.flink.enhance.krpc.KRpcService;
import kd.bos.algox.flink.enhance.krpc.impl.DispatcherConfig;
import kd.bos.algox.flink.utils.AkkaProtocolUtil;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.util.NetUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpcServiceFactory {
    private static final Logger LOG = LoggerFactory.getLogger(RpcServiceFactory.class);

    private RpcServiceFactory() {
    }

    public static boolean usingKRpc() {
        if (Boolean.getBoolean("algox.krpc.force-enable")) {
            return true;
        }
        if (AkkaProtocolUtil.isArtery()) {
            LOG.info("flink rpc use artery");
            return false;
        }
        try {
            Class.forName("org.jboss.netty.bootstrap.Bootstrap");
            LOG.info("flink rpc use akka-netty3");
            return false;
        }
        catch (Exception exception) {
            LOG.info("flink rpc use krpc");
            return true;
        }
    }

    public static RpcService createKRpcService(DispatcherConfig config, @Nullable String externalAddress, String externalPortRange, @Nullable String bindAddress, Optional<Integer> bindPort) {
        String host;
        String string = host = externalAddress == null ? HostUtils.getHostAddress() : externalAddress;
        if (bindAddress != null) {
            host = bindAddress;
        }
        int port = (Integer)NetUtils.getPortRangeFromString((String)externalPortRange).next();
        if (bindPort.isPresent()) {
            port = bindPort.get();
        }
        config.setBindAddress(host);
        config.setPort(port);
        return new KRpcService(config);
    }

    public static RpcService createKRpcService4Metric(DispatcherConfig config) throws Exception {
        return new KRpcService(config);
    }
}

