/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algox.flink.enhance.krpc;

import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.text.MessageFormat;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.algox.flink.cluster.ClusterClientConfig;
import kd.bos.algox.flink.cluster.InvokeMode;
import kd.bos.algox.flink.enhance.krpc.ThreadPoolSupplier;
import org.jetbrains.annotations.NotNull;

public class SystemPropertiesConfigurationThreadPoolSupplier
implements ThreadPoolSupplier {
    static final SystemPropertiesConfigurationThreadPoolSupplier instance = new SystemPropertiesConfigurationThreadPoolSupplier();
    private volatile NioEventLoopGroup clientEventLoopGroup = null;
    private volatile NioEventLoopGroup serverBossLoopGroup = null;
    private volatile ExecutorService dispatcherExecutorService = null;
    private volatile ScheduledExecutorService scheduleExecutorService = null;

    private boolean transportSharedThreadPool() {
        return Boolean.parseBoolean(System.getProperty("algox.krpc.transport.isSharedThread", "true"));
    }

    private int getClientEventLoopGroupThreadCount() {
        return Integer.parseInt(System.getProperty("algox.krpc.transport.clientThreadCount", "1"));
    }

    private boolean isRemote() {
        InvokeMode invokeMode = ClusterClientConfig.getType();
        return invokeMode == InvokeMode.REMOTE;
    }

    private int getServerBossLoopGroupThreadCount() {
        String defaultValue = "1";
        if (this.isRemote()) {
            defaultValue = "2";
        }
        return Integer.parseInt(System.getProperty("algox.krpc.transport.threadCount", defaultValue));
    }

    public int getDispatcherExecutorServiceThreadCount() {
        String defaultValue = "2";
        if (this.isRemote()) {
            defaultValue = "4";
        }
        return Integer.parseInt(System.getProperty("algox.krpc.dispatcher.threadCount", defaultValue));
    }

    public boolean dispatcherSharedThreadPool() {
        return Boolean.parseBoolean(System.getProperty("algox.krpc.dispatcher.isSharedThread", "true"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NioEventLoopGroup getClientEventLoopGroup() {
        if (this.clientEventLoopGroup != null) {
            return this.clientEventLoopGroup;
        }
        SystemPropertiesConfigurationThreadPoolSupplier systemPropertiesConfigurationThreadPoolSupplier = this;
        synchronized (systemPropertiesConfigurationThreadPoolSupplier) {
            if (this.clientEventLoopGroup == null) {
                this.clientEventLoopGroup = new NioEventLoopGroup(this.getClientEventLoopGroupThreadCount(), (ThreadFactory)new NamedThreadFactory("AlgoX-KRpcClient"));
            }
        }
        return this.clientEventLoopGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NioEventLoopGroup getServerBossLoopGroup() {
        if (!this.transportSharedThreadPool()) {
            return new NioEventLoopGroup(this.getServerBossLoopGroupThreadCount(), (ThreadFactory)new NamedThreadFactory("AlgoX-KRpcBoss"));
        }
        if (this.serverBossLoopGroup != null) {
            return this.serverBossLoopGroup;
        }
        SystemPropertiesConfigurationThreadPoolSupplier systemPropertiesConfigurationThreadPoolSupplier = this;
        synchronized (systemPropertiesConfigurationThreadPoolSupplier) {
            if (this.serverBossLoopGroup == null) {
                this.serverBossLoopGroup = new NioEventLoopGroup(this.getServerBossLoopGroupThreadCount(), (ThreadFactory)new NamedThreadFactory("AlgoX-KRpcBoss"));
            }
        }
        return this.serverBossLoopGroup;
    }

    @Override
    public NioEventLoopGroup getServerWorkerLoopGroup() {
        return this.getServerBossLoopGroup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExecutorService getDispatcherExecutorService() {
        if (!this.dispatcherSharedThreadPool()) {
            return new ThreadPoolExecutor(this.getDispatcherExecutorServiceThreadCount(), this.getDispatcherExecutorServiceThreadCount(), 0L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(), new NamedThreadFactory("AlgoX-KRpcDispatcher"));
        }
        if (this.dispatcherExecutorService != null) {
            return this.dispatcherExecutorService;
        }
        SystemPropertiesConfigurationThreadPoolSupplier systemPropertiesConfigurationThreadPoolSupplier = this;
        synchronized (systemPropertiesConfigurationThreadPoolSupplier) {
            if (this.dispatcherExecutorService == null) {
                this.dispatcherExecutorService = new ThreadPoolExecutor(this.getDispatcherExecutorServiceThreadCount(), this.getDispatcherExecutorServiceThreadCount(), 0L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(), new NamedThreadFactory("AlgoX-KRpcDispatcher"));
            }
        }
        return this.dispatcherExecutorService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScheduledExecutorService getScheduleExecutorService() {
        if (this.scheduleExecutorService != null) {
            return this.scheduleExecutorService;
        }
        SystemPropertiesConfigurationThreadPoolSupplier systemPropertiesConfigurationThreadPoolSupplier = this;
        synchronized (systemPropertiesConfigurationThreadPoolSupplier) {
            if (this.scheduleExecutorService == null) {
                this.scheduleExecutorService = Executors.newScheduledThreadPool(1, (ThreadFactory)new DefaultThreadFactory("AlgoX-KRpcSchedule", true));
            }
        }
        return this.scheduleExecutorService;
    }

    public static class NamedThreadFactory
    implements ThreadFactory {
        private final String name;
        private final AtomicInteger count = new AtomicInteger();

        public NamedThreadFactory(String name) {
            this.name = name;
        }

        @Override
        public Thread newThread(@NotNull Runnable r) {
            Thread thread = new Thread(r);
            thread.setName(MessageFormat.format("{0}-{1}", this.name, this.count.getAndIncrement()));
            return thread;
        }
    }
}

