/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algox.flink.enhance.krpc;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class URI {
    private static final Pattern URI_PATTERN = Pattern.compile("^(.+)://(\\w+@)?(.+):(-?\\d+)(/.+)");
    private final String schema;
    private final String user;
    private final String host;
    private final int port;
    private final String path;
    private final String endpoint;
    private final String address;

    private URI(String schema, String user, String host, int port, String path, String address) {
        this.schema = schema;
        this.user = user;
        this.host = host;
        this.port = port;
        this.path = path;
        this.endpoint = this.parseEndpointFromPath(path);
        this.address = address;
    }

    public static URI parseURI(String address) {
        Matcher matcher = URI_PATTERN.matcher(address);
        if (matcher.find()) {
            String schema = matcher.group(1);
            String user = matcher.group(2);
            if (user != null) {
                user = user.substring(0, user.length() - 1);
            }
            String host = matcher.group(3);
            int port = Integer.parseInt(matcher.group(4));
            String path = matcher.group(5);
            return new URI(schema, user, host, port, path, address);
        }
        return null;
    }

    private String parseEndpointFromPath(String path) {
        return path.substring(path.lastIndexOf("/") + 1);
    }

    public String getSchema() {
        return this.schema;
    }

    public String getUser() {
        return this.user;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public String getPath() {
        return this.path;
    }

    public String getAddress() {
        return this.address;
    }
}

