/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algox.flink.enhance.krpc.impl;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.algox.flink.enhance.krpc.Actor;
import kd.bos.algox.flink.enhance.krpc.Dispatcher;
import kd.bos.algox.flink.enhance.krpc.KFencedAkkaRpcActor;
import kd.bos.algox.flink.enhance.krpc.MailBox;
import kd.bos.algox.flink.enhance.krpc.MsgPlus;
import kd.bos.algox.flink.enhance.krpc.impl.DispatcherImpl;
import kd.bos.algox.flink.enhance.krpc.impl.HeartbeatMessage;
import kd.bos.algox.flink.enhance.krpc.impl.MailBoxImpl;
import kd.bos.algox.flink.enhance.krpc.impl.PoisonPill;
import kd.bos.algox.flink.enhance.krpc.impl.ReleasableResourceHolder;
import org.apache.flink.runtime.concurrent.FutureUtils;
import org.apache.flink.runtime.rpc.MainThreadValidatorUtil;
import org.apache.flink.runtime.rpc.RpcEndpoint;
import org.apache.flink.runtime.rpc.akka.ControlMessages;
import org.apache.flink.runtime.rpc.akka.exceptions.AkkaRpcException;
import org.apache.flink.runtime.rpc.akka.exceptions.AkkaRpcInvalidStateException;
import org.apache.flink.runtime.rpc.akka.exceptions.AkkaUnknownMessageException;
import org.apache.flink.runtime.rpc.exceptions.RpcConnectionException;
import org.apache.flink.runtime.rpc.messages.CallAsync;
import org.apache.flink.runtime.rpc.messages.RpcInvocation;
import org.apache.flink.runtime.rpc.messages.RunAsync;
import org.apache.flink.runtime.rpc.messages.UnfencedMessage;
import org.apache.flink.util.Preconditions;

public class ActorImpl<T extends RpcEndpoint>
implements Actor {
    private final String endpointName;
    private final MailBox mailBox;
    private final Dispatcher dispatcher;
    private final CompletableFuture<Void> terminateFuture = new CompletableFuture();
    private final ReleasableResourceHolder resourceHolder = new ReleasableResourceHolder();
    protected final T rpcEndpoint;
    private final AtomicBoolean rpcEndpointStopped;
    private volatile RpcEndpointTerminationResult rpcEndpointTerminationResult;
    private final MainThreadValidatorUtil mainThreadValidator;
    private State state;

    public ActorImpl(String endpointName, Dispatcher dispatcher, T rpcEndpoint) {
        this.endpointName = endpointName;
        this.mailBox = new MailBoxImpl(this);
        this.dispatcher = dispatcher;
        this.rpcEndpoint = rpcEndpoint;
        this.rpcEndpointStopped = new AtomicBoolean(false);
        this.rpcEndpointTerminationResult = RpcEndpointTerminationResult.failure((Throwable)new AkkaRpcException(String.format("RpcEndpoint %s has not been properly stopped.", rpcEndpoint.getEndpointId())));
        this.mainThreadValidator = new MainThreadValidatorUtil(rpcEndpoint);
        this.state = StoppedState.STOPPED;
    }

    @Override
    public void postMessage(MsgPlus msgPlus) {
        this.mailBox.postMessage(msgPlus);
    }

    @Override
    public boolean isInProcess() {
        return this.mailBox.isInProcess();
    }

    @Override
    public void process() {
        this.mailBox.process();
    }

    @Override
    public void addReleasableResource(AutoCloseable closeable) {
        this.resourceHolder.bind(closeable);
    }

    private void handleControlMessage(ControlMessages controlMessage, MsgPlus msgPlus) {
        try {
            switch (controlMessage) {
                case START: {
                    this.state = this.state.start(this);
                    break;
                }
                case STOP: {
                    this.state = this.state.stop();
                    break;
                }
                case TERMINATE: {
                    this.state = this.state.terminate(this);
                    break;
                }
                default: {
                    this.handleUnknownControlMessage(controlMessage, msgPlus);
                    break;
                }
            }
        }
        catch (Exception e) {
            this.rpcEndpointTerminationResult = RpcEndpointTerminationResult.failure(e);
            throw e;
        }
    }

    private void handleUnknownControlMessage(ControlMessages controlMessage, MsgPlus msgPlus) {
        String message = String.format("Received unknown control message %s. Dropping this message!", controlMessage);
        DispatcherImpl.log.warn(message);
        msgPlus.responseException((Throwable)new AkkaUnknownMessageException(message));
    }

    @Override
    public CompletableFuture<Void> getActorTerminateFuture() {
        return this.terminateFuture;
    }

    @Override
    public void handleMsgPlus(MsgPlus msgPlus) {
        if (msgPlus instanceof PoisonPill) {
            this.state.terminate(this);
        } else if (msgPlus.getMsg() instanceof ControlMessages) {
            this.handleControlMessage((ControlMessages)msgPlus.getMsg(), msgPlus);
        } else if (msgPlus.getMsg() instanceof HeartbeatMessage) {
            msgPlus.responseSuccess(new HeartbeatMessage());
        } else if (this.state.isRunning()) {
            this.mainThreadValidator.enterMainThread();
            try {
                this.handleMsgPlus0(msgPlus);
            }
            finally {
                this.mainThreadValidator.exitMainThread();
            }
        } else {
            DispatcherImpl.log.info("The rpc endpoint {} has not been started yet. Discarding message {} until processing is started.", (Object)this.endpointName, (Object)msgPlus.getMsg().getClass().getName());
            msgPlus.responseException((Throwable)new AkkaRpcException(String.format("Discard message, because the rpc endpoint %s has not been started yet.", this.endpointName)));
        }
    }

    protected void handleMsgPlus0(MsgPlus msgPlus) {
        Object target = msgPlus.getMsg();
        if (target instanceof RunAsync) {
            this.handleRunAsync((RunAsync)target, msgPlus);
        } else if (target instanceof CallAsync) {
            this.handleCallAsync((CallAsync)target, msgPlus);
        } else if (target instanceof RpcInvocation) {
            this.handleRpcInvocation((RpcInvocation)target, msgPlus);
        } else {
            DispatcherImpl.log.warn("Received message of unknown type {} with value {}. Dropping this message!", (Object)msgPlus.getMsg().getClass().getName(), msgPlus.getMsg());
            msgPlus.responseException((Throwable)new AkkaUnknownMessageException("Received unknown message " + msgPlus.getMsg() + " of type " + msgPlus.getMsg().getClass().getSimpleName() + '.'));
        }
    }

    private void handleRpcInvocation(RpcInvocation rpcInvocation, MsgPlus msgPlus) {
        block12: {
            RpcConnectionException rpcException;
            Method rpcMethod = null;
            try {
                String methodName = rpcInvocation.getMethodName();
                Class[] parameterTypes = rpcInvocation.getParameterTypes();
                rpcMethod = this.rpcEndpoint.getClass().getMethod(methodName, parameterTypes);
            }
            catch (ClassNotFoundException e) {
                DispatcherImpl.log.error("Could not load method arguments.", (Throwable)e);
                rpcException = new RpcConnectionException("Could not load method arguments.", (Throwable)e);
                msgPlus.responseException((Throwable)rpcException);
            }
            catch (IOException e) {
                DispatcherImpl.log.error("Could not deserialize rpc invocation message.", (Throwable)e);
                rpcException = new RpcConnectionException("Could not deserialize rpc invocation message.", (Throwable)e);
                msgPlus.responseException((Throwable)rpcException);
            }
            catch (NoSuchMethodException e) {
                DispatcherImpl.log.error("Could not find rpc method for rpc invocation.", (Throwable)e);
                rpcException = new RpcConnectionException("Could not find rpc method for rpc invocation.", (Throwable)e);
                msgPlus.responseException((Throwable)rpcException);
            }
            if (rpcMethod != null) {
                try {
                    Object result;
                    rpcMethod.setAccessible(true);
                    if (rpcMethod.getReturnType().equals(Void.TYPE)) {
                        rpcMethod.invoke(this.rpcEndpoint, rpcInvocation.getArgs());
                        break block12;
                    }
                    try {
                        result = rpcMethod.invoke(this.rpcEndpoint, rpcInvocation.getArgs());
                    }
                    catch (InvocationTargetException e) {
                        DispatcherImpl.log.debug("Reporting back error thrown in remote procedure {}", (Object)rpcMethod, (Object)e);
                        msgPlus.responseException(e.getTargetException());
                        return;
                    }
                    if (result instanceof CompletableFuture) {
                        CompletableFuture responseFuture = (CompletableFuture)result;
                        responseFuture.whenComplete((o, throwable) -> {
                            if (throwable != null) {
                                msgPlus.responseException((Throwable)throwable);
                            } else {
                                msgPlus.responseSuccess(o);
                            }
                        });
                    } else {
                        msgPlus.responseSuccess(result);
                    }
                }
                catch (Throwable e) {
                    DispatcherImpl.log.error("Error while executing remote procedure call {}.", (Object)rpcMethod, (Object)e);
                    msgPlus.responseException(e);
                }
            }
        }
    }

    private void handleCallAsync(CallAsync callAsync, MsgPlus msgPlus) {
        try {
            Object result = callAsync.getCallable().call();
            msgPlus.responseSuccess(result);
        }
        catch (Throwable e) {
            msgPlus.responseException(e);
        }
    }

    private void handleRunAsync(RunAsync runAsync, MsgPlus msgPlus) {
        long delayNanos;
        long timeToRun = runAsync.getTimeNanos();
        if (timeToRun == 0L || (delayNanos = timeToRun - System.nanoTime()) <= 0L) {
            try {
                runAsync.getRunnable().run();
            }
            catch (Throwable t) {
                DispatcherImpl.log.error("Caught exception while executing runnable in main thread.", t);
                throw new RuntimeException(t);
            }
        } else {
            RunAsync message = new RunAsync(runAsync.getRunnable(), timeToRun);
            if (this.getClass().equals(KFencedAkkaRpcActor.class)) {
                message = new UnfencedMessage((Object)message);
            }
            MsgPlus msg = msgPlus.fencedMsg(message);
            this.dispatcher.getScheduledExecutor().schedule(() -> this.dispatcher.postMessage(msg), timeToRun - System.nanoTime(), TimeUnit.NANOSECONDS);
        }
    }

    protected Object envelopeSelfMessage(Object message) {
        return message;
    }

    public void postStop() {
        this.resourceHolder.close();
        if (this.rpcEndpointTerminationResult.isSuccess()) {
            DispatcherImpl.log.debug("The RpcEndpoint {} terminated successfully.", (Object)this.rpcEndpoint.getEndpointId());
            this.terminateFuture.complete(null);
        } else {
            DispatcherImpl.log.info("The RpcEndpoint {} failed.", (Object)this.rpcEndpoint.getEndpointId(), (Object)this.rpcEndpointTerminationResult.getFailureCause());
            this.terminateFuture.completeExceptionally(this.rpcEndpointTerminationResult.getFailureCause());
        }
        this.state = this.state.finishTermination();
    }

    private void stop(RpcEndpointTerminationResult rpcEndpointTerminationResult) {
        if (this.rpcEndpointStopped.compareAndSet(false, true)) {
            this.rpcEndpointTerminationResult = rpcEndpointTerminationResult;
            this.postStop();
        }
    }

    public String toString() {
        return "ActorImpl{endpointName='" + this.endpointName + '\'' + '}';
    }

    private static final class RpcEndpointTerminationResult {
        private static final RpcEndpointTerminationResult SUCCESS = new RpcEndpointTerminationResult(null);
        private final Throwable failureCause;

        private RpcEndpointTerminationResult(Throwable failureCause) {
            this.failureCause = failureCause;
        }

        public boolean isSuccess() {
            return this.failureCause == null;
        }

        public Throwable getFailureCause() {
            Preconditions.checkState((this.failureCause != null ? 1 : 0) != 0);
            return this.failureCause;
        }

        private static RpcEndpointTerminationResult success() {
            return SUCCESS;
        }

        private static RpcEndpointTerminationResult failure(Throwable failureCause) {
            return new RpcEndpointTerminationResult(failureCause);
        }

        private static RpcEndpointTerminationResult of(Throwable failureCause) {
            if (failureCause == null) {
                return RpcEndpointTerminationResult.success();
            }
            return RpcEndpointTerminationResult.failure(failureCause);
        }
    }

    static enum TerminatedState implements State
    {
        TERMINATED;

    }

    static enum TerminatingState implements State
    {
        TERMINATING;


        @Override
        public State terminate(ActorImpl actor) {
            return TERMINATING;
        }

        @Override
        public boolean isRunning() {
            return true;
        }
    }

    static enum StoppedState implements State
    {
        STOPPED;


        @Override
        public State start(ActorImpl actor) {
            actor.mainThreadValidator.enterMainThread();
            try {
                actor.rpcEndpoint.internalCallOnStart();
            }
            catch (Throwable throwable) {
                actor.stop(RpcEndpointTerminationResult.failure((Throwable)new AkkaRpcException(String.format("Could not start RpcEndpoint %s.", actor.endpointName), throwable)));
            }
            finally {
                actor.mainThreadValidator.exitMainThread();
            }
            return StartedState.STARTED;
        }

        @Override
        public State stop() {
            return STOPPED;
        }

        @Override
        public State terminate(ActorImpl actor) {
            actor.stop(RpcEndpointTerminationResult.success());
            return TerminatingState.TERMINATING;
        }
    }

    static enum StartedState implements State
    {
        STARTED;


        @Override
        public State start(ActorImpl actor) {
            return STARTED;
        }

        @Override
        public State stop() {
            return StoppedState.STOPPED;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public State terminate(ActorImpl actor) {
            CompletableFuture terminationFuture;
            actor.mainThreadValidator.enterMainThread();
            try {
                terminationFuture = actor.rpcEndpoint.internalCallOnStop();
            }
            catch (Throwable t) {
                terminationFuture = FutureUtils.completedExceptionally((Throwable)new AkkaRpcException(String.format("Failure while stopping RpcEndpoint %s.", actor.endpointName), t));
            }
            finally {
                actor.mainThreadValidator.exitMainThread();
            }
            terminationFuture.whenComplete((ignored, throwable) -> actor.stop(RpcEndpointTerminationResult.of(throwable)));
            return TerminatingState.TERMINATING;
        }

        @Override
        public boolean isRunning() {
            return true;
        }
    }

    static interface State {
        default public State start(ActorImpl actor) {
            throw new AkkaRpcInvalidStateException(this.invalidStateTransitionMessage(StartedState.STARTED));
        }

        default public State stop() {
            throw new AkkaRpcInvalidStateException(this.invalidStateTransitionMessage(StoppedState.STOPPED));
        }

        default public State terminate(ActorImpl actor) {
            throw new AkkaRpcInvalidStateException(this.invalidStateTransitionMessage(TerminatingState.TERMINATING));
        }

        default public State finishTermination() {
            return TerminatedState.TERMINATED;
        }

        default public boolean isRunning() {
            return false;
        }

        default public String invalidStateTransitionMessage(State targetState) {
            return String.format("AkkaRpcActor is currently in state %s and cannot go into state %s.", this, targetState);
        }
    }
}

