/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algox.flink.enhance.krpc.impl;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import kd.bos.algox.flink.enhance.krpc.Actor;
import kd.bos.algox.flink.enhance.krpc.ActorRef;
import kd.bos.algox.flink.enhance.krpc.Dispatcher;
import kd.bos.algox.flink.enhance.krpc.KFencedAkkaRpcActor;
import kd.bos.algox.flink.enhance.krpc.KRpcActorMissException;
import kd.bos.algox.flink.enhance.krpc.KRpcException;
import kd.bos.algox.flink.enhance.krpc.KScheduledExecutor;
import kd.bos.algox.flink.enhance.krpc.MsgPlus;
import kd.bos.algox.flink.enhance.krpc.ThreadPoolSupplier;
import kd.bos.algox.flink.enhance.krpc.impl.ActorImpl;
import kd.bos.algox.flink.enhance.krpc.impl.DispatcherConfig;
import kd.bos.algox.flink.enhance.krpc.impl.HeartbeatMessage;
import kd.bos.algox.flink.enhance.krpc.impl.LocalActorRef;
import kd.bos.algox.flink.enhance.krpc.impl.PoisonPill;
import kd.bos.algox.flink.enhance.krpc.impl.ReleasableResource;
import kd.bos.algox.flink.enhance.krpc.impl.ReleasableResourceHolder;
import kd.bos.algox.flink.enhance.krpc.impl.RemoteActorRef;
import kd.bos.algox.flink.enhance.krpc.impl.VirtualActorImpl;
import kd.bos.algox.flink.enhance.krpc.impl.transport.Client;
import kd.bos.algox.flink.enhance.krpc.impl.transport.NettyTransport;
import kd.bos.algox.flink.enhance.krpc.impl.transport.Server;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.commons.lang3.RandomUtils;
import org.apache.flink.runtime.concurrent.ScheduledExecutor;
import org.apache.flink.runtime.rpc.FencedRpcEndpoint;
import org.apache.flink.runtime.rpc.RpcEndpoint;

public class DispatcherImpl
implements Dispatcher {
    public static final Log log = LogFactory.getLog(DispatcherImpl.class);
    private final ConcurrentHashMap<String, Actor> dispatcher = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, ActorRef> refs = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, ClientReference> clients = new ConcurrentHashMap();
    private final CompletableFuture<Void> shutdownFuture = new CompletableFuture();
    private final AtomicBoolean shutdownTag = new AtomicBoolean(false);
    private final Cache<String, String> endpointMatchCache;
    private final String identifier;
    private final ExecutorService executors;
    private final DispatcherConfig config;
    private Server server;
    private KScheduledExecutor scheduledExecutor;
    private final NioEventLoopGroup clientEventLoopGroup;
    private final ThreadPoolSupplier threadPoolSupplier;

    public DispatcherImpl(DispatcherConfig config, ThreadPoolSupplier threadPoolSupplier) {
        this.config = config;
        this.identifier = String.valueOf(RandomUtils.nextInt((int)1, (int)999));
        this.threadPoolSupplier = threadPoolSupplier;
        this.executors = threadPoolSupplier.getDispatcherExecutorService();
        this.clientEventLoopGroup = threadPoolSupplier.getClientEventLoopGroup();
        CacheBuilder cacheBuilder = CacheBuilder.newBuilder();
        cacheBuilder.expireAfterAccess(30L, TimeUnit.MINUTES);
        cacheBuilder.maximumSize(512L);
        this.endpointMatchCache = cacheBuilder.build();
    }

    public void setScheduledExecutor(KScheduledExecutor scheduledExecutor) {
        this.scheduledExecutor = scheduledExecutor;
    }

    private String tryMatchEndpoint(String patternStr) {
        Enumeration<String> keys = this.dispatcher.keys();
        while (keys.hasMoreElements()) {
            String str = keys.nextElement();
            Pattern pattern = Pattern.compile(patternStr);
            if (!pattern.matcher(str).find()) continue;
            return str;
        }
        return null;
    }

    @Override
    public void postMessage(MsgPlus msgPlus) {
        if (this.shutdownTag.get()) {
            log.warn("Dispatcher:{} has been shutdown, will discard message:{}", (Object)this.identifier, (Object)msgPlus);
            return;
        }
        Actor actor = this.dispatcher.get(msgPlus.getEndpoint());
        if (actor == null) {
            String endpoint = (String)this.endpointMatchCache.getIfPresent((Object)msgPlus.getEndpoint());
            if (endpoint == null) {
                endpoint = this.tryMatchEndpoint(msgPlus.getEndpoint());
                if (endpoint == null) {
                    msgPlus.responseException(new KRpcActorMissException("Dispatch error: {0} not match actor", msgPlus.getEndpoint()));
                    return;
                }
                this.endpointMatchCache.put((Object)msgPlus.getEndpoint(), (Object)endpoint);
            }
            actor = this.dispatcher.get(endpoint);
        }
        if (actor != null) {
            log.debug("Dispatch message: {} -> {}", (Object)msgPlus.getEndpoint(), (Object)actor.toString());
            actor.postMessage(msgPlus);
            if (!actor.isInProcess()) {
                this.executors.submit(actor::process);
            }
        } else {
            log.error("Dispatch error: {} not match actor", (Object)msgPlus.getEndpoint());
            msgPlus.responseException(new KRpcActorMissException("Dispatch error: {0} not match actor", msgPlus.getEndpoint()));
        }
    }

    @Override
    public void start() throws InterruptedException {
        NettyTransport transport = new NettyTransport();
        transport.setDispatcher(this);
        transport.setBossGroup((EventLoopGroup)this.threadPoolSupplier.getServerBossLoopGroup());
        transport.setWorkerGroup((EventLoopGroup)this.threadPoolSupplier.getServerWorkerLoopGroup());
        transport.setTcpNoDelay(this.config.isTcpNoDelay());
        transport.setMaxFrameSize(this.config.getMaxFrameSize());
        transport.setConnectTimeout(this.config.getConnectTimeout());
        this.server = transport.buildServer(this.config.getBindAddress(), this.config.getPort());
        this.server.start();
    }

    @Override
    public <T extends RpcEndpoint> Actor createActor(String endpointName, T rpcEndpoint) {
        return this.dispatcher.computeIfAbsent(endpointName, k -> {
            if (rpcEndpoint instanceof FencedRpcEndpoint) {
                return this.createFenceActor(endpointName, rpcEndpoint);
            }
            ActorImpl<RpcEndpoint> actor = new ActorImpl<RpcEndpoint>(endpointName, this, rpcEndpoint);
            actor.addReleasableResource(new ActorReleasableResource(this, endpointName));
            return actor;
        });
    }

    private <F extends Serializable, T extends FencedRpcEndpoint<F>> Actor createFenceActor(String endpointName, Object rpcEndpoint) {
        FencedRpcEndpoint endpoint = (FencedRpcEndpoint)rpcEndpoint;
        KFencedAkkaRpcActor actor = new KFencedAkkaRpcActor(endpointName, this, endpoint);
        actor.addReleasableResource(new ActorReleasableResource(this, endpointName));
        return actor;
    }

    public static boolean isLocalAddress(String address) {
        try {
            InetAddress inetAddress = InetAddress.getByName(address);
            if (inetAddress.isAnyLocalAddress() || inetAddress.isLoopbackAddress()) {
                return true;
            }
            return NetworkInterface.getByInetAddress(inetAddress) != null;
        }
        catch (SocketException | UnknownHostException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public ActorRef createActorRef(String endpoint, String host, int port) {
        String id = MessageFormat.format("ref://{0}:{1}:/{2}", host, port, endpoint);
        return this.refs.computeIfAbsent(id, k -> {
            ActorRef actorRef;
            if (DispatcherImpl.isLocalAddress(host) && this.getPort() == port) {
                actorRef = new LocalActorRef(endpoint, this);
            } else {
                String address = MessageFormat.format("{0}:{1}", host, port);
                ClientReference clientReference = this.clients.computeIfAbsent(address, a -> {
                    NettyTransport transport = new NettyTransport();
                    transport.setDispatcher(this);
                    transport.setTcpNoDelay(this.config.isTcpNoDelay());
                    transport.setMaxFrameSize(this.config.getMaxFrameSize());
                    transport.setConnectTimeout(this.config.getConnectTimeout());
                    Client c = transport.buildClient(host, port, this.clientEventLoopGroup);
                    try {
                        c.connect();
                        return new ClientReference((String)a, c, this);
                    }
                    catch (Exception e) {
                        throw new KRpcException(e, "Connect to endpoint:{0} on {1}:{2} fail, msg:{3}", endpoint, host, port, e.getMessage());
                    }
                });
                clientReference.addReference();
                actorRef = new RemoteActorRef(clientReference, endpoint, this);
            }
            VirtualActorImpl virtualActor = new VirtualActorImpl(actorRef.getClientEndpoint());
            this.dispatcher.put(actorRef.getClientEndpoint(), virtualActor);
            ActorReleasableResource actorRelease = new ActorReleasableResource(this, actorRef.getClientEndpoint());
            virtualActor.addReleasableResource(actorRelease);
            ActorRefReleasableResource actorRefRelease = new ActorRefReleasableResource(this, id, actorRef.getClientEndpoint());
            actorRef.addReleasableResource(actorRefRelease);
            this.getScheduledExecutor().schedule((Runnable)new ActorRefHeartbeat(actorRef, this.config.getActorRefCheckTimeoutMillis(), this), (long)this.config.getActorRefCheckTimeoutMillis(), TimeUnit.MILLISECONDS);
            return actorRef;
        });
    }

    @Override
    public ExecutorService getExecutorService() {
        return this.executors;
    }

    @Override
    public ScheduledExecutor getScheduledExecutor() {
        return this.scheduledExecutor;
    }

    @Override
    public CompletableFuture<Void> getShutdownFuture() {
        return this.shutdownFuture;
    }

    @Override
    public void shutdownAsync() {
        new Thread(() -> {
            if (!this.shutdownTag.compareAndSet(false, true)) {
                return;
            }
            try {
                if (this.server != null) {
                    this.server.shutdown();
                }
                this.dispatcher.clear();
                this.refs.clear();
                this.endpointMatchCache.invalidateAll();
                this.executors.shutdown();
                this.clientEventLoopGroup.shutdownGracefully();
            }
            finally {
                this.shutdownFuture.complete(null);
            }
        }, "DispatchShutdown-" + this.identifier).start();
    }

    @Override
    public int getPort() {
        return this.server.getPort();
    }

    public static class ClientReference
    implements AutoCloseable {
        private final AtomicInteger refCount = new AtomicInteger();
        private final ReleasableResourceHolder releasableResourceHolder = new ReleasableResourceHolder();
        private final Client client;

        public ClientReference(String key, Client client, DispatcherImpl dispatcher) {
            this.client = client;
            this.releasableResourceHolder.bind(() -> {
                ClientReference cfr_ignored_0 = (ClientReference)dispatcher.clients.remove(key);
            });
            this.releasableResourceHolder.bind(client::close);
        }

        public void addReference() {
            this.refCount.getAndIncrement();
        }

        public Client getClient() {
            return this.client;
        }

        @Override
        public void close() {
            if (this.refCount.decrementAndGet() == 0) {
                this.releasableResourceHolder.close();
            }
        }
    }

    public static class ActorRefHeartbeat
    implements Runnable {
        private final ActorRef actorRef;
        private final int delayMillis;
        private final DispatcherImpl dispatcher;

        public ActorRefHeartbeat(ActorRef actorRef, int delayMillis, DispatcherImpl dispatcher) {
            assert (delayMillis > 0);
            this.actorRef = actorRef;
            this.delayMillis = delayMillis;
            this.dispatcher = dispatcher;
        }

        @Override
        public void run() {
            long target = System.currentTimeMillis() - this.actorRef.getLastReadWriteTimestamp();
            if (target < 0L) {
                target = 0L;
            }
            if (target <= (long)this.delayMillis) {
                this.dispatcher.scheduledExecutor.schedule(new ActorRefHeartbeat(this.actorRef, this.delayMillis, this.dispatcher), (long)this.delayMillis - target, TimeUnit.MILLISECONDS);
            } else {
                CompletableFuture<Object> future = this.actorRef.ask(new HeartbeatMessage());
                future.whenComplete((r, t) -> {
                    if (t instanceof KRpcActorMissException) {
                        log.debug("ActorRef:{} has receive KRpcActorMissException,will close ActorRef", (Object)this.actorRef.getClientEndpoint());
                        this.actorRef.close();
                    } else {
                        this.dispatcher.scheduledExecutor.schedule(new ActorRefHeartbeat(this.actorRef, this.delayMillis, this.dispatcher), (long)this.delayMillis, TimeUnit.MILLISECONDS);
                    }
                });
            }
        }
    }

    public static class ActorReleasableResource
    implements ReleasableResource {
        private final DispatcherImpl dispatcher;
        private final String endpoint;

        public ActorReleasableResource(DispatcherImpl dispatcher, String endpoint) {
            this.dispatcher = dispatcher;
            this.endpoint = endpoint;
        }

        @Override
        public void close() {
            this.runIgnoredException(() -> {
                Actor cfr_ignored_0 = (Actor)this.dispatcher.dispatcher.remove(this.endpoint);
            });
        }
    }

    public static class ActorRefReleasableResource
    implements ReleasableResource {
        private final DispatcherImpl dispatcher;
        private final String refId;
        private final String virtualActorEndpoint;

        public ActorRefReleasableResource(DispatcherImpl dispatcher, String refId, String virtualActorEndpoint) {
            this.dispatcher = dispatcher;
            this.refId = refId;
            this.virtualActorEndpoint = virtualActorEndpoint;
        }

        @Override
        public void close() {
            this.runIgnoredException(() -> {
                ActorRef cfr_ignored_0 = (ActorRef)this.dispatcher.refs.remove(this.refId);
            });
            this.runIgnoredException(() -> this.dispatcher.postMessage(new PoisonPill(this.virtualActorEndpoint)));
        }
    }
}

