/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algox.flink.enhance.krpc.impl;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.algox.flink.enhance.krpc.Actor;
import kd.bos.algox.flink.enhance.krpc.MailBox;
import kd.bos.algox.flink.enhance.krpc.MsgPlus;
import kd.bos.algox.flink.enhance.krpc.impl.DispatcherImpl;

public class MailBoxImpl
implements MailBox {
    private final LinkedBlockingQueue<MsgPlus> box = new LinkedBlockingQueue();
    private final AtomicBoolean isRunning = new AtomicBoolean(false);
    private final Actor actor;

    public MailBoxImpl(Actor actor) {
        this.actor = actor;
    }

    @Override
    public boolean isInProcess() {
        return this.isRunning.get();
    }

    @Override
    public void postMessage(MsgPlus message) {
        this.box.offer(message);
    }

    @Override
    public void process() {
        if (this.isRunning.compareAndSet(false, true)) {
            try {
                MsgPlus message = this.box.poll();
                while (message != null) {
                    try {
                        this.actor.handleMsgPlus(message);
                    }
                    catch (Exception exception) {
                        DispatcherImpl.log.error("Uncheck exception: " + exception.getMessage(), (Throwable)exception);
                        message.responseException(exception);
                    }
                    message = this.box.poll();
                }
            }
            finally {
                this.isRunning.compareAndSet(true, false);
            }
        }
    }

    @Override
    public void shutdown() {
    }
}

