/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algox.flink.enhance.krpc.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.algox.flink.enhance.krpc.impl.ReleasableResource;

public class ReleasableResourceHolder
implements ReleasableResource {
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final List<AutoCloseable> resources = new ArrayList<AutoCloseable>();
    private final CompletableFuture<Void> closeFuture;

    public ReleasableResourceHolder(CompletableFuture<Void> closeFuture) {
        this.closeFuture = closeFuture;
    }

    public ReleasableResourceHolder() {
        this(new CompletableFuture<Void>());
    }

    public CompletableFuture<Void> getCloseFuture() {
        return this.closeFuture;
    }

    public void bind(AutoCloseable closeable) {
        this.resources.add(closeable);
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            for (AutoCloseable resource : this.resources) {
                this.closeIgnoreException(resource);
            }
            this.closeFuture.complete(null);
        }
    }
}

