/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algox.flink.enhance.krpc.impl;

import java.text.MessageFormat;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import kd.bos.algox.flink.enhance.krpc.ActorRef;
import kd.bos.algox.flink.enhance.krpc.Dispatcher;
import kd.bos.algox.flink.enhance.krpc.impl.DispatcherImpl;
import kd.bos.algox.flink.enhance.krpc.impl.ReleasableResource;
import kd.bos.algox.flink.enhance.krpc.impl.ReleasableResourceHolder;
import kd.bos.algox.flink.enhance.krpc.impl.RemoteMsg;
import kd.bos.algox.flink.enhance.krpc.impl.ResponseMsgPlus;
import kd.bos.algox.flink.enhance.krpc.impl.transport.Client;

public class RemoteActorRef
implements ActorRef {
    private final ReleasableResourceHolder resourceHolder = new ReleasableResourceHolder();
    private final DispatcherImpl.ClientReference clientReference;
    private final String endpoint;
    private final String clientEndpoint;
    private final Dispatcher dispatcher;
    private volatile long lastReadWriteTimestamp = System.currentTimeMillis();

    public RemoteActorRef(DispatcherImpl.ClientReference clientReference, String endpoint, Dispatcher dispatcher) {
        this.clientReference = clientReference;
        this.endpoint = endpoint;
        this.clientEndpoint = MessageFormat.format("remote-client-{0}", UUID.randomUUID().toString().replaceAll("-", ""));
        this.dispatcher = dispatcher;
        this.resourceHolder.bind(new ClientReferenceReleasableResource(this));
    }

    @Override
    public String getClientEndpoint() {
        return this.clientEndpoint;
    }

    public String getServerEndpoint() {
        return this.endpoint;
    }

    @Override
    public void tell(Object message) {
        RemoteMsg remoteMsg = new RemoteMsg(this.endpoint, message);
        this.clientReference.getClient().tell(remoteMsg);
        this.updateLastReadWriteTimestamp();
    }

    @Override
    public CompletableFuture<Object> ask(Object message) {
        final CompletableFuture<Object> completableFuture = new CompletableFuture<Object>();
        RemoteMsg remoteMsg = new RemoteMsg(this.endpoint, message);
        this.clientReference.getClient().ask(remoteMsg, new Client.Call(){

            @Override
            public void onSuccess(Object result) {
                ResponseMsgPlus responseMsgPlus = ResponseMsgPlus.success(RemoteActorRef.this.clientEndpoint, completableFuture, result);
                RemoteActorRef.this.dispatcher.postMessage(responseMsgPlus);
            }

            @Override
            public void onFail(Throwable throwable) {
                ResponseMsgPlus responseMsgPlus = ResponseMsgPlus.fail(RemoteActorRef.this.clientEndpoint, completableFuture, throwable);
                RemoteActorRef.this.dispatcher.postMessage(responseMsgPlus);
            }
        });
        this.updateLastReadWriteTimestamp();
        return completableFuture;
    }

    private void updateLastReadWriteTimestamp() {
        this.lastReadWriteTimestamp = System.currentTimeMillis();
    }

    @Override
    public boolean isLocal() {
        return false;
    }

    @Override
    public void addReleasableResource(AutoCloseable closeable) {
        this.resourceHolder.bind(closeable);
    }

    @Override
    public void close() {
        this.resourceHolder.close();
    }

    @Override
    public long getLastReadWriteTimestamp() {
        return this.lastReadWriteTimestamp;
    }

    public static class ClientReferenceReleasableResource
    implements ReleasableResource {
        private final RemoteActorRef actorRef;

        public ClientReferenceReleasableResource(RemoteActorRef actorRef) {
            this.actorRef = actorRef;
        }

        @Override
        public void close() {
            this.runIgnoredException(this.actorRef.clientReference::close);
        }
    }
}

