/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algox.flink.enhance.krpc.impl.transport;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.handler.codec.LengthFieldPrepender;
import io.netty.handler.codec.MessageToByteEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.text.MessageFormat;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.algox.flink.enhance.krpc.Dispatcher;
import kd.bos.algox.flink.enhance.krpc.impl.DispatcherImpl;
import kd.bos.algox.flink.enhance.krpc.impl.RemoteMsg;
import kd.bos.algox.flink.enhance.krpc.impl.RemoteMsgPlus;
import kd.bos.algox.flink.enhance.krpc.impl.transport.Client;
import kd.bos.algox.flink.enhance.krpc.impl.transport.Compress;
import kd.bos.algox.flink.enhance.krpc.impl.transport.RequestPacket;
import kd.bos.algox.flink.enhance.krpc.impl.transport.ResponsePacket;
import kd.bos.algox.flink.enhance.krpc.impl.transport.Serialize;
import kd.bos.algox.flink.enhance.krpc.impl.transport.Server;
import kd.bos.algox.flink.enhance.krpc.impl.transport.ServerSender;
import kd.bos.algox.flink.enhance.krpc.impl.transport.Utils;
import kd.bos.algox.flink.enhance.krpc.impl.transport.netty4.ByteBufAllocatorFactory;
import kd.bos.algox.flink.enhance.krpc.impl.transport.netty4.NioServerSocketChannelEnhance;
import kd.bos.algox.flink.enhance.krpc.impl.transport.netty4.NioSocketChannelEnhance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.jetbrains.annotations.NotNull;

public class NettyTransport {
    private static final Log log = LogFactory.getLog((String)"NettyTransport");
    private Compress compress;
    private Serialize serialize;
    private Dispatcher dispatcher;
    private boolean tcpNoDelay;
    private int connectTimeout = 5000;
    private long maxFrameSize = Integer.MAX_VALUE;
    private EventLoopGroup bossGroup;
    private EventLoopGroup workerGroup;

    public NettyTransport() {
        this.serialize = Utils.newHessianSerialize();
        this.bossGroup = new NioEventLoopGroup(1);
        this.workerGroup = new NioEventLoopGroup(2);
    }

    public void setMaxFrameSize(long maxFrameSize) {
    }

    public void setBossGroup(EventLoopGroup bossGroup) {
        this.bossGroup = bossGroup;
    }

    public void setWorkerGroup(EventLoopGroup workerGroup) {
        this.workerGroup = workerGroup;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void setCompress(Compress compress) {
        this.compress = compress;
    }

    public void setSerialize(Serialize serialize) {
        this.serialize = serialize;
    }

    public void setDispatcher(Dispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    public void setTcpNoDelay(boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
    }

    public Client buildClient(String host, int port, NioEventLoopGroup eventLoopGroup) {
        NettyClient client = new NettyClient(host, port, eventLoopGroup);
        client.setCompress(this.compress);
        client.setSerialize(this.serialize);
        client.setConnectTimeout(this.connectTimeout);
        client.setMaxFrameLength(this.maxFrameSize);
        client.setTcpNoDelay(this.tcpNoDelay);
        return client;
    }

    public Server buildServer(String bindAddress, int port) {
        NettyServer server = new NettyServer(bindAddress, port);
        server.setBossGroup(this.bossGroup);
        server.setWorkerGroup(this.workerGroup);
        server.setCompress(this.compress);
        server.setSerialize(this.serialize);
        server.setDispatcher(this.dispatcher);
        server.setMaxFrameLength(this.maxFrameSize);
        server.setTcpNoDelay(this.tcpNoDelay);
        return server;
    }

    private static class IgnoredCall
    implements Client.Call {
        public static final IgnoredCall instance = new IgnoredCall();

        private IgnoredCall() {
        }

        @Override
        public void onSuccess(Object result) {
        }

        @Override
        public void onFail(Throwable throwable) {
        }
    }

    public static class NettyClient
    implements Client {
        private final AtomicBoolean connected = new AtomicBoolean(false);
        private final ConcurrentHashMap<String, Client.Call> waitList = new ConcurrentHashMap();
        private final String host;
        private final int port;
        private final NioEventLoopGroup workerGroup;
        private Compress compress;
        private Serialize serialize;
        private long maxFrameLength = Integer.MAX_VALUE;
        private int connectTimeout;
        private boolean tcpNoDelay = true;
        private Channel channel;

        public NettyClient(String host, int port, NioEventLoopGroup workerGroup) {
            this.host = host;
            this.port = port;
            this.workerGroup = workerGroup;
        }

        public void setTcpNoDelay(boolean tcpNoDelay) {
            this.tcpNoDelay = tcpNoDelay;
        }

        public void setConnectTimeout(int connectTimeout) {
            this.connectTimeout = connectTimeout;
        }

        public void setCompress(Compress compress) {
            this.compress = compress;
        }

        public void setSerialize(Serialize serialize) {
            this.serialize = serialize;
        }

        public void setMaxFrameLength(long maxFrameLength) {
            this.maxFrameLength = maxFrameLength;
        }

        @Override
        public void connect() throws InterruptedException {
            if (this.connected.compareAndSet(false, true)) {
                Objects.requireNonNull(this.workerGroup);
                Objects.requireNonNull(this.serialize);
                this.doConnect();
            }
        }

        private void doConnect() throws InterruptedException {
            Bootstrap b = new Bootstrap();
            b.group((EventLoopGroup)this.workerGroup);
            b.channel(NioSocketChannelEnhance.class);
            ((Bootstrap)((Bootstrap)((Bootstrap)b.option(ChannelOption.SO_KEEPALIVE, (Object)true)).option(ChannelOption.TCP_NODELAY, (Object)this.tcpNoDelay)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)this.connectTimeout)).option(ChannelOption.ALLOCATOR, (Object)ByteBufAllocatorFactory.INSTANCE);
            b.handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                public void initChannel(SocketChannel ch) throws Exception {
                    ch.pipeline().addLast(new ChannelHandler[]{new LengthFieldBasedFrameDecoder((int)maxFrameLength, 0, 4, 0, 4)}).addLast(new ChannelHandler[]{new LengthFieldPrepender(4)}).addLast(new ChannelHandler[]{new PacketDecoder(compress, serialize)}).addLast(new ChannelHandler[]{new PacketEncoder(compress, serialize)}).addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                            if (!(msg instanceof ResponsePacket)) {
                                log.error("NettyClient receive unknown packet: " + msg);
                                return;
                            }
                            ResponsePacket responsePacket = (ResponsePacket)msg;
                            Client.Call call = (Client.Call)waitList.get(responsePacket.getId());
                            if (call == null) {
                                DispatcherImpl.log.error("Receive unknown package: " + responsePacket.getId());
                                return;
                            }
                            try {
                                if (responsePacket.isOk()) {
                                    call.onSuccess(responsePacket.getResponse());
                                } else {
                                    call.onFail(responsePacket.getError());
                                }
                            }
                            finally {
                                waitList.remove(responsePacket.getId());
                            }
                        }
                    }});
                }
            });
            this.channel = b.connect(this.host, this.port).sync().channel();
            log.info("KRPC NettyClient connect success, desc: " + this.toString());
        }

        @Override
        public void tell(RemoteMsg param) {
            this.ask(param, IgnoredCall.instance);
        }

        @Override
        public void ask(RemoteMsg param, Client.Call call) {
            RequestPacket request = RequestPacket.newRequest(param);
            this.waitList.put(request.getId(), call);
            this.channel.writeAndFlush((Object)request);
        }

        @Override
        public void close() {
            this.channel.close();
        }

        public String toString() {
            return MessageFormat.format("NettyClient({0}:{1}):status={2},compress={3},serialize={4}", this.host, this.port, this.connected.get() ? "connected" : "not_connect", this.compress == null ? "null" : this.compress.getName(), this.serialize == null ? "null" : this.serialize.getName());
        }
    }

    public static class NettyServer
    implements Server {
        private final AtomicBoolean started = new AtomicBoolean(false);
        private final String bindAddress;
        private final int port;
        private int bindPort = -1;
        private Compress compress;
        private Serialize serialize;
        private long maxFrameLength = 0x6400000L;
        private Dispatcher dispatcher;
        private boolean tcpNoDelay = true;
        private Channel serverChannel;
        private EventLoopGroup bossGroup;
        private EventLoopGroup workerGroup;

        public NettyServer(String bindAddress, int port) {
            this.bindAddress = bindAddress;
            this.port = port;
        }

        public void setTcpNoDelay(boolean tcpNoDelay) {
            this.tcpNoDelay = tcpNoDelay;
        }

        public void setDispatcher(Dispatcher dispatcher) {
            this.dispatcher = dispatcher;
        }

        public void setCompress(Compress compress) {
            this.compress = compress;
        }

        public void setSerialize(Serialize serialize) {
            this.serialize = serialize;
        }

        public void setBossGroup(EventLoopGroup bossGroup) {
            this.bossGroup = bossGroup;
        }

        public void setWorkerGroup(EventLoopGroup workerGroup) {
            this.workerGroup = workerGroup;
        }

        public void setMaxFrameLength(long maxFrameLength) {
            this.maxFrameLength = maxFrameLength;
        }

        @Override
        public void start() throws InterruptedException {
            if (this.started.compareAndSet(false, true)) {
                Objects.requireNonNull(this.serialize);
                this.doStart();
            }
        }

        private void doStart() throws InterruptedException {
            ServerBootstrap b = new ServerBootstrap();
            ((ServerBootstrap)((ServerBootstrap)b.group(this.bossGroup, this.workerGroup).channel(NioServerSocketChannelEnhance.class)).childOption(ChannelOption.TCP_NODELAY, (Object)this.tcpNoDelay).childOption(ChannelOption.SO_REUSEADDR, (Object)Boolean.TRUE).childOption(ChannelOption.ALLOCATOR, (Object)ByteBufAllocatorFactory.INSTANCE).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                public void initChannel(SocketChannel ch) throws Exception {
                    ch.pipeline().addLast(new ChannelHandler[]{new LengthFieldBasedFrameDecoder((int)maxFrameLength, 0, 4, 0, 4)}).addLast(new ChannelHandler[]{new LengthFieldPrepender(4)}).addLast(new ChannelHandler[]{new PacketDecoder(compress, serialize)}).addLast(new ChannelHandler[]{new PacketEncoder(compress, serialize)}).addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                            if (!(msg instanceof RequestPacket)) {
                                log.error("NettyServer receive unknown packet: " + msg);
                                return;
                            }
                            RequestPacket packet = (RequestPacket)msg;
                            NettyServerSender sender = new NettyServerSender(ctx.channel());
                            dispatcher.postMessage(new RemoteMsgPlus(packet.getId(), packet.getRequestData(), sender));
                        }
                    }});
                }
            }).option(ChannelOption.SO_BACKLOG, (Object)128)).childOption(ChannelOption.SO_KEEPALIVE, (Object)true);
            this.bindPort = this.port;
            ChannelFuture f = b.bind(this.bindAddress, this.bindPort).sync();
            this.serverChannel = f.channel();
            this.bindPort = ((InetSocketAddress)this.serverChannel.localAddress()).getPort();
            log.info("KRPC NettyServer start success, desc: " + this.toString());
        }

        @Override
        public void shutdown() {
            this.serverChannel.close();
            this.bossGroup.shutdownGracefully();
            this.workerGroup.shutdownGracefully();
        }

        @Override
        public int getPort() {
            return this.bindPort;
        }

        public String toString() {
            return MessageFormat.format("NettyServer({0}:{1}):status={2},compress={3},serialize={4}", this.bindAddress, this.bindPort, this.started.get() ? "started" : "not_start", this.compress == null ? "null" : this.compress.getName(), this.serialize == null ? "null" : this.serialize.getName());
        }
    }

    public static class NettyThreadFactory
    implements ThreadFactory {
        private final String name;
        private final AtomicInteger count = new AtomicInteger();

        public NettyThreadFactory(String name) {
            this.name = name;
        }

        @Override
        public Thread newThread(@NotNull Runnable r) {
            Thread thread = new Thread(r);
            thread.setName(MessageFormat.format("{0}-{1}", this.name, this.count.getAndIncrement()));
            return thread;
        }
    }

    public static class NettyServerSender
    implements ServerSender {
        private final Channel channel;

        public NettyServerSender(Channel channel) {
            this.channel = channel;
        }

        @Override
        public void send(String id, Object result) {
            this.channel.writeAndFlush((Object)ResponsePacket.success(id, result));
        }

        @Override
        public void sendFail(String id, Throwable throwable) {
            this.channel.writeAndFlush((Object)ResponsePacket.fail(id, throwable));
        }
    }

    public static class PacketEncoder
    extends MessageToByteEncoder<Object> {
        private final Serialize serialize;

        public PacketEncoder(Compress compress, Serialize serialize) {
            super(false);
            this.serialize = serialize;
        }

        protected void encode(ChannelHandlerContext channelHandlerContext, Object o, ByteBuf byteBuf) throws Exception {
            ByteBufOutputStream outputStream = new ByteBufOutputStream(byteBuf);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream((OutputStream)outputStream, 65536);
            this.serialize.serialize(o, bufferedOutputStream);
        }
    }

    public static class PacketDecoder
    extends ByteToMessageDecoder {
        private final Compress compress;
        private final Serialize serialize;

        public PacketDecoder(Compress compress, Serialize serialize) {
            this.compress = compress;
            this.serialize = serialize;
        }

        protected void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) throws Exception {
            ByteBufInputStream inputStream = new ByteBufInputStream(byteBuf);
            BufferedInputStream bufferedInputStream = new BufferedInputStream((InputStream)inputStream, 65536);
            list.add(this.serialize.deserialize(bufferedInputStream));
        }
    }
}

