/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algox.flink.enhance.krpc.impl.transport;

import com.caucho.hessian.io.AbstractSerializerFactory;
import com.caucho.hessian.io.CollectionDeserializer;
import com.caucho.hessian.io.Deserializer;
import com.caucho.hessian.io.HessianInput;
import com.caucho.hessian.io.HessianOutput;
import com.caucho.hessian.io.HessianProtocolException;
import com.caucho.hessian.io.Serializer;
import com.caucho.hessian.io.SerializerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import kd.bos.algox.flink.enhance.krpc.impl.transport.Serialize;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public final class Utils {
    private static final Log log = LogFactory.getLog((String)"NettyTransport");
    private static final HessianSerialize hessianSerialize;

    private Utils() {
    }

    public static HessianSerialize newHessianSerialize() {
        return hessianSerialize;
    }

    static {
        SerializerFactory factory = new SerializerFactory();
        factory.addFactory((AbstractSerializerFactory)new KRPCSerializerFactory());
        hessianSerialize = new HessianSerialize(factory);
    }

    public static class KRPCSerializerFactory
    extends AbstractSerializerFactory {
        public Serializer getSerializer(Class cl) throws HessianProtocolException {
            return null;
        }

        public Deserializer getDeserializer(Class cl) throws HessianProtocolException {
            if (cl.equals(Iterable.class)) {
                return new CollectionDeserializer(List.class);
            }
            return null;
        }
    }

    public static class HessianSerialize
    implements Serialize {
        private final SerializerFactory serializerFactory;

        public HessianSerialize(SerializerFactory serializerFactory) {
            this.serializerFactory = serializerFactory;
        }

        @Override
        public String getName() {
            return "hessian";
        }

        @Override
        public void serialize(Object object, OutputStream outputStream) throws IOException {
            try {
                HessianOutput output = new HessianOutput(outputStream);
                output.setSerializerFactory(this.serializerFactory);
                output.writeObject(object);
                output.close();
                outputStream.close();
            }
            catch (IOException ioException) {
                log.error("Serialize object fail, msg: " + ioException.getMessage(), (Throwable)ioException);
                throw ioException;
            }
        }

        @Override
        public Object deserialize(InputStream inputStream) throws IOException {
            HessianInput input = new HessianInput(inputStream);
            input.setSerializerFactory(this.serializerFactory);
            Object object = input.readObject();
            inputStream.close();
            input.close();
            return object;
        }
    }
}

