/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algox.flink.runtime.highavailability.redis.store;

import java.util.concurrent.Executor;
import kd.bos.algox.flink.runtime.highavailability.redis.configuration.RedisHighAvailabilityOptions;
import kd.bos.algox.flink.runtime.highavailability.redis.store.RedisCheckpointStoreUtil;
import kd.bos.algox.flink.runtime.highavailability.redis.store.RedisStateHandleStore;
import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.HighAvailabilityOptions;
import org.apache.flink.runtime.checkpoint.CheckpointIDCounter;
import org.apache.flink.runtime.checkpoint.CheckpointRecoveryFactory;
import org.apache.flink.runtime.checkpoint.CheckpointStoreUtil;
import org.apache.flink.runtime.checkpoint.CompletedCheckpointStore;
import org.apache.flink.runtime.checkpoint.DefaultCompletedCheckpointStore;
import org.apache.flink.runtime.highavailability.HighAvailabilityServicesUtils;
import org.apache.flink.runtime.persistence.filesystem.FileSystemStateStorageHelper;
import org.apache.flink.util.Preconditions;

public class RedisCheckPointRecoveryFactory
implements CheckpointRecoveryFactory {
    private final Configuration configuration;
    private final Executor executor;

    public RedisCheckPointRecoveryFactory(Configuration configuration, Executor ioExecutor) {
        this.configuration = configuration;
        this.executor = ioExecutor;
    }

    public CompletedCheckpointStore createCheckpointStore(JobID jobID, int i, ClassLoader classLoader) throws Exception {
        return this.createCompletedCheckPointStore(this.configuration, jobID, i, this.executor);
    }

    private CompletedCheckpointStore createCompletedCheckPointStore(Configuration configuration, JobID jobID, int maxNum, Executor executor) throws Exception {
        Preconditions.checkNotNull((Object)configuration, (String)"Configuration");
        String clusterId = configuration.getString((ConfigOption<String>)HighAvailabilityOptions.HA_CLUSTER_ID);
        String checkPointsPath = configuration.getString(RedisHighAvailabilityOptions.HA_REDIS_CHECKPOINTS_PATH);
        checkPointsPath = checkPointsPath + String.format("/%s", jobID);
        FileSystemStateStorageHelper stateStorage = new FileSystemStateStorageHelper(HighAvailabilityServicesUtils.getClusterHighAvailableStoragePath((Configuration)configuration), checkPointsPath);
        RedisStateHandleStore redisStateHandleStore = new RedisStateHandleStore(configuration, stateStorage, String.format("flink.%s.%s", clusterId, checkPointsPath));
        return new DefaultCompletedCheckpointStore(maxNum, redisStateHandleStore, (CheckpointStoreUtil)RedisCheckpointStoreUtil.INSTANCE, executor);
    }

    public CheckpointIDCounter createCheckpointIDCounter(JobID jobID) throws Exception {
        return null;
    }
}

