/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algox.flink.type;

import kd.bos.algo.AlgoException;
import kd.bos.algo.DataType;
import kd.bos.algo.RowMeta;
import kd.bos.algox.flink.type.FixBasicTypeInfo;
import kd.bos.algox.flink.type.NullTypeInfo;
import kd.bos.algox.flink.type.RowXTypeInfo;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;

public class TypeUtil {
    public static BasicTypeInfo<?> toBasicType(DataType dataType) {
        return TypeUtil.toBasicType(dataType, null);
    }

    public static BasicTypeInfo<?> toBasicType(DataType dataType, String fieldName) {
        switch (dataType.ordinal) {
            case 0: {
                return BasicTypeInfo.BOOLEAN_TYPE_INFO;
            }
            case 1: {
                return BasicTypeInfo.STRING_TYPE_INFO;
            }
            case 2: {
                return BasicTypeInfo.INT_TYPE_INFO;
            }
            case 3: {
                return BasicTypeInfo.LONG_TYPE_INFO;
            }
            case 4: {
                return BasicTypeInfo.DOUBLE_TYPE_INFO;
            }
            case 5: {
                return FixBasicTypeInfo.BIG_DEC_TYPE_INFO;
            }
            case 6: {
                return BasicTypeInfo.DATE_TYPE_INFO;
            }
            case 7: {
                return BasicTypeInfo.DATE_TYPE_INFO;
            }
            case 8: {
                return NullTypeInfo.INSTANCE;
            }
        }
        if (fieldName != null) {
            throw new AlgoException("Not support dataType " + dataType.getName() + " of " + fieldName);
        }
        throw new AlgoException("Not support dataType " + dataType.getName());
    }

    public static RowXTypeInfo toRowXType(RowMeta rowMeta) {
        BasicTypeInfo[] types = new BasicTypeInfo[rowMeta.getFieldCount()];
        String[] fieldNames = new String[rowMeta.getFieldCount()];
        for (int i = 0; i < types.length; ++i) {
            fieldNames[i] = rowMeta.getFieldAlias(i);
            types[i] = TypeUtil.toBasicType(rowMeta.getFieldDataType(i), fieldNames[i]);
        }
        return new RowXTypeInfo((TypeInformation<?>[])types, fieldNames);
    }

    public static RowXTypeInfo toRowXType(DataType[] dataTypes) {
        BasicTypeInfo[] types = new BasicTypeInfo[dataTypes.length];
        for (int i = 0; i < types.length; ++i) {
            types[i] = TypeUtil.toBasicType(dataTypes[i], null);
        }
        return new RowXTypeInfo((TypeInformation<?>[])types);
    }
}

