/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algox.flink.utils;

import java.io.Serializable;
import java.util.Iterator;
import kd.bos.algo.CustomizedInput;
import kd.bos.algo.DataType;
import kd.bos.algo.Input;
import kd.bos.algo.Output;
import kd.bos.algo.RowMeta;
import kd.bos.algo.output.PrintOutput;
import kd.bos.algox.AlgoX;
import kd.bos.algox.DataSetX;
import kd.bos.algox.JobSession;
import kd.bos.algox.core.JobContext;
import kd.bos.algox.flink.core.FakeEnvironment;
import kd.bos.algox.flink.core.translate.Translate;
import kd.bos.algox.flink.utils.ObjectSerde;
import kd.bos.context.RequestContext;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.optimizer.DataStatistics;
import org.apache.flink.optimizer.Optimizer;
import org.apache.flink.optimizer.costs.CostEstimator;
import org.apache.flink.optimizer.costs.DefaultCostEstimator;
import org.apache.flink.optimizer.plan.OptimizedPlan;
import org.apache.flink.optimizer.plantranslate.JobGraphGenerator;
import org.apache.flink.runtime.jobgraph.JobGraph;

public final class AlgoXUtils
implements Serializable {
    private AlgoXUtils() {
    }

    public static JobGraph newJobGraph4AlgoXFailOver(String jobName, JobID jobId) {
        JobSession jobSession = AlgoX.createSession((String)jobName);
        DataSetX dataSetX = jobSession.fromInput((Input)new JobGraphAlgoXFailOverInput());
        dataSetX.output((Output)new PrintOutput());
        JobGraph jobGraph = AlgoXUtils.translate(jobSession.getContext());
        jobGraph.setJobID(jobId);
        return jobGraph;
    }

    private static JobGraph translate(JobContext context) {
        Optimizer optimizer = new Optimizer(new DataStatistics(), (CostEstimator)new DefaultCostEstimator(), new Configuration());
        FakeEnvironment env = new FakeEnvironment(optimizer);
        env.setParallelism(context.getParallelism());
        Translate translate = new Translate(context);
        translate.translate((ExecutionEnvironment)env, context.getDataSinks());
        OptimizedPlan plan = env.getOptimizedPlan(context.getJobName());
        JobGraphGenerator jobGraphGenerator = new JobGraphGenerator();
        JobGraph jobGraph = jobGraphGenerator.compileJobGraph(plan);
        RequestContext rc = RequestContext.get();
        if (rc != null) {
            rc = RequestContext.copy((RequestContext)rc);
            byte[] bytes = ObjectSerde.toBytes(rc);
            jobGraph.getJobConfiguration().setBytes("requestContext", bytes);
        }
        return jobGraph;
    }

    public static class JobGraphAlgoXFailOverInput
    implements CustomizedInput {
        public Iterator<Object[]> createIterator() {
            throw new RuntimeException("Service AlgoX has undergone a failover. Please resubmit the job.");
        }

        public void close() {
        }

        public RowMeta getRowMeta() {
            return new RowMeta(new String[]{"id"}, new DataType[]{DataType.IntegerType});
        }
    }
}

