/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.memory;

import java.nio.ByteBuffer;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public final class MemorySegmentFactory {
    private static final Logger LOG = LoggerFactory.getLogger(MemorySegmentFactory.class);
    private static final Runnable NO_OP = () -> {};

    public static MemorySegment wrap(byte[] buffer) {
        return new MemorySegment(buffer, null);
    }

    public static MemorySegment wrapCopy(byte[] bytes, int start, int end) throws IllegalArgumentException {
        Preconditions.checkArgument((end >= start ? 1 : 0) != 0);
        Preconditions.checkArgument((end <= bytes.length ? 1 : 0) != 0);
        MemorySegment copy = MemorySegmentFactory.allocateUnpooledSegment(end - start);
        copy.put(0, bytes, start, copy.size());
        return copy;
    }

    public static MemorySegment wrapInt(int value) {
        return MemorySegmentFactory.wrap(ByteBuffer.allocate(4).putInt(value).array());
    }

    public static MemorySegment allocateUnpooledSegment(int size) {
        return MemorySegmentFactory.allocateUnpooledSegment(size, null);
    }

    public static MemorySegment allocateUnpooledSegment(int size, Object owner) {
        return new MemorySegment(new byte[size], owner);
    }

    public static MemorySegment allocateUnpooledOffHeapMemory(int size) {
        return MemorySegmentFactory.allocateUnpooledOffHeapMemory(size, null);
    }

    public static MemorySegment allocateUnpooledOffHeapMemory(int size, Object owner) {
        return new MemorySegment(new byte[size], owner);
    }

    @VisibleForTesting
    public static MemorySegment allocateOffHeapUnsafeMemory(int size) {
        return MemorySegmentFactory.allocateOffHeapUnsafeMemory(size, null, NO_OP);
    }

    public static MemorySegment allocateOffHeapUnsafeMemory(int size, Object owner, Runnable customCleanupAction) {
        return new MemorySegment(new byte[size], owner);
    }

    public static MemorySegment wrapOffHeapMemory(ByteBuffer memory) {
        return new MemorySegment(memory, null);
    }
}

