/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.entrypoint;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.ClusterOptions;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ConfigurationUtils;
import org.apache.flink.configuration.GlobalConfiguration;
import org.apache.flink.configuration.HighAvailabilityOptions;
import org.apache.flink.configuration.IllegalConfigurationException;
import org.apache.flink.configuration.JMXServerOptions;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.configuration.RestOptions;
import org.apache.flink.configuration.SchedulerExecutionMode;
import org.apache.flink.configuration.WebOptions;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.plugin.PluginManager;
import org.apache.flink.core.plugin.PluginUtils;
import org.apache.flink.runtime.blob.BlobServer;
import org.apache.flink.runtime.clusterframework.ApplicationStatus;
import org.apache.flink.runtime.concurrent.FutureUtils;
import org.apache.flink.runtime.concurrent.ScheduledExecutor;
import org.apache.flink.runtime.dispatcher.ExecutionGraphInfoStore;
import org.apache.flink.runtime.entrypoint.ClusterEntryPointExceptionUtils;
import org.apache.flink.runtime.entrypoint.ClusterEntrypointException;
import org.apache.flink.runtime.entrypoint.ClusterEntrypointUtils;
import org.apache.flink.runtime.entrypoint.EntrypointClusterConfiguration;
import org.apache.flink.runtime.entrypoint.EntrypointClusterConfigurationParserFactory;
import org.apache.flink.runtime.entrypoint.FlinkParseException;
import org.apache.flink.runtime.entrypoint.component.DispatcherResourceManagerComponent;
import org.apache.flink.runtime.entrypoint.component.DispatcherResourceManagerComponentFactory;
import org.apache.flink.runtime.entrypoint.parser.CommandLineParser;
import org.apache.flink.runtime.entrypoint.parser.ParserResultFactory;
import org.apache.flink.runtime.heartbeat.HeartbeatServices;
import org.apache.flink.runtime.highavailability.HighAvailabilityServices;
import org.apache.flink.runtime.highavailability.HighAvailabilityServicesUtils;
import org.apache.flink.runtime.management.JMXService;
import org.apache.flink.runtime.metrics.MetricRegistry;
import org.apache.flink.runtime.metrics.MetricRegistryConfiguration;
import org.apache.flink.runtime.metrics.MetricRegistryImpl;
import org.apache.flink.runtime.metrics.ReporterSetup;
import org.apache.flink.runtime.metrics.groups.ProcessMetricGroup;
import org.apache.flink.runtime.metrics.util.MetricUtils;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.runtime.rpc.RpcUtils;
import org.apache.flink.runtime.rpc.akka.AkkaRpcServiceUtils;
import org.apache.flink.runtime.security.FlinkSecurityManager;
import org.apache.flink.runtime.security.SecurityConfiguration;
import org.apache.flink.runtime.security.SecurityUtils;
import org.apache.flink.runtime.security.contexts.SecurityContext;
import org.apache.flink.runtime.util.ExecutorThreadFactory;
import org.apache.flink.runtime.util.ZooKeeperUtils;
import org.apache.flink.runtime.webmonitor.retriever.MetricQueryServiceRetriever;
import org.apache.flink.runtime.webmonitor.retriever.impl.RpcMetricQueryServiceRetriever;
import org.apache.flink.util.AutoCloseableAsync;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.ExecutorUtils;
import org.apache.flink.util.FileUtils;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.ShutdownHookUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ClusterEntrypoint
implements AutoCloseableAsync,
FatalErrorHandler {
    public static final ConfigOption<String> INTERNAL_CLUSTER_EXECUTION_MODE = ConfigOptions.key((String)"internal.cluster.execution-mode").defaultValue((Object)ExecutionMode.NORMAL.toString());
    protected static final Logger LOG = LoggerFactory.getLogger(ClusterEntrypoint.class);
    protected static final int STARTUP_FAILURE_RETURN_CODE = 1;
    protected static final int RUNTIME_FAILURE_RETURN_CODE = 2;
    private static final Time INITIALIZATION_SHUTDOWN_TIMEOUT = Time.seconds((long)30L);
    private final Object lock = new Object();
    private final Configuration configuration;
    private final CompletableFuture<ApplicationStatus> terminationFuture;
    private final AtomicBoolean isShutDown = new AtomicBoolean(false);
    @GuardedBy(value="lock")
    private DispatcherResourceManagerComponent clusterComponent;
    @GuardedBy(value="lock")
    private MetricRegistryImpl metricRegistry;
    @GuardedBy(value="lock")
    private ProcessMetricGroup processMetricGroup;
    @GuardedBy(value="lock")
    private HighAvailabilityServices haServices;
    @GuardedBy(value="lock")
    private BlobServer blobServer;
    @GuardedBy(value="lock")
    private HeartbeatServices heartbeatServices;
    @GuardedBy(value="lock")
    private RpcService commonRpcService;
    @GuardedBy(value="lock")
    private ExecutorService ioExecutor;
    private ExecutionGraphInfoStore executionGraphInfoStore;
    private final Thread shutDownHook;

    protected ClusterEntrypoint(Configuration configuration) {
        this.configuration = this.generateClusterConfiguration(configuration);
        this.terminationFuture = new CompletableFuture();
        if (configuration.get(JobManagerOptions.SCHEDULER_MODE) == SchedulerExecutionMode.REACTIVE && !this.supportsReactiveMode()) {
            String msg = "Reactive mode is configured for an unsupported cluster type. At the moment, reactive mode is only supported by standalone application clusters (bin/standalone-job.sh).";
            LOG.error("Reactive mode is configured for an unsupported cluster type. At the moment, reactive mode is only supported by standalone application clusters (bin/standalone-job.sh).");
            throw new IllegalConfigurationException("Reactive mode is configured for an unsupported cluster type. At the moment, reactive mode is only supported by standalone application clusters (bin/standalone-job.sh).");
        }
        this.shutDownHook = ShutdownHookUtil.addShutdownHook(() -> this.closeAsync().join(), (String)this.getClass().getSimpleName(), (Logger)LOG);
    }

    public CompletableFuture<ApplicationStatus> getTerminationFuture() {
        return this.terminationFuture;
    }

    public void startCluster() throws ClusterEntrypointException {
        LOG.info("Starting {}.", (Object)this.getClass().getSimpleName());
        try {
            FlinkSecurityManager.setFromConfiguration((Configuration)this.configuration);
            PluginManager pluginManager = PluginUtils.createPluginManagerFromRootFolder((Configuration)this.configuration);
            this.configureFileSystems(this.configuration, pluginManager);
            SecurityContext securityContext = this.installSecurityContext(this.configuration);
            securityContext.runSecured(() -> {
                this.runCluster(this.configuration, pluginManager);
                return null;
            });
        }
        catch (Throwable t) {
            Throwable strippedThrowable = ExceptionUtils.stripException((Throwable)t, UndeclaredThrowableException.class);
            try {
                this.shutDownAsync(ApplicationStatus.FAILED, ShutdownBehaviour.STOP_APPLICATION, ExceptionUtils.stringifyException((Throwable)strippedThrowable), false).get(INITIALIZATION_SHUTDOWN_TIMEOUT.toMilliseconds(), TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                strippedThrowable.addSuppressed(e);
            }
            throw new ClusterEntrypointException(String.format("Failed to initialize the cluster entrypoint %s.", this.getClass().getSimpleName()), strippedThrowable);
        }
    }

    protected boolean supportsReactiveMode() {
        return false;
    }

    private void configureFileSystems(Configuration configuration, PluginManager pluginManager) {
        LOG.info("Install default filesystem.");
        FileSystem.initialize((Configuration)configuration, (PluginManager)pluginManager);
    }

    private SecurityContext installSecurityContext(Configuration configuration) throws Exception {
        LOG.info("Install security context.");
        SecurityUtils.install((SecurityConfiguration)new SecurityConfiguration(configuration));
        return SecurityUtils.getInstalledContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runCluster(Configuration configuration, PluginManager pluginManager) throws Exception {
        Object object = this.lock;
        synchronized (object) {
            this.initializeServices(configuration, pluginManager);
            configuration.setString((ConfigOption<String>)JobManagerOptions.ADDRESS, this.commonRpcService.getAddress());
            configuration.setInteger((ConfigOption<Integer>)JobManagerOptions.PORT, this.commonRpcService.getPort());
            DispatcherResourceManagerComponentFactory dispatcherResourceManagerComponentFactory = this.createDispatcherResourceManagerComponentFactory(configuration);
            this.clusterComponent = dispatcherResourceManagerComponentFactory.create(configuration, (Executor)this.ioExecutor, this.commonRpcService, this.haServices, this.blobServer, this.heartbeatServices, (MetricRegistry)this.metricRegistry, this.executionGraphInfoStore, (MetricQueryServiceRetriever)new RpcMetricQueryServiceRetriever(this.metricRegistry.getMetricQueryServiceRpcService()), (FatalErrorHandler)this);
            this.clusterComponent.getShutDownFuture().whenComplete((applicationStatus, throwable) -> {
                if (throwable != null) {
                    this.shutDownAsync(ApplicationStatus.UNKNOWN, ShutdownBehaviour.STOP_APPLICATION, ExceptionUtils.stringifyException((Throwable)throwable), false);
                } else {
                    this.shutDownAsync((ApplicationStatus)applicationStatus, ShutdownBehaviour.STOP_APPLICATION, null, true);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializeServices(Configuration configuration, PluginManager pluginManager) throws Exception {
        LOG.info("Initializing cluster services.");
        Object object = this.lock;
        synchronized (object) {
            this.commonRpcService = AkkaRpcServiceUtils.createRemoteRpcService(configuration, configuration.getString((ConfigOption<String>)JobManagerOptions.ADDRESS), this.getRPCPortRange(configuration), configuration.getString((ConfigOption<String>)JobManagerOptions.BIND_HOST), configuration.getOptional(JobManagerOptions.RPC_BIND_PORT));
            JMXService.startInstance((String)configuration.getString((ConfigOption<String>)JMXServerOptions.JMX_SERVER_PORT));
            configuration.setString((ConfigOption<String>)JobManagerOptions.ADDRESS, this.commonRpcService.getAddress());
            configuration.setInteger((ConfigOption<Integer>)JobManagerOptions.PORT, this.commonRpcService.getPort());
            if (this.ioExecutor == null) {
                this.ioExecutor = Executors.newFixedThreadPool(ClusterEntrypointUtils.getPoolSize((Configuration)configuration), (ThreadFactory)new ExecutorThreadFactory("cluster-io"));
            }
            this.haServices = this.createHaServices(configuration, this.ioExecutor);
            this.blobServer = new BlobServer(configuration, this.haServices.createBlobStore());
            this.blobServer.start();
            this.heartbeatServices = this.createHeartbeatServices(configuration);
            this.metricRegistry = this.createMetricRegistry(configuration, pluginManager);
            RpcService metricQueryServiceRpcService = MetricUtils.startRemoteMetricsRpcService(configuration, this.commonRpcService.getAddress());
            this.metricRegistry.startQueryService(metricQueryServiceRpcService, null);
            String hostname = RpcUtils.getHostname((RpcService)this.commonRpcService);
            this.processMetricGroup = MetricUtils.instantiateProcessMetricGroup((MetricRegistry)this.metricRegistry, hostname, ConfigurationUtils.getSystemResourceMetricsProbingInterval((Configuration)configuration));
            this.executionGraphInfoStore = this.createSerializableExecutionGraphStore(configuration, this.commonRpcService.getScheduledExecutor());
        }
    }

    protected String getRPCPortRange(Configuration configuration) {
        if (ZooKeeperUtils.isZooKeeperRecoveryMode(configuration)) {
            return configuration.getString((ConfigOption<String>)HighAvailabilityOptions.HA_JOB_MANAGER_PORT_RANGE);
        }
        return String.valueOf(configuration.getInteger((ConfigOption<Integer>)JobManagerOptions.PORT));
    }

    protected HighAvailabilityServices createHaServices(Configuration configuration, Executor executor) throws Exception {
        return HighAvailabilityServicesUtils.createHighAvailabilityServices((Configuration)configuration, (Executor)executor, (HighAvailabilityServicesUtils.AddressResolution)HighAvailabilityServicesUtils.AddressResolution.NO_ADDRESS_RESOLUTION);
    }

    protected HeartbeatServices createHeartbeatServices(Configuration configuration) {
        return HeartbeatServices.fromConfiguration((Configuration)configuration);
    }

    protected MetricRegistryImpl createMetricRegistry(Configuration configuration, PluginManager pluginManager) {
        return new MetricRegistryImpl(MetricRegistryConfiguration.fromConfiguration((Configuration)configuration), (Collection)ReporterSetup.fromConfiguration((Configuration)configuration, (PluginManager)pluginManager));
    }

    public CompletableFuture<Void> closeAsync() {
        ShutdownHookUtil.removeShutdownHook((Thread)this.shutDownHook, (String)this.getClass().getSimpleName(), (Logger)LOG);
        return this.shutDownAsync(ApplicationStatus.UNKNOWN, ShutdownBehaviour.STOP_PROCESS, "Cluster entrypoint has been closed externally.", false).thenAccept(ignored -> {});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CompletableFuture<Void> stopClusterServices(boolean cleanupHaData) {
        long shutdownTimeout = this.configuration.getLong(ClusterOptions.CLUSTER_SERVICES_SHUTDOWN_TIMEOUT);
        Object object = this.lock;
        synchronized (object) {
            Throwable exception = null;
            ArrayList<CompletableFuture> terminationFutures = new ArrayList<CompletableFuture>(3);
            if (this.blobServer != null) {
                try {
                    this.blobServer.close();
                }
                catch (Throwable t) {
                    exception = ExceptionUtils.firstOrSuppressed((Throwable)t, exception);
                }
            }
            if (this.haServices != null) {
                try {
                    if (cleanupHaData) {
                        this.haServices.closeAndCleanupAllData();
                    } else {
                        this.haServices.close();
                    }
                }
                catch (Throwable t) {
                    exception = ExceptionUtils.firstOrSuppressed((Throwable)t, (Throwable)exception);
                }
            }
            if (this.executionGraphInfoStore != null) {
                try {
                    this.executionGraphInfoStore.close();
                }
                catch (Throwable t) {
                    exception = ExceptionUtils.firstOrSuppressed((Throwable)t, (Throwable)exception);
                }
            }
            if (this.processMetricGroup != null) {
                this.processMetricGroup.close();
            }
            if (this.metricRegistry != null) {
                terminationFutures.add(this.metricRegistry.shutdown());
            }
            if (this.ioExecutor != null) {
                terminationFutures.add(ExecutorUtils.nonBlockingShutdown((long)shutdownTimeout, (TimeUnit)TimeUnit.MILLISECONDS, (ExecutorService[])new ExecutorService[]{this.ioExecutor}));
            }
            if (this.commonRpcService != null) {
                terminationFutures.add(this.commonRpcService.stopService());
            }
            try {
                JMXService.stopInstance();
            }
            catch (Throwable t) {
                exception = ExceptionUtils.firstOrSuppressed((Throwable)t, (Throwable)exception);
            }
            if (exception != null) {
                terminationFutures.add(FutureUtils.completedExceptionally((Throwable)exception));
            }
            return FutureUtils.completeAll(terminationFutures);
        }
    }

    public void onFatalError(Throwable exception) {
        ClusterEntryPointExceptionUtils.tryEnrichClusterEntryPointError((Throwable)exception);
        LOG.error("Fatal error occurred in the cluster entrypoint.", exception);
        FlinkSecurityManager.forceProcessExit((int)2);
    }

    private Configuration generateClusterConfiguration(Configuration configuration) {
        Configuration resultConfiguration = new Configuration((Configuration)Preconditions.checkNotNull((Object)configuration));
        String webTmpDir = configuration.getString((ConfigOption<String>)WebOptions.TMP_DIR);
        File uniqueWebTmpDir = new File(webTmpDir, "flink-web-" + UUID.randomUUID());
        resultConfiguration.setString((ConfigOption<String>)WebOptions.TMP_DIR, uniqueWebTmpDir.getAbsolutePath());
        return resultConfiguration;
    }

    private CompletableFuture<ApplicationStatus> shutDownAsync(ApplicationStatus applicationStatus, ShutdownBehaviour shutdownBehaviour, @Nullable String diagnostics, boolean cleanupHaData) {
        if (this.isShutDown.compareAndSet(false, true)) {
            LOG.info("Shutting {} down with application status {}. Diagnostics {}.", new Object[]{this.getClass().getSimpleName(), applicationStatus, diagnostics});
            CompletableFuture<Void> shutDownApplicationFuture = this.closeClusterComponent(applicationStatus, shutdownBehaviour, diagnostics);
            CompletableFuture serviceShutdownFuture = FutureUtils.composeAfterwards(shutDownApplicationFuture, () -> this.stopClusterServices(cleanupHaData));
            CompletableFuture cleanupDirectoriesFuture = FutureUtils.runAfterwards((CompletableFuture)serviceShutdownFuture, this::cleanupDirectories);
            cleanupDirectoriesFuture.whenComplete((ignored2, serviceThrowable) -> {
                if (serviceThrowable != null) {
                    this.terminationFuture.completeExceptionally((Throwable)serviceThrowable);
                } else {
                    this.terminationFuture.complete(applicationStatus);
                }
            });
        }
        return this.terminationFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<Void> closeClusterComponent(ApplicationStatus applicationStatus, ShutdownBehaviour shutdownBehaviour, @Nullable String diagnostics) {
        Object object = this.lock;
        synchronized (object) {
            if (this.clusterComponent != null) {
                switch (shutdownBehaviour) {
                    case STOP_APPLICATION: {
                        return this.clusterComponent.stopApplication(applicationStatus, diagnostics);
                    }
                }
                return this.clusterComponent.stopProcess();
            }
            return CompletableFuture.completedFuture(null);
        }
    }

    protected void cleanupDirectories() throws IOException {
        String webTmpDir = this.configuration.getString((ConfigOption<String>)WebOptions.TMP_DIR);
        FileUtils.deleteDirectory((File)new File(webTmpDir));
    }

    protected abstract DispatcherResourceManagerComponentFactory createDispatcherResourceManagerComponentFactory(Configuration var1) throws IOException;

    protected abstract ExecutionGraphInfoStore createSerializableExecutionGraphStore(Configuration var1, ScheduledExecutor var2) throws IOException;

    protected static EntrypointClusterConfiguration parseArguments(String[] args) throws FlinkParseException {
        CommandLineParser clusterConfigurationParser = new CommandLineParser((ParserResultFactory)new EntrypointClusterConfigurationParserFactory());
        return (EntrypointClusterConfiguration)clusterConfigurationParser.parse(args);
    }

    protected static Configuration loadConfiguration(EntrypointClusterConfiguration entrypointClusterConfiguration) {
        String hostname;
        Configuration dynamicProperties = ConfigurationUtils.createConfiguration((Properties)entrypointClusterConfiguration.getDynamicProperties());
        Configuration configuration = GlobalConfiguration.loadConfiguration((String)entrypointClusterConfiguration.getConfigDir(), (Configuration)dynamicProperties);
        int restPort = entrypointClusterConfiguration.getRestPort();
        if (restPort >= 0) {
            configuration.setInteger((ConfigOption<Integer>)RestOptions.PORT, restPort);
        }
        if ((hostname = entrypointClusterConfiguration.getHostname()) != null) {
            configuration.setString((ConfigOption<String>)JobManagerOptions.ADDRESS, hostname);
        }
        return configuration;
    }

    public static void runClusterEntrypoint(ClusterEntrypoint clusterEntrypoint) {
        int returnCode;
        String clusterEntrypointName = clusterEntrypoint.getClass().getSimpleName();
        try {
            clusterEntrypoint.startCluster();
        }
        catch (ClusterEntrypointException e) {
            LOG.error(String.format("Could not start cluster entrypoint %s.", clusterEntrypointName), (Throwable)e);
            System.exit(1);
        }
        Throwable throwable = null;
        try {
            returnCode = clusterEntrypoint.getTerminationFuture().get().processExitCode();
        }
        catch (Throwable e) {
            throwable = ExceptionUtils.stripExecutionException((Throwable)e);
            returnCode = 2;
        }
        LOG.info("Terminating cluster entrypoint process {} with exit code {}.", new Object[]{clusterEntrypointName, returnCode, throwable});
        System.exit(returnCode);
    }

    private static enum ShutdownBehaviour {
        STOP_APPLICATION,
        STOP_PROCESS;

    }

    public static enum ExecutionMode {
        NORMAL,
        DETACHED;

    }
}

