/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.messages.webmonitor;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Objects;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.runtime.messages.webmonitor.JobDetails;
import org.apache.flink.runtime.rest.messages.ResponseBody;
import org.apache.flink.util.Preconditions;

public class MultipleJobsDetails
implements ResponseBody,
Serializable {
    private static final long serialVersionUID = -1526236139616019127L;
    public static final String FIELD_NAME_JOBS = "jobs";
    @JsonProperty(value="jobs")
    private final Collection<JobDetails> jobs;
    private final int maxSize = Integer.getInteger("algox.monitor.maxCompletedjobs", 200);

    @JsonCreator
    public MultipleJobsDetails(@JsonProperty(value="jobs") Collection<JobDetails> jobs) {
        if (jobs.size() > this.maxSize) {
            ArrayList<JobDetails> list = new ArrayList<JobDetails>();
            ArrayList<JobDetails> completedJobs = new ArrayList<JobDetails>();
            int failedCount = 0;
            for (JobDetails jobDetail : jobs) {
                if (jobDetail.getStatus() == JobStatus.RUNNING) {
                    list.add(jobDetail);
                    continue;
                }
                completedJobs.add(jobDetail);
                if (jobDetail.getStatus() != JobStatus.FAILED) continue;
                ++failedCount;
            }
            completedJobs.sort(new Comparator<JobDetails>(){

                @Override
                public int compare(JobDetails o1, JobDetails o2) {
                    return (int)(o2.getEndTime() - o1.getEndTime());
                }
            });
            int finishedMax = this.maxSize - failedCount;
            int f0 = 0;
            int f1 = 0;
            for (JobDetails jobDetail : completedJobs) {
                if (jobDetail.getStatus() == JobStatus.FINISHED && f0++ < finishedMax) {
                    list.add(jobDetail);
                    continue;
                }
                if (jobDetail.getStatus() != JobStatus.FAILED || f1++ >= failedCount) continue;
                list.add(jobDetail);
            }
            this.jobs = list;
        } else {
            this.jobs = (Collection)Preconditions.checkNotNull(jobs);
        }
    }

    public Collection<JobDetails> getJobs() {
        return this.jobs;
    }

    public String toString() {
        return "MultipleJobsDetails{jobs=" + this.jobs + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MultipleJobsDetails that = (MultipleJobsDetails)o;
        return Objects.equals(this.jobs, that.jobs);
    }

    public int hashCode() {
        return Objects.hash(this.jobs);
    }
}

