/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager;

import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import kd.bos.ha.manager.ServerManager;
import kd.bos.service.register.ServiceRegister;
import kd.bos.util.ConfigurationUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.clusterframework.ApplicationStatus;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.entrypoint.ClusterInformation;
import org.apache.flink.runtime.heartbeat.HeartbeatServices;
import org.apache.flink.runtime.highavailability.HighAvailabilityServices;
import org.apache.flink.runtime.io.network.partition.ResourceManagerPartitionTrackerFactory;
import org.apache.flink.runtime.metrics.groups.ResourceManagerMetricGroup;
import org.apache.flink.runtime.resourcemanager.JobLeaderIdService;
import org.apache.flink.runtime.resourcemanager.ResourceManager;
import org.apache.flink.runtime.resourcemanager.WorkerResourceSpec;
import org.apache.flink.runtime.resourcemanager.exceptions.ResourceManagerException;
import org.apache.flink.runtime.resourcemanager.slotmanager.SlotManager;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.util.Preconditions;

public class StandaloneResourceManager
extends ResourceManager<ResourceID> {
    private final Time startupPeriodTime;

    public StandaloneResourceManager(RpcService rpcService, ResourceID resourceId, HighAvailabilityServices highAvailabilityServices, HeartbeatServices heartbeatServices, SlotManager slotManager, ResourceManagerPartitionTrackerFactory clusterPartitionTrackerFactory, JobLeaderIdService jobLeaderIdService, ClusterInformation clusterInformation, FatalErrorHandler fatalErrorHandler, ResourceManagerMetricGroup resourceManagerMetricGroup, Time startupPeriodTime, Time rpcTimeout, Executor ioExecutor) {
        super(rpcService, resourceId, highAvailabilityServices, heartbeatServices, slotManager, clusterPartitionTrackerFactory, jobLeaderIdService, clusterInformation, fatalErrorHandler, resourceManagerMetricGroup, rpcTimeout, ioExecutor);
        this.startupPeriodTime = (Time)Preconditions.checkNotNull((Object)startupPeriodTime);
    }

    @Override
    protected void initialize() throws ResourceManagerException {
    }

    @Override
    protected void terminate() {
    }

    @Override
    protected void internalDeregisterApplication(ApplicationStatus finalStatus, @Nullable String diagnostics) {
    }

    @Override
    public boolean startNewWorker(WorkerResourceSpec workerResourceSpec) {
        return false;
    }

    @Override
    public boolean stopWorker(ResourceID resourceID) {
        return false;
    }

    @Override
    protected ResourceID workerStarted(ResourceID resourceID) {
        return resourceID;
    }

    @Override
    protected void onLeadership() {
        this.startStartupPeriod();
        ServiceRegister.registerService((String)"MasterRpcService", (String)this.getRegisterConfig());
        ServerManager.getManager().resumeServer();
    }

    @Override
    protected void onRevokeLeadership() {
        ServerManager.getManager().pauseServer();
    }

    private String getRegisterConfig() {
        String defaultAppIds = ConfigurationUtil.getString((String)"algox.cluster.region", (String)"default");
        StringBuilder config = new StringBuilder();
        config.append("interface=kd.bos.algox.flink.rpc.MasterRpcService\n").append("class=kd.bos.algox.flink.rpc.MasterRpcServiceImpl");
        if (StringUtils.isNotEmpty((String)defaultAppIds)) {
            config.append('\n').append("appIds=").append(defaultAppIds);
        }
        return config.toString();
    }

    private void startStartupPeriod() {
        this.setFailUnfulfillableRequest(false);
        long startupPeriodMillis = this.startupPeriodTime.toMilliseconds();
        if (startupPeriodMillis > 0L) {
            this.scheduleRunAsync(() -> this.setFailUnfulfillableRequest(true), startupPeriodMillis, TimeUnit.MILLISECONDS);
        }
    }
}

