/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import kd.bos.zk.ZKFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.ACLProvider;
import org.apache.curator.framework.imps.DefaultACLProvider;
import org.apache.curator.framework.recipes.cache.PathChildrenCache;
import org.apache.curator.framework.state.ConnectionStateErrorPolicy;
import org.apache.curator.framework.state.SessionConnectionStateErrorPolicy;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.HighAvailabilityOptions;
import org.apache.flink.configuration.IllegalConfigurationException;
import org.apache.flink.configuration.SecurityOptions;
import org.apache.flink.runtime.checkpoint.CheckpointStoreUtil;
import org.apache.flink.runtime.checkpoint.CompletedCheckpointStore;
import org.apache.flink.runtime.checkpoint.DefaultCompletedCheckpointStore;
import org.apache.flink.runtime.checkpoint.DefaultLastStateConnectionStateListener;
import org.apache.flink.runtime.checkpoint.LastStateConnectionStateListener;
import org.apache.flink.runtime.checkpoint.ZooKeeperCheckpointIDCounter;
import org.apache.flink.runtime.checkpoint.ZooKeeperCheckpointStoreUtil;
import org.apache.flink.runtime.highavailability.HighAvailabilityServicesUtils;
import org.apache.flink.runtime.jobmanager.DefaultJobGraphStore;
import org.apache.flink.runtime.jobmanager.HighAvailabilityMode;
import org.apache.flink.runtime.jobmanager.JobGraphStore;
import org.apache.flink.runtime.jobmanager.JobGraphStoreUtil;
import org.apache.flink.runtime.jobmanager.ZooKeeperJobGraphStoreUtil;
import org.apache.flink.runtime.jobmanager.ZooKeeperJobGraphStoreWatcher;
import org.apache.flink.runtime.leaderelection.DefaultLeaderElectionService;
import org.apache.flink.runtime.leaderelection.LeaderElectionDriverFactory;
import org.apache.flink.runtime.leaderelection.ZooKeeperLeaderElectionDriverFactory;
import org.apache.flink.runtime.leaderretrieval.DefaultLeaderRetrievalService;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalDriverFactory;
import org.apache.flink.runtime.leaderretrieval.ZooKeeperLeaderRetrievalDriverFactory;
import org.apache.flink.runtime.persistence.RetrievableStateStorageHelper;
import org.apache.flink.runtime.persistence.filesystem.FileSystemStateStorageHelper;
import org.apache.flink.runtime.zookeeper.ZooKeeperStateHandleStore;
import org.apache.flink.util.Preconditions;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Id;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ZooKeeperUtils.class);
    public static final String HA_STORAGE_SUBMITTED_JOBGRAPH_PREFIX = "submittedJobGraph";
    public static final String HA_STORAGE_COMPLETED_CHECKPOINT = "completedCheckpoint";
    private static final String ZKSCHEME_STR = "scheme";
    private static final String ZKUSER_STR = "user";
    private static final String ZKPASS_STR = "password";

    public static CuratorFramework startCuratorFramework(Configuration configuration) {
        Object aclProvider;
        Preconditions.checkNotNull((Object)configuration, (String)"configuration");
        String zkQuorum = configuration.getValue(HighAvailabilityOptions.HA_ZOOKEEPER_QUORUM);
        if (zkQuorum == null || StringUtils.isBlank((CharSequence)zkQuorum)) {
            throw new RuntimeException("No valid ZooKeeper quorum has been specified. You can specify the quorum via the configuration key '" + HighAvailabilityOptions.HA_ZOOKEEPER_QUORUM.key() + "'.");
        }
        Map<String, String> urlInfoMap = ZooKeeperUtils.parseUrl(zkQuorum);
        String zkUrl = urlInfoMap.get("zkaddreass");
        int sessionTimeout = configuration.getInteger((ConfigOption<Integer>)HighAvailabilityOptions.ZOOKEEPER_SESSION_TIMEOUT);
        int connectionTimeout = configuration.getInteger((ConfigOption<Integer>)HighAvailabilityOptions.ZOOKEEPER_CONNECTION_TIMEOUT);
        int retryWait = configuration.getInteger((ConfigOption<Integer>)HighAvailabilityOptions.ZOOKEEPER_RETRY_WAIT);
        int maxRetryAttempts = configuration.getInteger((ConfigOption<Integer>)HighAvailabilityOptions.ZOOKEEPER_MAX_RETRY_ATTEMPTS);
        String root = configuration.getValue(HighAvailabilityOptions.HA_ZOOKEEPER_ROOT);
        String namespace = configuration.getValue(HighAvailabilityOptions.HA_CLUSTER_ID);
        boolean disableSaslClient = configuration.getBoolean((ConfigOption<Boolean>)SecurityOptions.ZOOKEEPER_SASL_DISABLE);
        ZkClientACLMode aclMode = ZkClientACLMode.fromConfig(configuration);
        if (disableSaslClient && aclMode == ZkClientACLMode.CREATOR) {
            String errorMessage = "Cannot set ACL role to " + (Object)((Object)aclMode) + "  since SASL authentication is disabled through the " + SecurityOptions.ZOOKEEPER_SASL_DISABLE.key() + " property";
            LOG.warn(errorMessage);
            throw new IllegalConfigurationException(errorMessage);
        }
        CuratorFrameworkFactory.Builder builder = CuratorFrameworkFactory.builder();
        String user = urlInfoMap.get(ZKUSER_STR);
        String pass = urlInfoMap.get(ZKPASS_STR);
        if (user != null && pass != null) {
            LOG.info("Enforcing creator for ZK connections");
            final String auth = user + ":" + pass;
            builder.authorization(urlInfoMap.get(ZKSCHEME_STR), auth.getBytes());
            aclProvider = new ACLProvider(){
                private List<ACL> acl;

                public List<ACL> getDefaultAcl() {
                    if (this.acl == null) {
                        ArrayList acl = ZooDefs.Ids.CREATOR_ALL_ACL;
                        acl.clear();
                        acl.add(new ACL(31, new Id("auth", auth)));
                        this.acl = acl;
                    }
                    return this.acl;
                }

                public List<ACL> getAclForPath(String path) {
                    return this.acl;
                }
            };
        } else {
            LOG.info("Enforcing default ACL for ZK connections");
            aclProvider = new DefaultACLProvider();
        }
        String rootWithNamespace = ZooKeeperUtils.generateZookeeperPath(root, namespace);
        LOG.info("Using '{}' as Zookeeper namespace.", (Object)rootWithNamespace);
        CuratorFramework cf = builder.connectString(zkUrl).sessionTimeoutMs(sessionTimeout).connectionTimeoutMs(connectionTimeout).retryPolicy((RetryPolicy)new ExponentialBackoffRetry(retryWait, maxRetryAttempts)).connectionStateErrorPolicy((ConnectionStateErrorPolicy)new SessionConnectionStateErrorPolicy()).namespace(rootWithNamespace.startsWith("/") ? rootWithNamespace.substring(1) : rootWithNamespace).aclProvider((ACLProvider)aclProvider).build();
        cf.start();
        return cf;
    }

    public static boolean isZooKeeperRecoveryMode(Configuration flinkConf) {
        return HighAvailabilityMode.fromConfig((Configuration)flinkConf).equals((Object)HighAvailabilityMode.ZOOKEEPER);
    }

    private static Map<String, String> parseUrl(String url) {
        try {
            Method parseUrlMethod = ZKFactory.class.getDeclaredMethod("parseUrl", String.class);
            parseUrlMethod.setAccessible(true);
            return (Map)parseUrlMethod.invoke(null, url);
        }
        catch (Exception ex) {
            String errorMessage = "Cannot parseUrl zkUrl=" + url;
            LOG.warn(errorMessage);
            throw new IllegalConfigurationException(errorMessage);
        }
    }

    public static String getZooKeeperEnsemble(Configuration flinkConf) throws IllegalConfigurationException {
        String zkQuorum = flinkConf.getValue(HighAvailabilityOptions.HA_ZOOKEEPER_QUORUM);
        if (zkQuorum == null || StringUtils.isBlank((CharSequence)zkQuorum)) {
            throw new IllegalConfigurationException("No ZooKeeper quorum specified in config.");
        }
        zkQuorum = zkQuorum.replaceAll("\\s+", "");
        return zkQuorum;
    }

    public static DefaultLeaderRetrievalService createLeaderRetrievalService(CuratorFramework client, Configuration configuration) {
        return ZooKeeperUtils.createLeaderRetrievalService(client, configuration, "");
    }

    public static DefaultLeaderRetrievalService createLeaderRetrievalService(CuratorFramework client, Configuration configuration, String pathSuffix) {
        return new DefaultLeaderRetrievalService((LeaderRetrievalDriverFactory)ZooKeeperUtils.createLeaderRetrievalDriverFactory(client, configuration, pathSuffix));
    }

    public static ZooKeeperLeaderRetrievalDriverFactory createLeaderRetrievalDriverFactory(CuratorFramework client, Configuration configuration) {
        return ZooKeeperUtils.createLeaderRetrievalDriverFactory(client, configuration, "");
    }

    public static ZooKeeperLeaderRetrievalDriverFactory createLeaderRetrievalDriverFactory(CuratorFramework client, Configuration configuration, String pathSuffix) {
        String leaderPath = configuration.getString((ConfigOption<String>)HighAvailabilityOptions.HA_ZOOKEEPER_LEADER_PATH) + pathSuffix;
        return new ZooKeeperLeaderRetrievalDriverFactory(client, leaderPath);
    }

    public static DefaultLeaderElectionService createLeaderElectionService(CuratorFramework client, Configuration configuration) {
        return ZooKeeperUtils.createLeaderElectionService(client, configuration, "");
    }

    public static DefaultLeaderElectionService createLeaderElectionService(CuratorFramework client, Configuration configuration, String pathSuffix) {
        return new DefaultLeaderElectionService((LeaderElectionDriverFactory)ZooKeeperUtils.createLeaderElectionDriverFactory(client, configuration, pathSuffix));
    }

    public static ZooKeeperLeaderElectionDriverFactory createLeaderElectionDriverFactory(CuratorFramework client, Configuration configuration) {
        return ZooKeeperUtils.createLeaderElectionDriverFactory(client, configuration, "");
    }

    public static ZooKeeperLeaderElectionDriverFactory createLeaderElectionDriverFactory(CuratorFramework client, Configuration configuration, String pathSuffix) {
        String latchPath = configuration.getString((ConfigOption<String>)HighAvailabilityOptions.HA_ZOOKEEPER_LATCH_PATH) + pathSuffix;
        String leaderPath = configuration.getString((ConfigOption<String>)HighAvailabilityOptions.HA_ZOOKEEPER_LEADER_PATH) + pathSuffix;
        return new ZooKeeperLeaderElectionDriverFactory(client, latchPath, leaderPath);
    }

    public static JobGraphStore createJobGraphs(CuratorFramework client, Configuration configuration) throws Exception {
        Preconditions.checkNotNull((Object)configuration, (String)"Configuration");
        FileSystemStateStorageHelper stateStorage = ZooKeeperUtils.createFileSystemStateStorage(configuration, HA_STORAGE_SUBMITTED_JOBGRAPH_PREFIX);
        String zooKeeperJobsPath = configuration.getString((ConfigOption<String>)HighAvailabilityOptions.HA_ZOOKEEPER_JOBGRAPHS_PATH);
        client.newNamespaceAwareEnsurePath(zooKeeperJobsPath).ensure(client.getZookeeperClient());
        CuratorFramework facade = client.usingNamespace(client.getNamespace() + zooKeeperJobsPath);
        String zooKeeperFullJobsPath = client.getNamespace() + zooKeeperJobsPath;
        ZooKeeperStateHandleStore zooKeeperStateHandleStore = new ZooKeeperStateHandleStore(facade, stateStorage);
        PathChildrenCache pathCache = new PathChildrenCache(facade, "/", false);
        return new DefaultJobGraphStore(zooKeeperStateHandleStore, new ZooKeeperJobGraphStoreWatcher(pathCache), (JobGraphStoreUtil)ZooKeeperJobGraphStoreUtil.INSTANCE);
    }

    public static CompletedCheckpointStore createCompletedCheckpoints(CuratorFramework client, Configuration configuration, JobID jobId, int maxNumberOfCheckpointsToRetain, Executor executor) throws Exception {
        Preconditions.checkNotNull((Object)configuration, (String)"Configuration");
        String checkpointsPath = configuration.getString((ConfigOption<String>)HighAvailabilityOptions.HA_ZOOKEEPER_CHECKPOINTS_PATH);
        FileSystemStateStorageHelper stateStorage = ZooKeeperUtils.createFileSystemStateStorage(configuration, HA_STORAGE_COMPLETED_CHECKPOINT);
        checkpointsPath = checkpointsPath + ZooKeeperUtils.getPathForJob(jobId);
        ZooKeeperStateHandleStore completedCheckpointStateHandleStore = ZooKeeperUtils.createZooKeeperStateHandleStore(client, checkpointsPath, stateStorage);
        DefaultCompletedCheckpointStore zooKeeperCompletedCheckpointStore = new DefaultCompletedCheckpointStore(maxNumberOfCheckpointsToRetain, completedCheckpointStateHandleStore, (CheckpointStoreUtil)ZooKeeperCheckpointStoreUtil.INSTANCE, executor);
        LOG.info("Initialized {} in '{}' with {}.", new Object[]{DefaultCompletedCheckpointStore.class.getSimpleName(), completedCheckpointStateHandleStore, checkpointsPath});
        return zooKeeperCompletedCheckpointStore;
    }

    public static String getPathForJob(JobID jobId) {
        Preconditions.checkNotNull((Object)jobId, (String)"Job ID");
        return String.format("/%s", jobId);
    }

    public static <T extends Serializable> ZooKeeperStateHandleStore<T> createZooKeeperStateHandleStore(CuratorFramework client, String path, RetrievableStateStorageHelper<T> stateStorage) throws Exception {
        return new ZooKeeperStateHandleStore(ZooKeeperUtils.useNamespaceAndEnsurePath(client, path), stateStorage);
    }

    public static ZooKeeperCheckpointIDCounter createCheckpointIDCounter(CuratorFramework client, Configuration configuration, JobID jobId) {
        String checkpointIdCounterPath = configuration.getString((ConfigOption<String>)HighAvailabilityOptions.HA_ZOOKEEPER_CHECKPOINT_COUNTER_PATH);
        checkpointIdCounterPath = checkpointIdCounterPath + ZooKeeperUtils.getPathForJob(jobId);
        return new ZooKeeperCheckpointIDCounter(client, checkpointIdCounterPath, (LastStateConnectionStateListener)new DefaultLastStateConnectionStateListener());
    }

    public static <T extends Serializable> FileSystemStateStorageHelper<T> createFileSystemStateStorage(Configuration configuration, String prefix) throws IOException {
        return new FileSystemStateStorageHelper(HighAvailabilityServicesUtils.getClusterHighAvailableStoragePath((Configuration)configuration), prefix);
    }

    public static String generateZookeeperPath(String root, String namespace) {
        if (!namespace.startsWith("/")) {
            namespace = '/' + namespace;
        }
        if (namespace.endsWith("/")) {
            namespace = namespace.substring(0, namespace.length() - 1);
        }
        if (root.endsWith("/")) {
            root = root.substring(0, root.length() - 1);
        }
        return root + namespace;
    }

    public static CuratorFramework useNamespaceAndEnsurePath(CuratorFramework client, String path) throws Exception {
        Preconditions.checkNotNull((Object)client, (String)"client must not be null");
        Preconditions.checkNotNull((Object)path, (String)"path must not be null");
        client.newNamespaceAwareEnsurePath(path).ensure(client.getZookeeperClient());
        return client.usingNamespace(ZooKeeperUtils.generateZookeeperPath(client.getNamespace(), path));
    }

    private ZooKeeperUtils() {
        throw new RuntimeException();
    }

    public static enum ZkClientACLMode {
        CREATOR,
        OPEN;


        public static ZkClientACLMode fromConfig(Configuration config) {
            String aclMode = config.getString((ConfigOption<String>)HighAvailabilityOptions.ZOOKEEPER_CLIENT_ACL);
            if (aclMode == null || aclMode.equalsIgnoreCase(OPEN.name())) {
                return OPEN;
            }
            if (aclMode.equalsIgnoreCase(CREATOR.name())) {
                return CREATOR;
            }
            String message = "Unsupported ACL option: [" + aclMode + "] provided";
            LOG.error(message);
            throw new IllegalConfigurationException(message);
        }
    }

    public static class SecureAclProvider
    implements ACLProvider {
        public List<ACL> getDefaultAcl() {
            return ZooDefs.Ids.CREATOR_ALL_ACL;
        }

        public List<ACL> getAclForPath(String path) {
            return ZooDefs.Ids.CREATOR_ALL_ACL;
        }
    }
}

