/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.actiondispatcher;

import com.google.common.base.Charsets;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import kd.bos.actiondispatcher.ActionProviderSPI;
import kd.bos.actiondispatcher.Invoker;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.extension.ExtensionFactory;
import kd.bos.util.DisCardUtil;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ActionConfig {
    private static Logger logger = Logger.getLogger(ActionConfig.class);
    private static boolean loaded = false;
    private static HashMap<String, Package> packageMap = new HashMap();
    private static HashMap<String, Object> objectMap = new HashMap();
    private static HashMap<String, String> actionException = new HashMap();

    static synchronized void staticLoad() {
        if (loaded) {
            return;
        }
        try {
            ActionConfig.load();
        }
        catch (Exception e) {
            logger.error((Object)"Can't not load configuration", (Throwable)e);
        }
        loaded = true;
    }

    private static void load() {
        try {
            ActionConfig.loadFromSPI();
        }
        catch (Exception e) {
            logger.error((Object)"Can't not load loadActionFileFromSPI", (Throwable)e);
        }
        try {
            ActionConfig.loadConfiggedActionFiles();
        }
        catch (Exception e) {
            logger.error((Object)"Can't not load loadConfiggedActions", (Throwable)e);
        }
        String file = System.getProperty("ActionConfigFile");
        InputStream in = null;
        if (file == null || !new File(file).exists()) {
            try {
                in = ActionConfig.class.getResourceAsStream("/action/actionconfig.xml");
            }
            catch (Exception t) {
                logger.error((Object)"can't found actionconfig.xml");
                throw new KDException(BosErrorCode.configNotFound, new Object[]{"can't found actionconfig.xml"});
            }
        }
        try {
            in = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new KDException(BosErrorCode.configNotFound, new Object[]{"config 'ActionConfigFile' file not found."});
        }
        try {
            ActionConfig.load(in);
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.configNotFound, new Object[]{"load excepetion"});
        }
    }

    private static void loadFromSPI() {
        ExtensionFactory extensionFactory;
        ActionProviderSPI actionProviderSPI;
        String spiActionType = System.getProperty("spiAction.type");
        if (spiActionType != null && spiActionType.trim().length() > 0 && (actionProviderSPI = (ActionProviderSPI)(extensionFactory = ExtensionFactory.getExtensionFacotry(ActionProviderSPI.class)).getExtension(spiActionType)).isEnable()) {
            ActionConfig.load(actionProviderSPI.getActionFileInputStream());
        }
    }

    private static void loadConfiggedActionFiles() throws IOException {
        String line;
        String configActionFiles = System.getProperty("actionConfigFiles.config");
        if (configActionFiles == null || configActionFiles.trim().length() <= 0) {
            return;
        }
        ByteArrayInputStream is = new ByteArrayInputStream(configActionFiles.getBytes(Charsets.UTF_8));
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        while ((line = br.readLine()) != null) {
            if (line.trim().endsWith(".xml")) {
                if ((line = line.substring(0, line.length() - 4).replaceAll("\\.", "/") + ".xml").startsWith("/")) {
                    line = line.substring(1);
                }
                ActionConfig.parseInclude(line);
                continue;
            }
            logger.error((Object)("config error actionfile:\u9286\ufffd" + line));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void load(InputStream in) {
        try {
            Element ele;
            int i;
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = null;
            document = builder.parse(in);
            Element root = (Element)document.getElementsByTagName("root").item(0);
            NodeList list = root.getElementsByTagName("include");
            for (i = 0; i < list.getLength(); ++i) {
                ele = (Element)list.item(i);
                ActionConfig.parseInclude(ele);
            }
            list = root.getElementsByTagName("package");
            for (i = 0; i < list.getLength(); ++i) {
                ele = (Element)list.item(i);
                ActionConfig.parsePackage(ele);
            }
        }
        catch (Exception t) {
            logger.error((Object)t.getMessage(), (Throwable)t);
        }
        finally {
            try {
                in.close();
            }
            catch (Exception t) {
                DisCardUtil.discard();
            }
        }
    }

    private static void parseInclude(Element ele) {
        String file = ele.getAttribute("file");
        if (file == null) {
            logger.error((Object)"include must set attribute file");
            return;
        }
        try {
            ActionConfig.parseInclude(file);
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.configNotFound, new Object[]{"parseInclude faild"});
        }
    }

    private static void parseInclude(String file) {
        InputStream in = null;
        try {
            in = ActionConfig.class.getResourceAsStream("/" + file);
            if (in == null) {
                in = new FileInputStream(file);
            }
        }
        catch (Exception t) {
            logger.warn((Object)("can't found " + file));
            return;
        }
        if (in != null) {
            ActionConfig.load(in);
        }
    }

    private static void parsePackage(Element ele) {
        String name = ele.getAttribute("name");
        if (name == null) {
            name = "";
        }
        Package p = new Package();
        if ((name = name.replace('\\', '/')).startsWith("/")) {
            name = name.substring(1);
        }
        if (name.endsWith("/")) {
            name = name.substring(0, name.length() - 1);
        }
        p.name = name;
        String cls = ele.getAttribute("class");
        p.cls = cls;
        packageMap.put(name, p);
        NodeList list = ele.getElementsByTagName("action");
        for (int i = 0; i < list.getLength(); ++i) {
            Element child = (Element)list.item(i);
            ActionConfig.parseAction(child, p);
        }
    }

    private static Method findMethod(Class<?> clazz, String methodName) {
        Method found = null;
        for (Method method : clazz.getMethods()) {
            if (!methodName.equals(method.getName())) continue;
            found = method;
            break;
        }
        return found;
    }

    private static void parseAction(Element child, Package p) {
        String actionName = child.getAttribute("name");
        String actionMethod = child.getAttribute("method");
        String actionClass = child.getAttribute("class");
        if (actionMethod == null || actionMethod.length() == 0) {
            actionMethod = actionName;
        }
        if (actionClass == null || actionClass.length() == 0) {
            actionClass = p.cls;
        }
        try {
            Class<?> clazz = Class.forName(actionClass);
            Method method = null;
            method = ActionConfig.findMethod(clazz, actionMethod);
            if (method == null) {
                actionException.put(p.name + "." + actionName, "No such method:" + actionClass + "." + actionMethod);
                return;
            }
            Object instance = objectMap.get(actionClass);
            if (instance == null) {
                instance = clazz.newInstance();
                objectMap.put(actionClass, instance);
            }
            MethodInfo methodInfo = new MethodInfo();
            methodInfo.className = actionClass;
            methodInfo.method = method;
            p.actionMap.put(actionName, methodInfo);
        }
        catch (Exception b) {
            actionException.put(p.name + "." + actionName, b.toString());
            logger.warn((Object)("Error parse action " + actionName + " of package " + p.name + ", ignored."), (Throwable)b);
        }
    }

    public static boolean containsPackage(String _package) {
        return packageMap.containsKey(_package);
    }

    public static String getActionException(String _package, String action) {
        return actionException.get(_package + "." + action);
    }

    public static Invoker lookupActionInvoker(String _package, String action) {
        Package p = packageMap.get(_package);
        if (p != null) {
            MethodInfo info = (MethodInfo)p.actionMap.get(action);
            if (info == null) {
                return null;
            }
            Object object = objectMap.get(info.className);
            Invoker invoker = new Invoker(object, info.method);
            return invoker;
        }
        return null;
    }

    static {
        ActionConfig.staticLoad();
    }

    private static class MethodInfo {
        private String className;
        private Method method;

        private MethodInfo() {
        }
    }

    private static class Package {
        private String name;
        private String cls;
        private Map<String, MethodInfo> actionMap = new HashMap<String, MethodInfo>();

        private Package() {
        }
    }
}

