/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.actiondispatcher;

import java.io.IOException;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.actiondispatcher.ActionConfig;
import kd.bos.actiondispatcher.ActionUtil;
import kd.bos.actiondispatcher.Invoker;
import kd.bos.api.ApiRequestContext;
import kd.bos.armor.core.ArmorException;
import kd.bos.armor.core.slots.block.AbstractRule;
import kd.bos.armor.core.slots.block.degrade.DegradeRule;
import kd.bos.armor.core.slots.block.flow.FlowRule;
import kd.bos.audit.Audit;
import kd.bos.context.CustomRouteMap;
import kd.bos.context.RequestContext;
import kd.bos.db.tx.TX;
import kd.bos.debug.DebugInfo;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.util.ArmorExceptionHandler;
import kd.bos.mservice.util.ParsingUrlUtil;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.trace.core.InnerSpan;
import kd.bos.trace.reporter.apicall.APICallTagInject;
import kd.bos.trace.reporter.topology.TopologyTagInject;
import kd.bos.util.JSONUtils;
import kd.bos.util.NetAddressUtils;
import kd.bos.util.StringUtils;
import org.apache.commons.lang.StringEscapeUtils;

public class ActionFilter
implements Filter {
    private static Log logger = LogFactory.getLog(ActionFilter.class);
    private String localIp = NetAddressUtils.getLocalIpAddress();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        String servletPath = ActionUtil.getServletPath(httpRequest);
        httpRequest.setCharacterEncoding("UTF-8");
        RequestContext current = RequestContext.get();
        TraceSpan traceSpan = Tracer.getCurrentSpan();
        try {
            String message;
            String action;
            if (current != null && traceSpan != null) {
                String destAppId = httpRequest.getHeader("cqappid");
                destAppId = destAppId != null ? destAppId : "bos";
                TopologyTagInject.setWebTag((InnerSpan)traceSpan.getInnerSpan(), (String)TopologyTagInject.getClient((String)current.getClient()), (String)destAppId);
                APICallTagInject.setHttpTag((InnerSpan)traceSpan.getInnerSpan(), (String)httpRequest.getRemoteAddr(), (String)this.localIp, (String)"http", (String)((String)ParsingUrlUtil.parseBatchInvokeAction((String)httpRequest.getRequestURI(), (Map)httpRequest.getParameterMap()).get(0)), (String)destAppId);
            }
            ApiRequestContext.initThreadLocal(httpRequest, httpResponse);
            String requestURI = httpRequest.getRequestURI();
            if (servletPath.startsWith("//")) {
                servletPath = servletPath.substring(2);
            } else if (servletPath.startsWith("/")) {
                servletPath = servletPath.substring(1);
            }
            int pos = servletPath.lastIndexOf(47);
            String package1 = "";
            if (pos > 0) {
                package1 = servletPath.substring(0, pos);
                action = servletPath.substring(pos + 1);
            } else {
                action = servletPath;
            }
            pos = action.indexOf(".");
            if (pos > 0) {
                action = action.substring(0, pos);
            }
            if ((message = ActionConfig.getActionException(package1, action)) != null) {
                StringBuilder msgBuilder = new StringBuilder();
                msgBuilder.append(package1).append("/").append(action);
                if (ActionUtil.isShowStackTrace()) {
                    msgBuilder.append(":").append(message);
                }
                KDException e = new KDException(BosErrorCode.actionMethodNotFound, new Object[]{msgBuilder.toString()});
                ActionUtil.responseException((Throwable)e, action, requestURI, response);
                return;
            }
            if (!ActionConfig.containsPackage(package1)) {
                String s = StringEscapeUtils.escapeHtml((String)(package1 + "/" + action));
                KDException e = new KDException(BosErrorCode.actionNotFound, new Object[]{s + " not configured."});
                ActionUtil.responseException((Throwable)e, action, requestURI, response);
                return;
            }
            Invoker invoker = null;
            try {
                invoker = ActionConfig.lookupActionInvoker(package1, action);
            }
            catch (Exception t) {
                logger.error(t.getMessage(), (Throwable)t);
            }
            if (invoker == null) {
                filterChain.doFilter(request, response);
                return;
            }
            try {
                boolean debug = false;
                try {
                    String dbRouteMapString;
                    String debugId = httpRequest.getParameter("debugId");
                    if (debugId != null && debugId.length() > 0) {
                        DebugInfo di = new DebugInfo(debugId, "true".equals(httpRequest.getParameter("cmd")));
                        RequestContext.get().setDebugInfo(di);
                        DebugInfo.setupThreadDebug((DebugInfo)di);
                        debug = true;
                    }
                    if ((dbRouteMapString = httpRequest.getParameter("DBRouteMap")) != null && dbRouteMapString.length() > 0) {
                        for (String item : dbRouteMapString.split(",")) {
                            int p = item.indexOf(61);
                            if (p <= 0 || p >= item.length() - 1) continue;
                            String entityName = item.substring(0, p).trim();
                            String dbRoute = item.substring(p + 1);
                            CustomRouteMap.setDBRouteKey((String)entityName, (String)dbRoute);
                        }
                    }
                    invoker.invoke();
                }
                catch (Exception e) {
                    TX.setResponseException((Throwable)e);
                    throw e;
                }
                finally {
                    if (debug) {
                        DebugInfo.clearThreadDebug();
                    }
                    try {
                        TX.checkLeak();
                    }
                    finally {
                        Audit.finallyAudit();
                    }
                }
            }
            catch (Exception e) {
                if (this.isHandleCircuitbreakerException(e, response)) {
                    RequestContext.set(null);
                    return;
                }
                ActionUtil.responseException(e, action, requestURI, response);
            }
        }
        finally {
            RequestContext.set(null);
        }
    }

    private boolean isHandleCircuitbreakerException(Exception e, ServletResponse response) throws IOException {
        if (!Boolean.getBoolean("gov.breaker.enable")) {
            return false;
        }
        String errMsg = e.getCause().getMessage();
        if (StringUtils.isEmpty((String)errMsg)) {
            kd.bos.armor.core.Tracer.trace((Throwable)e);
            return false;
        }
        int strStartIndex = errMsg.indexOf("ArmorStart:");
        int strEndIndex = errMsg.indexOf(":ArmorEnd");
        if (strStartIndex < 0 || strEndIndex < 0) {
            kd.bos.armor.core.Tracer.trace((Throwable)e);
            return false;
        }
        String[] ruleArr = errMsg.substring(strStartIndex, strEndIndex).split("::");
        AbstractRule rule = null;
        try {
            if (ruleArr[0].contains("FlowException")) {
                rule = (AbstractRule)JSONUtils.cast((String)ruleArr[1], FlowRule.class);
            } else if (ruleArr[0].contains("DegradeException")) {
                rule = (AbstractRule)JSONUtils.cast((String)ruleArr[1], DegradeRule.class);
            }
        }
        catch (IOException ex) {
            logger.warn("ArmorRule json cast object exception:", (Throwable)e);
        }
        ArmorException armorException = new ArmorException("", rule);
        ArmorExceptionHandler.responseException((ArmorException)armorException, (ServletResponse)response);
        return true;
    }

    public void destroy() {
    }

    public void init(FilterConfig arg0) throws ServletException {
    }
}

